### 10/12/2018, Satbyeol Shin, University of Florida ###
### Goodness of Fit test (gof) for ad
#install.packages("FAdist")
library(FAdist)
#install.packages("tolerance")
library(tolerance)
#install.packages("goftest")
library(goftest)
#install.packages("classInt")
library(classInt)
### function: The Anderson-Darling Test
ad_test <- function(x,method,dist) {
  # function: ad.test.nor.dist.
  ad.nor <- function(x,method,dist) {
    d.name <- "pnorm"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    if (is.numeric(mean)==FALSE || is.numeric(sd)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,mean=mean,sd=sd), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.ln2.dist.
  ad.ln2 <- function(x,method,dist) {
    d.name <- "pnorm"
    p <- log(x)
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    if (is.numeric(mean)==FALSE || is.numeric(sd)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,mean=mean,sd=sd), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.ln3.dist.
  ad.ln3 <- function(x,method,dist) {
    d.name <- "plnorm3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.exp.dist.
  ad.exp <- function(x,method,dist) {
    d.name <- "p2exp"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shift <- fun(x)[1]
    rate <- fun(x)[2]
    if (is.numeric(rate)==FALSE || is.numeric(shift)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,rate=rate,shift=shift), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.gam2.dist.
  ad.gam2 <- function(x,method,dist) {
    d.name <- "pgamma"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.gam3.dist.
  ad.gam3 <- function(x,method,dist) {
    d.name <- "pgamma3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.lp3.dist.
  ad.lp3 <- function(x,method,dist) {
    d.name <- "pgamma3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.gev.dist.
  ad.gev <- function(x,method,dist) {
    d.name <- "pgev"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    location <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(location)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale,loc=location), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.gum.dist.
  ad.gum <- function(x,method,dist) {
    d.name <- "pgumbel"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    scale <- fun(x)[1]
    location <- fun(x)[2]
    if (is.numeric(scale)==FALSE || is.numeric(location)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,scale=scale,location=location), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.wbu2.dist.
  ad.wbu2 <- function(x,method,dist) {
    d.name <- "pweibull"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE) {
      res <- 0
    } else {
      ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale), error=function(err) NA)
      if (any(is.na(ad)==FALSE)) {
        ad.p <- format(round(ad$p.value,3))
        ad.s <- format(round(ad$statistic,3))
        res <- cbind(ad.p,ad.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: ad.test.wbu3.dist.
  ad.wbu3 <- function(x,method,dist) {
    d.name <- "pweibull3"
    p <- x
    # Parameter estimation
    if (method=="mom") {
      res <- 0
    } else {
      f.name <- paste(method,dist,sep="_")
      fun <- match.fun(f.name)
      shape <- fun(x)[1]
      scale <- fun(x)[2]
      thres <- fun(x)[3]
      if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
        res <- 0
      } else {
        ad <- tryCatch(ad.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
        if (any(is.na(ad)==FALSE)) {
          ad.p <- format(round(ad$p.value,3))
          ad.s <- format(round(ad$statistic,3))
          res <- cbind(ad.p,ad.s)
        } else { res <- 0 }
      }
    }
    return(res)
  }
  # function end #
  if (dist=="nor") { ad.test.res <- tryCatch(ad.nor(x,method,dist), error=function(err) NA) }
  else if (dist=="ln2") { ad.test.res <- tryCatch(ad.ln2(x,method,dist), error=function(err) NA) }
  else if (dist=="ln3") { ad.test.res <- tryCatch(ad.ln3(x,method,dist), error=function(err) NA) }
  else if (dist=="exp") { ad.test.res <- tryCatch(ad.exp(x,method,dist), error=function(err) NA) }
  else if (dist=="gam2") { ad.test.res <- tryCatch(ad.gam2(x,method,dist), error=function(err) NA) }
  else if (dist=="gam3") { ad.test.res <- tryCatch(ad.gam3(x,method,dist), error=function(err) NA) }
  else if (dist=="lp3") { ad.test.res <- tryCatch(ad.lp3(x,method,dist), error=function(err) NA) }
  else if (dist=="gev") { ad.test.res <- tryCatch(ad.gev(x,method,dist), error=function(err) NA) }
  else if (dist=="gum") { ad.test.res <- tryCatch(ad.gum(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu2") { ad.test.res <- tryCatch(ad.wbu2(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu3") { ad.test.res <- tryCatch(ad.wbu3(x,method,dist), error=function(err) NA) }
  return(ad.test.res)
}
### function end ###