### 10/12/2018, Satbyeol Shin, University of Florida ###
### Goodness of Fit test (gof) for Chi-Square
#install.packages("FAdist")
library(FAdist)
#install.packages("tolerance")
library(tolerance)
#install.packages("goftest")
library(goftest)
#install.packages("classInt")
library(classInt)
### function: Chi-Square test
chisq_test <- function(x,method,dist) {
  # function: chisq.test.nor.dist.
  chisq.nor <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    # Expected value
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        a.ex[i] <- pnorm(bin[i+1],mean=mean,sd=sd)-pnorm(bin[i],mean=mean,sd=sd)
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.ln2.dist.
  chisq.ln2 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        a.ex[i] <- plnorm(bin[i+1],meanlog=mean,sdlog=sd)-plnorm(bin[i],meanlog=mean,sdlog=sd)
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.ln3.dist
  chisq.ln3 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        a.ex[i] <- plnorm3(bin[i+1],shape=shape,scale=scale,thres=thres)-plnorm3(bin[i],shape=shape,scale=scale,thres=thres)
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.exp.dist
  chisq.exp <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shift <- fun(x)[1]
    rate <- fun(x)[2]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        a.ex[i] <- p2exp(bin[i+1],rate=rate,shift=shift)-p2exp(bin[i],rate=rate,shift=shift)
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.gam2.dist
  chisq.gam2 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        a.ex[i] <- pgamma(bin[i+1],shape=shape,scale=scale)-pgamma(bin[i],shape=shape,scale=scale)
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.gam3.dist
  chisq.gam3 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        a.ex[i] <- pgamma3(bin[i+1],shape=shape,scale=scale,thres=thres)-pgamma3(bin[i],shape=shape,scale=scale,thres=thres)
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.lp3.dist
  chisq.lp3 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    if (any(fun(x)==0)) { # parameter estimation failed
      res <- 0
    } else {
      shape <- fun(x)[1]
      scale <- fun(x)[2]
      thres <- fun(x)[3]
      a.ex.fun <- function(bin) {
        bin <- log(bin)
        a.ex <- numeric()
        for (i in 1:bin.no) {
          a.ex[i] <- pgamma3(bin[i+1],shape=shape,scale=scale,thres=thres)-pgamma3(bin[i],shape=shape,scale=scale,thres=thres)
          if (a.ex[i]==0) res <- 0
        }
        return(a.ex)
      }
      a.ex <- a.ex.fun(bin)
      if (any(a.ex==0)) {
        res <- 0
      } else {
        chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
        chisq.p <- chisq$p.value
        chisq.p <- format(round(chisq$p.value,3))
        chisq.s <- format(round(chisq$statistic,3))
        res <- cbind(chisq.p,chisq.s)
      }
    }
    return (res)
  }
  # function end #
  # function: chisq.test.gev.dist
  chisq.gev <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    location <- fun(x)[3]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        up <- pgev(bin[i+1],shape=shape,scale=scale,loc=location)
        low <- pgev(bin[i],shape=shape,scale=scale,loc=location)
        if (is.nan(up)==FALSE && is.nan(low)==FALSE) {
          a.ex[i] <- up - low
        } else {
          up <- 1
          a.ex[i] <- up - low
        }
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.gum.dist
  chisq.gum <- function(x,method,dist) {
    method <- "mom"
    dist <- "gum"
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    scale <- fun(x)[1]
    location <- fun(x)[2]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        up <- pgumbel(bin[i+1],scale=scale,location=location)
        low <- pgumbel(bin[i],scale=scale,location=location)
        if (is.nan(up)==FALSE && is.nan(low)==FALSE) {
          a.ex[i] <- up - low
        } else {
          up <- 1
          a.ex[i] <- up - low
        }
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.wbu2.dist
  chisq.wbu2 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    a.ex.fun <- function(bin) {
      a.ex <- numeric()
      for (i in 1:bin.no) {
        up <- pweibull(bin[i+1],shape=shape,scale=scale)
        low <- pweibull(bin[i],shape=shape,scale=scale)
        if (is.nan(up)==FALSE && is.nan(low)==FALSE) {
          a.ex[i] <- up - low
        } else {
          up <- 1
          a.ex[i] <- up - low
        }
      }
      return(a.ex)
    }
    a.ex <- a.ex.fun(bin)
    if (any(a.ex==0)) {
      res <- 0
    } else {
      chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
      chisq.p <- chisq$p.value
      chisq.p <- format(round(chisq$p.value,3))
      chisq.s <- format(round(chisq$statistic,3))
      res <- cbind(chisq.p,chisq.s)
    }
    return (res)
  }
  # function end #
  # function: chisq.test.wbu3.dist
  chisq.wbu3 <- function(x,method,dist) {
    # Equal frequency binning
    bin.no <- as.integer(1+log2(length(x)))
    bin <- classIntervals(x,bin.no,style='quantile')$brks
    a.cut <- cut(x,breaks=bin)
    a.os <-vector()
    for (i in 1:bin.no) {
      a.os[i] <- table(a.cut)[[i]]
    }
    # Parameter estimation
    if (method=="mom") {
      res <- 0
    } else {
      f.name <- paste(method,dist,sep="_")
      fun <- match.fun(f.name)
      shape <- fun(x)[1]
      scale <- fun(x)[2]
      thres <- fun(x)[3]
      if (any(fun(x)==0)) { # parameter estimation failed
        res <- 0
      }
      a.ex.fun <- function(bin) {
        a.ex <- numeric()
        for (i in 1:bin.no) {
          up <- pweibull3(bin[i+1],shape=shape,scale=scale,thres=thres)
          low <- pweibull3(bin[i],shape=shape,scale=scale,thres=thres)
          if (is.nan(up)==FALSE && is.nan(low)==FALSE) {
            a.ex[i] <- up - low
          } else {
            up <- 1
            a.ex[i] <- up - low
          }
        }
        return(a.ex)
      }
      a.ex <- a.ex.fun(bin)
      if (any(a.ex==0)) {
        res <- 0
      } else {
        chisq <- chisq.test(x=a.os,p=a.ex,rescale.p=TRUE)
        chisq.p <- chisq$p.value
        chisq.p <- format(round(chisq$p.value,3))
        chisq.s <- format(round(chisq$statistic,3))
        res <- cbind(chisq.p,chisq.s)
      }
    }
    return (res)
  }
  # function end #
  if (dist=="nor") { chisq.test.res <- tryCatch(chisq.nor(x,method,dist), error=function(err) NA) }
  else if (dist=="ln2") { chisq.test.res <- tryCatch(chisq.ln2(x,method,dist), error=function(err) NA) }
  else if (dist=="ln3") { chisq.test.res <- tryCatch(chisq.ln3(x,method,dist), error=function(err) NA) }
  else if (dist=="exp") { chisq.test.res <- tryCatch(chisq.exp(x,method,dist), error=function(err) NA) }
  else if (dist=="gam2") { chisq.test.res <- tryCatch(chisq.gam2(x,method,dist), error=function(err) NA) }
  else if (dist=="gam3") { chisq.test.res <- tryCatch(chisq.gam3(x,method,dist), error=function(err) NA) }
  else if (dist=="lp3") { chisq.test.res <- tryCatch(chisq.lp3(x,method,dist), error=function(err) NA) }
  else if (dist=="gev") { chisq.test.res <- tryCatch(chisq.gev(x,method,dist), error=function(err) NA) }
  else if (dist=="gum") { chisq.test.res <- tryCatch(chisq.gum(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu2") { chisq.test.res <- tryCatch(chisq.wbu2(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu3") { chisq.test.res <- tryCatch(chisq.wbu3(x,method,dist), error=function(err) NA) }
  return(chisq.test.res)
}
### function end ###