### 10/12/2018, Satbyeol Shin, University of Florida ###
### Goodness of Fit test (gof) for cvm
#install.packages("FAdist")
library(FAdist)
#install.packages("tolerance")
library(tolerance)
#install.packages("goftest")
library(goftest)
#install.packages("classInt")
library(classInt)
### function: Cramer-von Mises criterion
cvm_test <- function(x,method,dist) {
  # funcion: cvm.test.nor.dist.
  cvm.nor <- function(x,method,dist) {
    d.name <- "pnorm"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    if (is.numeric(mean)==FALSE || is.numeric(sd)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,mean=mean,sd=sd), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.ln2.dist.
  cvm.ln2 <- function(x,method,dist) {
    d.name <- "pnorm"
    p <- log(x)
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    if (is.numeric(mean)==FALSE || is.numeric(sd)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,mean=mean,sd=sd), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.ln3.dist.
  cvm.ln3 <- function(x,method,dist) {
    d.name <- "plnorm3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.exp.dist.
  cvm.exp <- function(x,method,dist) {
    d.name <- "p2exp"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shift <- fun(x)[1]
    rate <- fun(x)[2]
    if (is.numeric(rate)==FALSE || is.numeric(shift)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,rate=rate,shift=shift), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.gam2.dist.
  cvm.gam2 <- function(x,method,dist) {
    d.name <- "pgamma"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.gam3.dist.
  cvm.gam3 <- function(x,method,dist) {
    d.name <- "pgamma3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.lp3.dist.
  cvm.lp3 <- function(x,method,dist) {
    d.name <- "pgamma3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.gev.dist.
  cvm.gev <- function(x,method,dist) {
    d.name <- "pgev"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    location <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(location)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale,loc=location), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.gum.dist.
  cvm.gum <- function(x,method,dist) {
    d.name <- "pgumbel"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    scale <- fun(x)[1]
    location <- fun(x)[2]
    if (is.numeric(scale)==FALSE || is.numeric(location)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,scale=scale,location=location), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # function: cvm.test.wbu2.dist.
  cvm.wbu2 <- function(x,method,dist) {
    d.name <- "pweibull"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE) {
      res <- 0
    } else {
      cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale), error=function(err) NA)
      if (any(is.na(cvm)==FALSE)) {
      cvm.p <- format(round(cvm$p.value,3))
      cvm.s <- format(round(cvm$statistic,3))
      res <- cbind(cvm.p,cvm.s)
      } else { res <- 0 }
    }
    return(res)
  }
  # function end #
  # funcion: cvm.test.wbu3.dist.
  cvm.wbu3 <- function(x,method,dist) {
    d.name <- "pweibull3"
    p <- x
    # Parameter estimation
    if (method=="mom") {
      res <- 0
    } else {
      f.name <- paste(method,dist,sep="_")
      fun <- match.fun(f.name)
      shape <- fun(x)[1]
      scale <- fun(x)[2]
      thres <- fun(x)[3]
      if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
        res <- 0
      } else {
        cvm <- tryCatch(cvm.test(p,d.name,shape=shape,scale=scale,thres=thres), error=function(err) NA)
        if (any(is.na(cvm)==FALSE)) {
        cvm.p <- format(round(cvm$p.value,3))
        cvm.s <- format(round(cvm$statistic,3))
        res <- cbind(cvm.p,cvm.s)
        } else { res <- 0 }
      }
    }
    return(res)
  }
  # function end #
  if (dist=="nor") { cvm.test.res <- tryCatch(cvm.nor(x,method,dist), error=function(err) NA) }
  else if (dist=="ln2") { cvm.test.res <- tryCatch(cvm.ln2(x,method,dist), error=function(err) NA) }
  else if (dist=="ln3") { cvm.test.res <- tryCatch(cvm.ln3(x,method,dist), error=function(err) NA) }
  else if (dist=="exp") { cvm.test.res <- tryCatch(cvm.exp(x,method,dist), error=function(err) NA) }
  else if (dist=="gam2") { cvm.test.res <- tryCatch(cvm.gam2(x,method,dist), error=function(err) NA) }
  else if (dist=="gam3") { cvm.test.res <- tryCatch(cvm.gam3(x,method,dist), error=function(err) NA) }
  else if (dist=="lp3") { cvm.test.res <- tryCatch(cvm.lp3(x,method,dist), error=function(err) NA) }
  else if (dist=="gev") { cvm.test.res <- tryCatch(cvm.gev(x,method,dist), error=function(err) NA) }
  else if (dist=="gum") { cvm.test.res <- tryCatch(cvm.gum(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu2") { cvm.test.res <- tryCatch(cvm.wbu2(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu3") { cvm.test.res <- tryCatch(cvm.wbu3(x,method,dist), error=function(err) NA) }
  return(cvm.test.res)
}
### function end ###