### 10/12/2018, Satbyeol Shin, University of Florida ###
### Goodness of Fit test (gof) for K-S
#install.packages("FAdist")
library(FAdist)
#install.packages("tolerance")
library(tolerance)
#install.packages("goftest")
library(goftest)
#install.packages("classInt")
library(classInt)
### function: The kolmogorov-Smirnov Test
ks_test <- function(x,method,dist) {
  # function: ks.test.nor.dist.
  ks.nor <- function(x,method,dist) {
    d.name <- "pnorm"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    if (is.numeric(mean)==FALSE || is.numeric(sd)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,mean=mean,sd=sd)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.ln2.dist.
  ks.ln2 <- function(x,method,dist) {
    d.name <- "pnorm"
    p <- log(x)
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    mean <- fun(x)[1]
    sd <- fun(x)[2]
    if (is.numeric(mean)==FALSE || is.numeric(sd)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,mean=mean,sd=sd)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.ln3.dist.
  ks.ln3 <- function(x,method,dist) {
    d.name <- "plnorm3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,shape=shape,scale=scale,thres=thres)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.exp.dist.
  ks.exp <- function(x,method,dist) {
    d.name <- "p2exp"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shift <- fun(x)[1]
    rate <- fun(x)[2]
    if (is.numeric(rate)==FALSE || is.numeric(shift)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,rate=rate,shift=shift)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.gam2.dist.
  ks.gam2 <- function(x,method,dist) {
    d.name <- "pgamma"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,shape=shape,scale=scale)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.gam3.dist.
  ks.gam3 <- function(x,method,dist) {
    d.name <- "pgamma3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,shape=shape,scale=scale,thres=thres)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.lp3.dist.
  ks.lp3 <- function(x,method,dist) {
    d.name <- "pgamma3"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    thres <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(x,d.name,shape=shape,scale=scale,thres=thres)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.gev.dist.
  ks.gev <- function(x,method,dist) {
    d.name <- "pgev"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    location <- fun(x)[3]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(location)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,shape=shape,scale=scale,loc=location)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.gum.dist.
  ks.gum <- function(x,method,dist) {
    d.name <- "pgumbel"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    scale <- fun(x)[1]
    location <- fun(x)[2]
    if (is.numeric(scale)==FALSE || is.numeric(location)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,scale=scale,location=location)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.wbu2.dist.
  ks.wbu2 <- function(x,method,dist) {
    d.name <- "pweibull"
    p <- x
    # Parameter estimation
    f.name <- paste(method,dist,sep="_")
    fun <- match.fun(f.name)
    shape <- fun(x)[1]
    scale <- fun(x)[2]
    if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE) {
      res <- 0
    } else {
      ks <- ks.test(p,d.name,shape=shape,scale=scale)
      ks.p <- format(round(ks$p.value,3))
      ks.s <- format(round(ks$statistic,3))
      res <- cbind(ks.p,ks.s)
    }
    return(res)
  }
  # function end #
  # function: ks.test.wbu3.dist.
  ks.wbu3 <- function(x,method,dist) {
    d.name <- "pweibull3"
    p <- x
    # Parameter estimation
    if (method=="mom") {
      res <- 0
    } else {
      f.name <- paste(method,dist,sep="_")
      fun <- match.fun(f.name)
      shape <- fun(x)[1]
      scale <- fun(x)[2]
      thres <- fun(x)[3]
      if (is.numeric(shape)==FALSE || is.numeric(scale)==FALSE || is.numeric(thres)==FALSE) {
        res <- 0
      } else {
        ks <- ks.test(p,d.name,shape=shape,scale=scale,thres=thres)
        ks.p <- format(round(ks$p.value,3))
        ks.s <- format(round(ks$statistic,3))
        res <- cbind(ks.p,ks.s)
      }
    }
    return(res)
  }
  # function end #
  if (dist=="nor") { ks.test.res <- tryCatch(ks.nor(x,method,dist), error=function(err) NA) }
  else if (dist=="ln2") { ks.test.res <- tryCatch(ks.ln2(x,method,dist), error=function(err) NA) }
  else if (dist=="ln3") { ks.test.res <- tryCatch(ks.ln3(x,method,dist), error=function(err) NA) }
  else if (dist=="exp") { ks.test.res <- tryCatch(ks.exp(x,method,dist), error=function(err) NA) }
  else if (dist=="gam2") { ks.test.res <- tryCatch(ks.gam2(x,method,dist), error=function(err) NA) }
  else if (dist=="gam3") { ks.test.res <- tryCatch(ks.gam3(x,method,dist), error=function(err) NA) }
  else if (dist=="lp3") { ks.test.res <- tryCatch(ks.lp3(x,method,dist), error=function(err) NA) }
  else if (dist=="gev") { ks.test.res <- tryCatch(ks.gev(x,method,dist), error=function(err) NA) }
  else if (dist=="gum") { ks.test.res <- tryCatch(ks.gum(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu2") { ks.test.res <- tryCatch(ks.wbu2(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu3") { ks.test.res <- tryCatch(ks.wbu3(x,method,dist), error=function(err) NA) }
  return(ks.test.res)
}
### function end ###