### 10/12/2018, Satbyeol Shin, University of Florida ###

### Brief descriptions for input and output files
##### input file: csv format, 1st column for year, 2nd column for month, 3rd column for day, 4th~27th column for rainfall data 
##### output file: (1) FitnessOutput.txt; results of 4 tests of goodness of fit
##### output file: (2) QuantileOutput.txt; results of probable rainfall using all methods and distributions
##### output file: (3) Summary.txt; results of probable rainfall using recommended method and distribution
##### output file: (4) ParameterOutput.txt: results of parameter estimation using all methods and distributions

### Brief instructions for rainfall frequency analysis process using R code
### Step 0. install R packages below and set working directory at line 49
### Step 1. read raw data and fill missing data
##### call function rawdata, it will find missing data and insert row automatically
### Step 2. set data series type (st)
##### series type: "max" or "exceed" available
##### "max" for annual maximum series, "exceed" for exceedance series
### Step 3. set duration time (dt)
##### hourly rainfall data: 1 to 24, any integer available
##### daily rainfall data: 24 or 48 available
##### dtname: define the name of data you want to extract depending on the duration time
### Step 4. extract rainfall data (data)
##### hourly rainfall data: call function datafun(..., timestep="hourly")
##### daily rainfall data: call function datafun(..., timestep="daily")
##### own data: make each duration data as row vector and make matrix use rbind function
### Step 5. set parameter estimation method, probability distribution, return period for frequency analysis
##### default parameter estimation method: "mom", "mlm", "pwm" available - mom (method of moment), mlm (maximum likelihood estimation method), pwm (probability weighted moment method)
##### default probability distribution: "nor","ln2","ln3","exp","gam2","gam3","lp3","gev","gum","wbu2","wbu3" available
##### default return period: c(2,3,5,10,20,30,50,70,80,100,150,200,300,500)
### Step 6. write output txt files
##### (1) FitnessOutput.txt, (2) QuantileOutput.txt, (3) Summary.txt, (4) ParameterOutput.txt

### install R packages
#install.packages("lubridate")
#install.packages("qlcMatrix")
#install.packages("e1071")
#install.packages("nleqslv")
#install.packages("maxLik")
#install.packages("lmomco")
#install.packages("ismev")
#install.packages("lmom")
#install.packages("lmomco")
#install.packages("FAdist")
#install.packages("tolerance")
#install.packages("goftest")
#install.packages("classInt")
#install.packages("gdata")

### set working directory and load source files in working directory
wd <- "U:/Research/2018_4 R Package/Shin_R_Frequency_10122018"
if (!is.null(wd)) setwd(wd)
source("rainfalldata.R")
source("mom.R"); source("mlm.R"); source("pwm.R")
source("gof_chisq.R"); source("gof_ks.R"); source("gof_cvm.R"); source("gof_ad.R")
source("para_estimation.R"); source("prob_rainfall.R")
source("write_result.R")

### case 1: hourly rainfall data with default setting
### step 1
dfraw <- read.csv("obs_GJ_hourly.csv")
df <- rawdata(dfraw)
### step 2
st <- "max"
### step 3
dt <- c(1,3,6,9,12,24)
dtname <- c("1hr","3hr","6hr","9hr","12hr","24hr")
### step 4
data <- datafun(df=df,st=st,dt=dt,timestep="hourly")
### step 5
method <- c("mom","mlm","pwm")
dist <- c("nor","ln2","ln3","exp","gam2","gam3","lp3","gev","gum","wbu2","wbu3")
t <- c(2,3,5,10,20,30,50,70,80,100,150,200,300,500)
### step 6
write_result(x=data,xname=dtname,method=method,dist=dist,t=t)
### case 1 end ###

### case 2: daily rainfall data with default setting
### step 1
dfraw <- read.csv("obs_GJ_daily.csv")
df <- rawdata(dfraw)
### step 2
st <- "exceed"
### step 3
dt <- c(24,48) # 24hr and 48hr is default duration time for daily rainfall data
dtname <- c("24hr","48hr")
### step 4
data <- datafun(dfraw=dfraw,st=st,dt=dt,timestep="daily")
### step 5
method <- c("mom","mlm","pwm")
dist <- c("nor","ln2","ln3","exp","gam2","gam3","lp3","gev","gum","wbu2","wbu3")
t <- c(2,3,5,10,20,30,50,70,80,100,150,200,300,500)
### step 6
write_result(x=data,xname=dtname,method=method,dist=dist,t=t)
### case 2 end ###

