### 10/12/2018, Satbyeol Shin, University of Florida ###
### Parameter Estimation Output
#install.packages("FAdist")
library(FAdist)
#install.packages("tolerance")
library(tolerance)
### function: make parameter estimation matrix
para_estimation <- function(x,method,dist) {
  # function: estimation for Normal distribution
  para.nor <- function(x,method,dist) {
    para <- numeric()
    fun.nor <- paste(method,"nor",sep="_")
    fun.nor <- match.fun(fun.nor)
    nor.mean <- fun.nor(x)[1]
    nor.sd <- fun.nor(x)[2]
        if (is.numeric(fun.nor(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      nor.mean <- format(round(nor.mean,2),scientific=FALSE)
      nor.sd <- format(round(nor.sd,2),scientific=FALSE)
      para <- paste("mean: ",nor.mean,", sd: ",nor.sd)
    }
    return(para)
  }
  # function end #
  # function: estimation for Lognormal distribution
  para.ln2 <- function(x,method,dist) {
    para <- numeric()
    fun.ln2 <- paste(method,"ln2",sep="_")
    fun.ln2 <- match.fun(fun.ln2)
    x <- log(x)
    ln2.mean <- fun.ln2(x)[1]
    ln2.sd <- fun.ln2(x)[2]
    if (is.numeric(fun.ln2(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      ln2.mean <- format(round(ln2.mean,2),scientific=FALSE)
      ln2.sd <- format(round(ln2.sd,2),scientific=FALSE)
      para <- paste("mean: ",ln2.mean,", sd: ",ln2.sd)
    }
    return(para)
  }
  # function end #
  # function: estimation for Lognormal 3 parameters distribution
  para.ln3 <- function(x,method,dist) {
    para <- numeric()
    fun.ln3 <- paste(method,"ln3",sep="_")
    fun.ln3 <- match.fun(fun.ln3)
    ln3.shape <- fun.ln3(x)[1]
    ln3.scale <- fun.ln3(x)[2]
    ln3.thres <- fun.ln3(x)[3]
    if (is.numeric(fun.ln3(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      ln3.shape <- format(round(ln3.shape,2),scientific=FALSE)
      ln3.scale <- format(round(ln3.scale,2),scientific=FALSE)
      ln3.thres <- format(round(ln3.thres,2),scientific=FALSE)
      para <- paste("shape: ",ln3.shape,", scale: ",ln3.scale,", thres: ",ln3.thres)
    }
    return(para)
  }
  # function end #
  # function: estimation for Two parameter Exponential distribution
  para.exp <- function(x,method,dist) {
    para <- numeric()
    fun.exp <- paste(method,"exp",sep="_")
    fun.exp <- match.fun(fun.exp)
    exp.rate <- fun.exp(x)[1]
    exp.shift <- fun.exp(x)[2]
    if (is.numeric(fun.exp(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      exp.rate <- format(round(exp.rate,2),scientific=FALSE)
      exp.shift <- format(round(exp.shift,2),scientific=FALSE)
      para <- paste("rate: ",exp.rate,", shift: ",exp.shift)
    }
    return(para)
  }
  # function end #
  # function: estimation for Two parameter Gamma distribution
  para.gam2 <- function(x,method,dist) {
    para <- numeric()
    fun.gam2 <- paste(method,"gam2",sep="_")
    fun.gam2 <- match.fun(fun.gam2)
    gam2.shape <- fun.gam2(x)[1]
    gam2.scale <- fun.gam2(x)[2]
    if (is.numeric(fun.gam2(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      gam2.shape <- format(round(gam2.shape,2),scientific=FALSE)
      gam2.scale <- format(round(gam2.scale,2),scientific=FALSE)
      para <- paste("shape: ",gam2.shape,", scale: ",gam2.scale)
    }
    return(para)
  }
  # function end #
  # function: estimation for Pearson III distribution
  para.gam3 <- function(x,method,dist) {
    para <- numeric()
    fun.gam3 <- paste(method,"gam3",sep="_")
    fun.gam3 <- match.fun(fun.gam3)
    gam3.shape <- fun.gam3(x)[1]
    gam3.scale <- fun.gam3(x)[2]
    gam3.thres <- fun.gam3(x)[3]
    if (is.numeric(fun.gam3(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      gam3.shape <- format(round(gam3.shape,2),scientific=FALSE)
      gam3.scale <- format(round(gam3.scale,2),scientific=FALSE)
      gam3.thres <- format(round(gam3.thres,2),scientific=FALSE)
      para <- paste("shape: ",gam3.shape,", scale: ",gam3.scale,", thres: ",gam3.thres)
    }
    return(para)
  }
  # function end #
  # function: estimation for Log-Pearson III distribution
  para.lp3 <- function(x,method,dist) {
    para <- numeric()
    fun.lp3 <- paste(method,"lp3",sep="_")
    fun.lp3 <- match.fun(fun.lp3)
    lp3.shape <- fun.lp3(x)[1]
    lp3.scale <- fun.lp3(x)[2]
    lp3.thres <- fun.lp3(x)[3]
    if (is.numeric(fun.lp3(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      lp3.shape <- format(round(lp3.shape,3),scientific=FALSE)
      lp3.scale <- format(round(lp3.scale,3),scientific=FALSE)
      lp3.thres <- format(round(lp3.thres,3),scientific=FALSE)
      para <- paste("shape: ",lp3.shape,", scale: ",lp3.scale,", thres: ",lp3.thres)
    }
    return(para)
  }
  # function end #
  # function: estimation for Generalized Extreme Value distribution
  para.gev <- function(x,method,dist) {
    para <- numeric()
    fun.gev <- paste(method,"gev",sep="_")
    fun.gev <- match.fun(fun.gev)
    gev.shape <- fun.gev(x)[1]
    gev.scale <- fun.gev(x)[2]
    gev.location <- fun.gev(x)[3]
    if (is.numeric(fun.gev(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      gev.shape <- format(round(gev.shape,2),scientific=FALSE)
      gev.scale <- format(round(gev.scale,2),scientific=FALSE)
      gev.location <- format(round(gev.location,2),scientific=FALSE)
      para <- paste("shape: ",gev.shape,", scale: ",gev.scale,", location: ",gev.location)
    }
    return(para)
  }
  # function end #
  # function: estimation for Gumbel distribution
  para.gum <- function(x,method,dist) {
    para <- numeric()
    fun.gum <- paste(method,"gum",sep="_")
    fun.gum <- match.fun(fun.gum)
    gum.scale <- fun.gum(x)[1]
    gum.location <- fun.gum(x)[2]
    if (is.numeric(fun.gum(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      gum.scale <- format(round(gum.scale,2),scientific=FALSE)
      gum.location <- format(round(gum.location,2),scientific=FALSE)
      para <- paste("scale: ",gum.scale,", location: ",gum.location)
    }
    return(para)
  }
  # function end #
  # function: estimation for Two parameter Weibull distribution
  para.wbu2 <- function(x,method,dist) {
    para <- numeric()
    fun.wbu2 <- paste(method,"wbu2",sep="_")
    fun.wbu2 <- match.fun(fun.wbu2)
    wbu2.shape <- fun.wbu2(x)[1]
    wbu2.scale <- fun.wbu2(x)[2]
    if (is.numeric(fun.wbu2(x))==FALSE) {
      para <- paste("parameter estimation failed")
    } else {
      wbu2.shape <- format(round(wbu2.shape,2),scientific=FALSE)
      wbu2.scale <- format(round(wbu2.scale,2),scientific=FALSE)
      para <- paste("shape: ",wbu2.shape,", scale: ",wbu2.scale)
    }
    return(para)
  }
  # function end #
  # function: estimation for Three parameter Weibull distribution
  para.wbu3 <- function(x,method,dist) {
    para <- numeric()
    if (method=="mom") {
      para <- paste("parameter estimation failed")
    } else {
      fun.wbu3 <- paste(method,"wbu3",sep="_")
      fun.wbu3 <- match.fun(fun.wbu3)
      wbu3.shape <- fun.wbu3(x)[1]
      wbu3.scale <- fun.wbu3(x)[2]
      wbu3.thres <- fun.wbu3(x)[3]
      if (is.numeric(fun.wbu3(x))==FALSE) {
        para <- paste("parameter estimation failed")
      } else {
        wbu3.shape <- format(round(wbu3.shape,2),scientific=FALSE)
        wbu3.scale <- format(round(wbu3.scale,2),scientific=FALSE)
        wbu3.thres <- format(round(wbu3.thres,2),scientific=FALSE)
        para <- paste("shape: ",wbu3.shape,", scale: ",wbu3.scale,", thres: ",wbu3.thres)
      }
    }
    return(para)
  }
  # function end #
  if (dist=="nor") { para.estimation <- tryCatch(para.nor(x,method,dist), error=function(err) NA) }
  else if (dist=="ln2") { para.estimation <- tryCatch(para.ln2(x,method,dist), error=function(err) NA) }
  else if (dist=="ln3") { para.estimation <- tryCatch(para.ln3(x,method,dist), error=function(err) NA) }
  else if (dist=="exp") { para.estimation <- tryCatch(para.exp(x,method,dist), error=function(err) NA) }
  else if (dist=="gam2") { para.estimation <- tryCatch(para.gam2(x,method,dist), error=function(err) NA) }
  else if (dist=="gam3") { para.estimation <- tryCatch(para.gam3(x,method,dist), error=function(err) NA) }
  else if (dist=="lp3") { para.estimation <- tryCatch(para.lp3(x,method,dist), error=function(err) NA) }
  else if (dist=="gev") { para.estimation <- tryCatch(para.gev(x,method,dist), error=function(err) NA) }
  else if (dist=="gum") { para.estimation <- tryCatch(para.gum(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu2") { para.estimation <- tryCatch(para.wbu2(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu3") { para.estimation <- tryCatch(para.wbu3(x,method,dist), error=function(err) NA) }
  return(para.estimation)
}
### function end ###