### 10/12/2018, Satbyeol Shin, University of Florida ###
### Probable Rainfall
#install.packages("FAdist")
library(FAdist)
#install.packages("tolerance")
library(tolerance)
### function: make parameter estimation matrix
prob_rainfall <- function(x,t,method,dist) {
  # function: estimation for Normal distribution
  prob.nor <- function(x,method,dist) {
    prob <- numeric()
    fun.nor <- paste(method,dist,sep="_")
    fun.nor <- match.fun(fun.nor)
    nor.mean <- fun.nor(x)[1]
    nor.sd <- fun.nor(x)[2]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qnorm(q,mean=nor.mean,sd=nor.sd)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Lognormal distribution
  prob.ln2 <- function(x,method,dist) {
    prob <- numeric()
    fun.ln2 <- paste(method,dist,sep="_")
    fun.ln2 <- match.fun(fun.ln2)
    x <- log(x)
    ln2.mean <- fun.ln2(x)[1]
    ln2.sd <- fun.ln2(x)[2]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- exp(qlnorm(q,mean=ln2.mean,sd=ln2.sd))
    }
    return(prob)
  }
  # function end #
  # function: estimation for Lognormal 3 parameters distribution
  prob.ln3 <- function(x,method,dist) {
    prob <- numeric()
    fun.ln3 <- paste(method,dist,sep="_")
    fun.ln3 <- match.fun(fun.ln3)
    ln3.shape <- fun.ln3(x)[1]
    ln3.scale <- fun.ln3(x)[2]
    ln3.thres <- fun.ln3(x)[3]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qlnorm3(q,shape=ln3.shape,scale=ln3.scale,thres=ln3.thres)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Two parameter Exponential distribution
  prob.exp <- function(x,method,dist) {
    prob <- numeric()
    fun.exp <- paste(method,dist,sep="_")
    fun.exp <- match.fun(fun.exp)
    exp.rate <- fun.exp(x)[1]
    exp.shift <- fun.exp(x)[2]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- q2exp(q,rate=exp.rate,shift=exp.shift)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Two parameter Gamma distribution
  prob.gam2 <- function(x,method,dist) {
    prob <- numeric()
    fun.gam2 <- paste(method,dist,sep="_")
    fun.gam2 <- match.fun(fun.gam2)
    gam2.shape <- fun.gam2(x)[1]
    gam2.scale <- fun.gam2(x)[2]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qgamma(q,shape=gam2.shape,scale=gam2.scale)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Pearson III distribution
  prob.gam3 <- function(x,method,dist) {
    prob <- numeric()
    fun.gam3 <- paste(method,dist,sep="_")
    fun.gam3 <- match.fun(fun.gam3)
    gam3.shape <- fun.gam3(x)[1]
    gam3.scale <- fun.gam3(x)[2]
    gam3.thres <- fun.gam3(x)[3]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qgamma3(q,shape=gam3.shape,scale=gam3.scale,thres=gam3.thres)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Log-Pearson III distribution
  prob.lp3 <- function(x,method,dist) {
    prob <- numeric()
    fun.lp3 <- paste(method,dist,sep="_")
    fun.lp3 <- match.fun(fun.lp3)
    if (any(fun.lp3(x))==0) { prob <- 0
    } else {
      lp3.shape <- fun.lp3(x)[1]
      lp3.scale <- fun.lp3(x)[2]
      lp3.thres <- fun.lp3(x)[3]
      for (i in 1:length(t)) {
        T <- t[i]
        q <- 1-1/T
        prob[i] <- exp(qgamma3(q,shape=lp3.shape,scale=lp3.scale,thres=lp3.thres))
        if ((prob[i]<0) || (prob[i]>5000)) { prob <- 0 }
      }
    }
    return(prob)
  }
  # function end #
  # function: estimation for Generalized Extreme Value distribution
  prob.gev <- function(x,method,dist) {
    prob <- numeric()
    fun.gev <- paste(method,dist,sep="_")
    fun.gev <- match.fun(fun.gev)
    gev.shape <- fun.gev(x)[1]
    gev.scale <- fun.gev(x)[2]
    gev.location <- fun.gev(x)[3]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qgev(q,shape=gev.shape,scale=gev.scale,location=gev.location)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Gumbel distribution
  prob.gum <- function(x,method,dist) {
    prob <- numeric()
    fun.gum <- paste(method,dist,sep="_")
    fun.gum <- match.fun(fun.gum)
    gum.scale <- fun.gum(x)[1]
    gum.location <- fun.gum(x)[2]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qgumbel(q,scale=gum.scale,location=gum.location)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Two parameter Weibull distribution
  prob.wbu2 <- function(x,method,dist) {
    prob <- numeric()
    fun.wbu2 <- paste(method,dist,sep="_")
    fun.wbu2 <- match.fun(fun.wbu2)
    wbu2.shape <- fun.wbu2(x)[1]
    wbu2.scale <- fun.wbu2(x)[2]
    for (i in 1:length(t)) {
      T <- t[i]
      q <- 1-1/T
      prob[i] <- qweibull(q,scale=wbu2.scale,shape=wbu2.shape)
    }
    return(prob)
  }
  # function end #
  # function: estimation for Three parameter Weibull distribution
  prob.wbu3 <- function(x,method,dist) {
    prob <- numeric()
    if (method=="mom") {
      prob <- 0
    } else {
      fun.wbu3 <- paste(method,dist,sep="_")
      fun.wbu3 <- match.fun(fun.wbu3)
      wbu3.shape <- fun.wbu3(x)[1]
      wbu3.scale <- fun.wbu3(x)[2]
      wbu3.thres <- fun.wbu3(x)[3]
      for (i in 1:length(t)) {
        T <- t[i]
        q <- 1-1/T
        prob[i] <- qweibull3(q,shape=wbu3.shape,scale=wbu3.scale,thres=wbu3.thres)
      }
    }
    return(prob)
  }
  # function end #
  if (dist=="nor") { prob.rainfall <- tryCatch(prob.nor(x,method,dist), error=function(err) NA) }
  else if (dist=="ln2") { prob.rainfall <- tryCatch(prob.ln2(x,method,dist), error=function(err) NA) }
  else if (dist=="ln3") { prob.rainfall <- tryCatch(prob.ln3(x,method,dist), error=function(err) NA) }
  else if (dist=="exp") { prob.rainfall <- tryCatch(prob.exp(x,method,dist), error=function(err) NA) }
  else if (dist=="gam2") { prob.rainfall <- tryCatch(prob.gam2(x,method,dist), error=function(err) NA) }
  else if (dist=="gam3") { prob.rainfall <- tryCatch(prob.gam3(x,method,dist), error=function(err) NA) }
  else if (dist=="lp3") { prob.rainfall <- tryCatch(prob.lp3(x,method,dist), error=function(err) NA) }
  else if (dist=="gev") { prob.rainfall <- tryCatch(prob.gev(x,method,dist), error=function(err) NA) }
  else if (dist=="gum") { prob.rainfall <- tryCatch(prob.gum(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu2") { prob.rainfall <- tryCatch(prob.wbu2(x,method,dist), error=function(err) NA) }
  else if (dist=="wbu3") { prob.rainfall <- tryCatch(prob.wbu3(x,method,dist), error=function(err) NA) }
  return(prob.rainfall)
}
### function end ###