### 10/12/2018, Satbyeol Shin, University of Florida ###
### pwm: Probability Weighted Method
#install.packages("lmom")
library(lmom)
#install.packages("lmomco")
library(lmomco)
### function: using mlm, parameter estimation for Normal Distribution (nor)
pwm_nor <- function(x) {
  lmom <- samlmu(x)
  f <- pelnor(lmom)
  return(f) 
}
### function end ###
### function: using mlm, parameter estimation for Two-Parameter Lognormal Distribution (ln2)
pwm_ln2 <- function(x) {
  lmom <- samlmu(log(x))
  f <- pelnor(lmom)
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Three-Parameter Lognormal Distribution (ln3)
pwm_ln3 <- function(x) {
  lmom <- samlmu(x)
  f <- pelln3(lmom) # f[1]: thres, f[2]: scale, f[3]: shape
  f <- cbind(f[3],f[2],f[1]) # reorder: shape, scale, thres
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Exponential Distribution (exp)
pwm_exp <- function(x) {
  lmom <- samlmu(x)
  f <- pelexp(lmom)
  # reorder: shift,rate
  f <- cbind(f[2],f[1])
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Two-Parameter Gamma Distribution (gam2)
pwm_gam2 <- function(x) {
  lmom <- samlmu(x)
    f <- pelgam(lmom)
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Three-Parameter Gamma Distribution (gam3) = Pearson type III
pwm_gam3 <- function(x) {
  m <- mean(x)
  sd <- sd(x)
  lmom <- lmoms(x)
  f <- parpe3(lmom)
  gamma <- f$para[3]
  alpha <- 4/(gamma^2)
  beta <- 1/2*sd*abs(gamma)
  e <- m-2*sd/gamma
  res <- cbind(alpha, beta, e) # alpha: shape, beta: scale, e: thres
  return(res)
}
### function end ###
### function: using mlm, parameter estimation for Log-Pearson type III distribution (lp3)
pwm_lp3 <- function(x) {
  x <- log(x)
  m <- mean(x)
  sd <- sd(x)
  lmom <- lmoms(x)
  f <- parpe3(lmom)
  gamma <- f$para[3]
  alpha <- 4/(gamma^2)
  beta <- 1/2*sd*abs(gamma)
  e <- m-2*sd/gamma
  res <- cbind(alpha, beta, e) # alpha: shape, beta: scale, e: thres
  return(res)
}
### function end ###
### function: using mlm, parameter estimation for Generalized Extreme Value Distribution (gev)
pwm_gev <- function(x) {
  lmom <- samlmu(x)
  f <- pelgev(lmom) # f[1]: location, f[2]: scale, f[3]: shape
  f <- cbind(f[3],f[2],f[1]) # reorder: shape, scale, location
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Gumbel Distribution (gum)
pwm_gum <- function(x) {
  lmom <- samlmu(x)
  f <- pelgum(lmom)
  # f[1]: location, f[2]: scale
  # reorder: scale, location
  f <- cbind(f[2],f[1])
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Weibull2 Distrubition (wbu2)
# https://www.rdocumentation.org/packages/lmom/versions/2.6/topics/pelp
pwm_wbu2 <- function(x) {
  my.pwbu2 <- function(x,scale,shape) pweibull(x,shape=shape,scale=scale)
  l <- samlmu(x,nmom=2)
  f <- pelp(lmom=l,my.pwbu2,start=c(1,1),bounds=c(-Inf,Inf),type="s")
  scale <- f$para[1]
  shape <- f$para[2]
  f <- cbind(shape,scale)
  return(f)
}
### function end ###
### function: using mlm, parameter estimation for Weibull3 Distrubition (wbu3)
pwm_wbu3 <- function(x) {
  lmom <- samlmu(x)
  f <- pelwei(lmom) # f[1]: thres, f[2]: scale, f[3]: shape
  f <- cbind(f[3],f[2],f[1]) # reorder: shape, scale, thres
  return(f)
}
### function end ###