### 10/12/2018, Satbyeol Shin, University of Florida ###
#install.packages("lubridate")
library(lubridate)
#install.packages("qlcMatrix")
library(qlcMatrix)
### function: fill missing rainfall data
rawdata <- function(dfraw) {
  dfraw[is.na(dfraw)] <- 0 # empty cell (na) to zero in raw data
  df <- as.data.frame(dfraw) # df: copy raw data 
  df$date <- with(df, ymd(sprintf('%04d%02d%02d', year, month, day))) # make date column in df
  dfraw$date <- with(dfraw, ymd(sprintf('%04d%02d%02d', year, month, day))) # make date column in raw data
  # function: insert new row to specific row number
  insertRow <- function(existingDF, newrow, r) {
    # existingDF: existing data you want to insert new row,
    # newrow: new row vector you want to insert,
    # r: row number you want to insert
    existingDF <- rbind(existingDF,newrow)
    existingDF <- existingDF[order(c(1:(nrow(existingDF)-1),r-0.5)),]
    row.names(existingDF) <- 1:nrow(existingDF)
    return(existingDF)  
  }
  # function end #
  for (i in 1:(nrow(dfraw)-1)) { # insert new row when missing date is founded
    a1 <- dfraw$date[i+1]
    a2 <- dfraw$date[i]
    a <- as.numeric(a1-a2) # a: difference between date value, a > 1: missing daily data
    if (a > 1) { # insert new row, insert 1 row per 1 day
      for (j in 1:(a-1)) {
        t <- a2+days(j) # t: missing date
        New <- data.frame(t(c(rep(0,times=ncol(df)-1))))
        New$date <- t
        New[1] <- year(t)
        New[2] <- month(t)
        New[3] <- day(t) 
        names(New) <- names(df) # New: insert row has the same format with df
        rownum <- which(df$date==(t-1))
        if (df[rownum+1,]$date!=t) { df <- insertRow(df,New,rownum+1) }
      }
    }
  } 
  return(df)
}
### function end ###
### function: using daily rainfall data, extract annaul maximum sereis or exceedance sereis
rainfall.daily <- function(df,dt,st) {
  # df: fill missing data, call the function rawdata
  # dt: duration time, 24 or 48 for daily data
  # st: series type, "max" or "exceed" available
  dfyear <- unique(df$year) # all years in rainfall data
  # function: extract annaul maximum series
  annualmax.daily <- function(df_hr,df) {
    # df_hr: rainfall summing matrix depending on duration time (row: day, column: day)
    # df: fill missing data, call the function rawdata
    X <- matrix(nrow=length(dfyear),ncol=1)
    colname <- "X1"
    mm <- tapply(df_hr[,colname], df$year, max) 
    mm <- as.data.frame.table(mm)$Freq
    X[,1] <- mm # mm: annual maximum value in each day
    annualmax <- rowMax(X,which=FALSE) # annualmax: annual maximum value in each year
    annualmax_res <- as.matrix(annualmax)
    return(annualmax_res)
  }
  # function end #
  # function: extract exceedance series
  exceed.daily <- function(df_hr,df) {
    # df_hr: rainfall summing matrix depending on duration time (row: day, column: day)
    # df: fill missing data, call the function rawdata
    a <- c(df_hr[,1])
    mm <- as.matrix(a) # mm: daily rainfall data to 1 column
    mm <- mm[order(mm[,1], decreasing = TRUE),] # sort mm descending order
    exceed_res <- mm[1:length(dfyear)] # exceed_res: extract highest ranked rainfalls for the total number of years
    return(exceed_res)
  }
  # function end #
  # function: extract rainfall sereis for duration 24 hr
  d24hr <- function(df,st) {
    # df_24hr: rainfall summing matrix for 24 hour duration time
    df_24hr <- as.matrix(cbind(df[,4],df[,1]))
    colnames(df_24hr) <- c("X1","year")
    df_24hr[is.na(df_24hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax.daily(df_24hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed.daily(df_24hr,df))
    }
    return(dhr)
  }
  # function end #
  # function: extract rainfall sereis for duration 48 hr
  d48hr <- function(df,st) {
    # df_48hr: rainfall summing matrix for 48 hour duration time
    df_48hr <- as.matrix(cbind(df[,4],df[,1]))
    colnames(df_48hr) <- c("X1","year")
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        df_48hr[j,1] <- df[j,4]+df[j+1,4]
      } else { # last line
        df_48hr[j,1] <- df[j,4]
      }
    }
    df_48hr[is.na(df_48hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax.daily(df_48hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed.daily(df_48hr,df))
    }
    return(dhr)
  }
  # function end #
  if (dt==24) { dtrainfall <- d24hr(df,st) }
  else if (dt==48) { dtrainfall <- d48hr(df,st) }
  return(dtrainfall)
}
### function end ###
### function: using hourly rainfall data, extract annaul maximum sereis or exceedance sereis
rainfall.hourly <- function (df,dt,st) {
  # df: fill missing data, call the function rawdata
  # dt: duration time, any integer between 1 to 24 for hourly data
  # st: series type, "max" or "exceed" available
  dfyear <- unique(df$year) # all years in rainfall data
  # function: extract annaul maximum series
  annualmax <- function(df_hr,df) {
    # df_hr: rainfall summing matrix depending on duration time (row: day, column: 1 to 24 hour)
    # df: fill missing data, call the function rawdata
    X <- matrix(nrow=length(dfyear),ncol=24)
    for(i in 1:24) {
      colname <- paste("X",i,sep="")
      mm <- tapply(df_hr[,colname], df$year, max)
      mm <- as.data.frame.table(mm)$Freq
      X[,i] <- mm # mm: annual maximum value in each hour
    } 
    annualmax <- rowMax(X,which=FALSE) # annualmax: annual maximum value in each year
    annualmax_res <- as.matrix(annualmax)
    return(annualmax_res)
  }
  # function end #
  # function: extract exceedance series
  exceed <- function(df_hr,df) {
    # df_hr: rainfall summing matrix depending on duration time (row: day, column: day)
    # df: fill missing data, call the function rawdata
    a <- c(df_hr[,1:24])
    mm <- as.matrix(a) # mm: hourly rainfall data matrix to 1 column
    mm <- mm[order(mm[,1], decreasing = TRUE),] # sort mm descending order
    exceed_res <- mm[1:length(dfyear)] # exceed_res: extract highest ranked rainfalls for the total number of years
    return(exceed_res)
  }
  # function end #
  # column name of rainfall summing matrix
  columname <- c("X1","X2","X3","X4","X5","X6","X7","X8","X9","X10","X11","X12","X13","X14","X15","X16","X17","X18","X19","X20","X21","X22","X23","X24","year")
  # fucntion: extract rainfall sereis for duration 1 hr
  d1hr <- function(df,st) {
    # df_1hr: rainfall summing matrix for 1 hour duration time
    df_1hr <- as.matrix(cbind(df[,4:27],df[,1]))
    colnames(df_1hr) <- columname
    df_1hr[is.na(df_1hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_1hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_1hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 2 hr
  d2hr <- function(df,st) {
    # df_2hr: rainfall summing matrix for 2 hour duration time
    df_2hr <- matrix(nrow=nrow(df),ncol=25)
    df_2hr[,25] <- df$year
    colnames(df_2hr) <- columname
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= 23) {
            df_2hr[j,i] <- df[j,i+3]+df[j,i+4]
          } else {
            df_2hr[j,24] <- df[j,27]+df[j+1,4]
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i < 23) {
            df_2hr[j,i] <- df[j,i+3]+df[j,i+4]
          } else {
            df_2hr[j,24] <- df[j,27]
          }
        }
      }
    }
    df_2hr[is.na(df_2hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_2hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_2hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 3 hr
  d3hr <- function(df,st) {
    # df_3hr: rainfall summing matrix for 3 hour duration time
    df_3hr <- matrix(nrow=nrow(df),ncol=25)
    df_3hr[,25] <- df$year
    colnames(df_3hr) <- columname
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= 22) {
            df_3hr[j,i] <- df[j,i+3]+df[j,i+4]+df[j,i+5]
          } else if (i == 23) {
            df_3hr[j,i] <- df[j,i+3]+df[j,i+4]+df[j+1,4]
          } else if (i == 24) {
            df_3hr[j,i] <- df[j,i+3]+df[j+1,4]+df[j+1,5]
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= 22) {
            df_3hr[j,i] <- df[j,i+3]+df[j,i+4]+df[j,i+5]
          } else if (i == 23) {
            df_3hr[j,i] <- df[j,i+3]
          } else if (i == 24) {
            df_3hr[j,i] <- df[j,i+3]
          }
        }
      }
    }
    df_3hr[is.na(df_3hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_3hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_3hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 4 hr
  d4hr <- function(df,st) {
    # df_4hr: rainfall summing matrix for 4 hour duration time
    df_4hr <- matrix(nrow=nrow(df),ncol=25)
    df_4hr[,25] <- df$year
    colnames(df_4hr) <- columname
    a <- 4
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_4hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          }
        }
      }
    }
    df_4hr[is.na(df_4hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_4hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_4hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 5 hr
  d5hr <- function(df,st) {
    # df_5hr: rainfall summing matrix for 5 hour duration time
    df_5hr <- matrix(nrow=nrow(df),ncol=25)
    df_5hr[,25] <- df$year
    colnames(df_5hr) <- columname
    a <- 5
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_5hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          }
        }
      }
    }
    df_5hr[is.na(df_5hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_5hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_5hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 6 hr
  d6hr <- function(df,st) {
    # df_6hr: rainfall summing matrix for 6 hour duration time
    df_6hr <- matrix(nrow=nrow(df),ncol=25)
    df_6hr[,25] <- df$year
    colnames(df_6hr) <- columname
    a <- 6
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_6hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          }
        }
      }
    } 
    df_6hr[is.na(df_6hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_6hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_6hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 7 hr
  d7hr <- function(df,st) {
    # df_7hr: rainfall summing matrix for 7 hour duration time
    df_7hr <- matrix(nrow=nrow(df),ncol=25)
    df_7hr[,25] <- df$year
    colnames(df_7hr) <- columname
    a <- 7
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_7hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          }
        }
      }
    }
    df_7hr[is.na(df_7hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_7hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_7hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 8 hr
  d8hr <- function(df,st) {
    # df_8hr: rainfall summing matrix for 8 hour duration time
    df_8hr <- matrix(nrow=nrow(df),ncol=25)
    df_8hr[,25] <- df$year
    colnames(df_8hr) <- columname
    a <- 8
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_8hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          }
        }
      }
    }
    df_8hr[is.na(df_8hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_8hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_8hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 9 hr
  d9hr <- function(df,st) {
    # df_9hr: rainfall summing matrix for 9 hour duration time
    df_9hr <- matrix(nrow=nrow(df),ncol=25)
    df_9hr[,25] <- df$year
    colnames(df_9hr) <- columname
    a <- 9
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_9hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          }
        }
      }
    }
    df_9hr[is.na(df_9hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_9hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_9hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 10 hr
  d10hr <- function(df,st) {
    # df_10hr: rainfall summing matrix for 10 hour duration time
    df_10hr <- matrix(nrow=nrow(df),ncol=25)
    df_10hr[,25] <- df$year
    colnames(df_10hr) <- columname
    a <- 10
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_10hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          }
        }
      }
    }
    df_10hr[is.na(df_10hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_10hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_10hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 11 hr
  d11hr <- function(df,st) {
    # df_11hr: rainfall summing matrix for 11 hour duration time
    df_11hr <- matrix(nrow=nrow(df),ncol=25)
    df_11hr[,25] <- df$year
    colnames(df_11hr) <- columname
    a <- 11
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_11hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          }
        }
      }
    }
    df_11hr[is.na(df_11hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_11hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_11hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 12 hr
  d12hr <- function(df,st) {
    # df_12hr: rainfall summing matrix for 12 hour duration time
    df_12hr <- matrix(nrow=nrow(df),ncol=25)
    df_12hr[,25] <- df$year
    colnames(df_12hr) <- columname
    a <- 12
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_12hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          }
        }
      }
    }
    df_12hr[is.na(df_12hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_12hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_12hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 13 hr
  d13hr <- function(df,st) {
    # df_13hr: rainfall summing matrix for 13 hour duration time
    df_13hr <- matrix(nrow=nrow(df),ncol=25)
    df_13hr[,25] <- df$year
    colnames(df_13hr) <- columname
    a <- 13
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_13hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          }
        }
      }
    }
    df_13hr[is.na(df_13hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_13hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_13hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 14 hr
  d14hr <- function(df,st) {
    # df_14hr: rainfall summing matrix for 14 hour duration time
    df_14hr <- matrix(nrow=nrow(df),ncol=25)
    df_14hr[,25] <- df$year
    colnames(df_14hr) <- columname
    a <- 14
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_14hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          }
        }
      }
    }
    df_14hr[is.na(df_14hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_14hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_14hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 15 hr
  d15hr <- function(df,st) {
    # df_15hr: rainfall summing matrix for 15 hour duration time
    df_15hr <- matrix(nrow=nrow(df),ncol=25)
    df_15hr[,25] <- df$year
    colnames(df_15hr) <- columname
    a <- 15
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_15hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          }
        }
      }
    }
    df_15hr[is.na(df_15hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_15hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_15hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 16 hr
  d16hr <- function(df,st) {
    # df_16hr: rainfall summing matrix for 16 hour duration time
    df_16hr <- matrix(nrow=nrow(df),ncol=25)
    df_16hr[,25] <- df$year
    colnames(df_16hr) <- columname
    a <- 16
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_16hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          }
        }
      }
    }
    df_16hr[is.na(df_16hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_16hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_16hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 17 hr
  d17hr <- function(df,st) {
    # df_17hr: rainfall summing matrix for 17 hour duration time
    df_17hr <- matrix(nrow=nrow(df),ncol=25)
    df_17hr[,25] <- df$year
    colnames(df_17hr) <- columname
    a <- 17
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_17hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          }
        }
      }
    }
    df_17hr[is.na(df_17hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_17hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_17hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 18 hr
  d18hr <- function(df,st) {
    # df_18hr: rainfall summing matrix for 18 hour duration time
    df_18hr <- matrix(nrow=nrow(df),ncol=25)
    df_18hr[,25] <- df$year
    colnames(df_18hr) <- columname
    a <- 18
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_18hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          }
        }
      }
    }
    df_18hr[is.na(df_18hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_18hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_18hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 19 hr
  d19hr <- function(df,st) {
    # df_19hr: rainfall summing matrix for 19 hour duration time
    df_19hr <- matrix(nrow=nrow(df),ncol=25)
    df_19hr[,25] <- df$year
    colnames(df_19hr) <- columname
    a <- 19
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          } else if (i == (24-a+19)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])+sum(df[j+1,4:19])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          } else if (i == (24-a+19)) {
            df_19hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])
          }
        }
      }
    }
    df_19hr[is.na(df_19hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_19hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_19hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 20 hr
  d20hr <- function(df,st) {
    # df_20hr: rainfall summing matrix for 20 hour duration time
    df_20hr <- matrix(nrow=nrow(df),ncol=25)
    df_20hr[,25] <- df$year
    colnames(df_20hr) <- columname
    a <- 20
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          } else if (i == (24-a+19)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])+sum(df[j+1,4:19])
          } else if (i == (24-a+20)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])+sum(df[j+1,4:20])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          } else if (i == (24-a+19)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])
          } else if (i == (24-a+20)) {
            df_20hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])
          }
        }
      }
    }
    df_20hr[is.na(df_20hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_20hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_20hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 21 hr
  d21hr <- function(df,st) {
    # df_21hr: rainfall summing matrix for 21 hour duration time
    df_21hr <- matrix(nrow=nrow(df),ncol=25)
    df_21hr[,25] <- df$year
    colnames(df_21hr) <- columname
    a <- 21
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          } else if (i == (24-a+19)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])+sum(df[j+1,4:19])
          } else if (i == (24-a+20)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])+sum(df[j+1,4:20])
          } else if (i == (24-a+21)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])+sum(df[j+1,4:21])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          } else if (i == (24-a+19)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])
          } else if (i == (24-a+20)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])
          } else if (i == (24-a+21)) {
            df_21hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])
          }
        }
      }
    }
    df_21hr[is.na(df_21hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_21hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_21hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 22 hr
  d22hr <- function(df,st) {
    # df_22hr: rainfall summing matrix for 22 hour duration time
    df_22hr <- matrix(nrow=nrow(df),ncol=25)
    df_22hr[,25] <- df$year
    colnames(df_22hr) <- columname
    a <- 22
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          } else if (i == (24-a+19)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])+sum(df[j+1,4:19])
          } else if (i == (24-a+20)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])+sum(df[j+1,4:20])
          } else if (i == (24-a+21)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])+sum(df[j+1,4:21])
          } else if (i == (24-a+22)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-22)])+sum(df[j+1,4:22])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          } else if (i == (24-a+19)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])
          } else if (i == (24-a+20)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])
          } else if (i == (24-a+21)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])
          } else if (i == (24-a+22)) {
            df_22hr[j,i] <- sum(df[j,(i+3):(i+3+a-22)])
          }
        }
      }
    }
    df_22hr[is.na(df_22hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_22hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_22hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 23 hr
  d23hr <- function(df,st) {
    # df_23hr: rainfall summing matrix for 23 hour duration time
    df_23hr <- matrix(nrow=nrow(df),ncol=25)
    df_23hr[,25] <- df$year
    colnames(df_23hr) <- columname
    a <- 23
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          } else if (i == (24-a+19)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])+sum(df[j+1,4:19])
          } else if (i == (24-a+20)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])+sum(df[j+1,4:20])
          } else if (i == (24-a+21)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])+sum(df[j+1,4:21])
          } else if (i == (24-a+22)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-22)])+sum(df[j+1,4:22])
          } else if (i == (24-a+23)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-23)])+sum(df[j+1,4:23])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          } else if (i == (24-a+19)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])
          } else if (i == (24-a+20)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])
          } else if (i == (24-a+21)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])
          } else if (i == (24-a+22)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-22)])
          } else if (i == (24-a+23)) {
            df_23hr[j,i] <- sum(df[j,(i+3):(i+3+a-23)])
          }
        }
      }
    }
    df_23hr[is.na(df_23hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_23hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_23hr,df))
    }
    return(dhr)
  }
  # function end #
  # fucntion: extract rainfall sereis for duration 24 hr
  d24hr <- function(df,st) {
    # df_24hr: rainfall summing matrix for 24 hour duration time
    df_24hr <- matrix(nrow=nrow(df),ncol=25)
    df_24hr[,25] <- df$year
    colnames(df_24hr) <- columname
    a <- 24
    for (j in 1:nrow(df)) {
      if (j < nrow(df)) {
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])+sum(df[j+1,4])
          } else if (i == (24-a+3)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])+sum(df[j+1,4:5])
          } else if (i == (24-a+4)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])+sum(df[j+1,4:6])
          } else if (i == (24-a+5)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])+sum(df[j+1,4:7])
          } else if (i == (24-a+6)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])+sum(df[j+1,4:8])
          } else if (i == (24-a+7)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])+sum(df[j+1,4:9])
          } else if (i == (24-a+8)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])+sum(df[j+1,4:10])
          } else if (i == (24-a+9)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])+sum(df[j+1,4:11])
          } else if (i == (24-a+10)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])+sum(df[j+1,4:12])
          } else if (i == (24-a+11)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])+sum(df[j+1,4:13])
          } else if (i == (24-a+12)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])+sum(df[j+1,4:14])
          } else if (i == (24-a+13)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])+sum(df[j+1,4:15])
          } else if (i == (24-a+14)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])+sum(df[j+1,4:14])
          } else if (i == (24-a+15)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])+sum(df[j+1,4:15])
          } else if (i == (24-a+16)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])+sum(df[j+1,4:16])
          } else if (i == (24-a+17)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])+sum(df[j+1,4:17])
          } else if (i == (24-a+18)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])+sum(df[j+1,4:18])
          } else if (i == (24-a+19)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])+sum(df[j+1,4:19])
          } else if (i == (24-a+20)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])+sum(df[j+1,4:20])
          } else if (i == (24-a+21)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])+sum(df[j+1,4:21])
          } else if (i == (24-a+22)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-22)])+sum(df[j+1,4:22])
          } else if (i == (24-a+23)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-23)])+sum(df[j+1,4:23])
          } else if (i == (24-a+24)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-24)])+sum(df[j+1,4:24])
          }
        }
      } else { # last line
        for (i in 1:24) {
          if (i <= (24-a+1)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-1)])
          }  else if (i == (24-a+2)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-2)])
          } else if (i == (24-a+3)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-3)])
          } else if (i == (24-a+4)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-4)])
          } else if (i == (24-a+5)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-5)])
          } else if (i == (24-a+6)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-6)])
          } else if (i == (24-a+7)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-7)])
          } else if (i == (24-a+8)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-8)])
          } else if (i == (24-a+9)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-9)])
          } else if (i == (24-a+10)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-10)])
          } else if (i == (24-a+11)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-11)])
          } else if (i == (24-a+12)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-12)])
          } else if (i == (24-a+13)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-13)])
          } else if (i == (24-a+14)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-14)])
          } else if (i == (24-a+15)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-15)])
          } else if (i == (24-a+16)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-16)])
          } else if (i == (24-a+17)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-17)])
          } else if (i == (24-a+18)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-18)])
          } else if (i == (24-a+19)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-19)])
          } else if (i == (24-a+20)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-20)])
          } else if (i == (24-a+21)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-21)])
          } else if (i == (24-a+22)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-22)])
          } else if (i == (24-a+23)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-23)])
          } else if (i == (24-a+24)) {
            df_24hr[j,i] <- sum(df[j,(i+3):(i+3+a-24)])
          }
        }
      }
    }
    df_24hr[is.na(df_24hr)] <- 0
    if (st=="max") {
      dhr <- as.matrix(annualmax(df_24hr,df))
    } else if (st=="exceed") {
      dhr <- as.matrix(exceed(df_24hr,df))
    }
    return(dhr)
  }
  # function end #
  if (dt==1) { dtrainfall <- d1hr(df,st) }
  else if (dt==2) { dtrainfall <- d2hr(df,st) }
  else if (dt==3) { dtrainfall <- d3hr(df,st) }
  else if (dt==4) { dtrainfall <- d4hr(df,st) }
  else if (dt==5) { dtrainfall <- d5hr(df,st) }
  else if (dt==6) { dtrainfall <- d6hr(df,st) }
  else if (dt==7) { dtrainfall <- d7hr(df,st) }
  else if (dt==8) { dtrainfall <- d8hr(df,st) }
  else if (dt==9) { dtrainfall <- d9hr(df,st) }
  else if (dt==10) { dtrainfall <- d10hr(df,st) }
  else if (dt==11) { dtrainfall <- d11hr(df,st) }
  else if (dt==12) { dtrainfall <- d12hr(df,st) }
  else if (dt==13) { dtrainfall <- d13hr(df,st) }
  else if (dt==14) { dtrainfall <- d14hr(df,st) }
  else if (dt==15) { dtrainfall <- d15hr(df,st) }
  else if (dt==16) { dtrainfall <- d16hr(df,st) }
  else if (dt==17) { dtrainfall <- d17hr(df,st) }
  else if (dt==18) { dtrainfall <- d18hr(df,st) }
  else if (dt==19) { dtrainfall <- d19hr(df,st) }
  else if (dt==20) { dtrainfall <- d20hr(df,st) }
  else if (dt==21) { dtrainfall <- d21hr(df,st) }
  else if (dt==22) { dtrainfall <- d22hr(df,st) }
  else if (dt==23) { dtrainfall <- d23hr(df,st) }
  else if (dt==24) { dtrainfall <- d24hr(df,st) }
  return(dtrainfall)
}
### function end ###
### function: make rainfall data series as row vector and bind together
datafun <- function(df,st,dt,timestep) {
  data <- matrix(nrow=length(dt),ncol=length(unique(df$year)))
  if (timestep=="hourly") {
    for (i in 1:length(dt)) {
      data[i,] <- rainfall.hourly(df=df,dt=dt[i],st=st)
    }
  } else if (timestep=="daily") {
    for (i in 1:length(dt)) {
      data[i,] <- t(rainfall.daily(df=df,dt=dt[i],st=st))
    }
  }
  return(data)
}
### function end ###