### 10/12/2018, Satbyeol Shin, University of Florida ###
### write result
#install.packages("gdata")
library(gdata)
### function: write results for (1) fitness (2) probable rainfall (3) summary (4) parameter estiamtion
write_result <- function(dist,method,xname,x,t) {
  ### (1) FitnessOutput.txt: Goodness Of Fit test Output
  chisq.test.res <- matrix(nrow=length(dist),ncol=length(method))
  rownames(chisq.test.res) <- dist; colnames(chisq.test.res) <- method
  ks.test.res <- matrix(nrow=length(dist),ncol=length(method))
  rownames(ks.test.res) <- dist; colnames(ks.test.res) <- method
  cvm.test.res <- matrix(nrow=length(dist),ncol=length(method))
  rownames(cvm.test.res) <- dist; colnames(cvm.test.res) <- method
  ad.test.res <- matrix(nrow=length(dist),ncol=length(method))
  rownames(ad.test.res) <- dist; colnames(ad.test.res) <- method
  # goodness of fit matrix index - all combinations of distributions and methods
  index.dist <- rep(dist,length(method))
  index.met <- rep(method,each=length(dist))
  gof.opt.dist.met <- matrix(nrow=nrow(x),ncol=2)
  colnames(gof.opt.dist.met) <- c("distribution","method")
  rownames(gof.opt.dist.met) <- xname
  header <- vector()
  # write file
  fn1 <- "FitnessOutput.txt"
  if (file.exists(fn1)==TRUE) file.remove(fn1)
  for (i in 1:nrow(x)) {
    header[i] <- paste("*** Duration: ",xname[i])
    write(header[i],file="FitnessOutput.txt",append=T)
    data <- x[i,]
    for (j in 1:length(method)) {
      met <- method[j]
      for (k in 1:length(dist)) {
        dis <- dist[k]
        chisq.test.res[k,j] <- chisq_test(data,met,dis)[2] # test statistics
        ks.test.res[k,j] <- ks_test(data,met,dis)[2] # test statistics
        cvm.test.res[k,j] <- cvm_test(data,met,dis)[2] # test statistics
        ad.test.res[k,j] <- ad_test(data,met,dis)[2] # test statistics
      }
    }
    # chisq test result
    chisq <- as.numeric(chisq.test.res)
    chisq[is.na(chisq)] <- 99
    chisq[is.infinite(chisq)] <- 99
    chisq.rank <- as.numeric(rank(chisq))
    chisq.gof <- cbind.data.frame(index.dist,index.met,chisq,chisq.rank)
    chisq.gof.sort <- chisq.gof[order(chisq.gof[,4]),]
    # ks test result
    ks <- as.numeric(ks.test.res)
    ks[is.na(ks)] <- 99
    ks[is.infinite(ks)] <- 99
    ks.rank <- as.numeric(rank(ks))
    ks.gof <- cbind.data.frame(index.dist,index.met,ks,ks.rank)
    ks.gof.sort <- ks.gof[order(ks.gof[,4]),]
    # cvm test result
    cvm <- as.numeric(cvm.test.res)
    cvm[is.na(cvm)] <- 99
    cvm[is.infinite(cvm)] <- 99
    cvm.rank <- as.numeric(rank(cvm))
    cvm.gof <- cbind.data.frame(index.dist,index.met,cvm,cvm.rank)
    cvm.gof.sort <- cvm.gof[order(cvm.gof[,4]),]
    # ad test result
    ad <- as.numeric(ad.test.res)
    ad[is.na(ad)] <- 99
    ad[is.infinite(ad)] <- 99
    ad.rank <- as.numeric(rank(ad))
    ad.gof <- cbind.data.frame(index.dist,index.met,ad,ad.rank)
    ad.gof.sort <- ad.gof[order(ad.gof[,4]),]
    # all gof test result
    gof.res <- cbind.data.frame(chisq.gof[,4],ks.gof[,4],cvm.gof[,4],ad.gof[,4]) # Recommend dist&method: mean Rank of the 4 GOF tests
    gof.res.rank <- rowMeans(gof.res)
    gof.opt <- cbind.data.frame(index.dist,index.met,gof.res.rank)
    gof.opt.sort <- gof.opt[order(gof.opt[,3]),]
    gof.opt.res <- paste("*** Recommend distribution & method: ",gof.opt.sort[1,1],gof.opt.sort[1,2])
    gof.opt.dist.met[i,1] <- paste(gof.opt.sort[1,1])
    gof.opt.dist.met[i,2] <- paste(gof.opt.sort[1,2])
    # write gof test result
    write(gof.opt.res,file="FitnessOutput.txt",append=T)
    # sort rank descending order
    gof.sort <- cbind.data.frame(chisq.gof.sort,ks.gof.sort,cvm.gof.sort,ad.gof.sort)
    # function: round numeric variables and set for specific digits in data frame
    round_df <- function(df, digits) {
      # df: data frame 
      # digits: number of digits to round
      nums <- vapply(df, is.numeric, FUN.VALUE = logical(1))
      df[,nums] <- round(df[,nums], digits = digits)
      (df)
    }
    # function end #
    # write gof output head
    gof.index <- c("dist","method","chisq.p","   rank","dist","method","   ks.p","   rank","dist","method","  cvm.p","   rank","dist","method","   ad.p","   rank")
    gof.index <- as.matrix(t(gof.index))
    write.fwf(gof.index,file="FitnessOutput.txt",width=c(rep(7,length(gof.index))),append=T,quote=F,colnames=FALSE,rownames=FALSE)
    # write gof output after sorting
    gof.sort <- round_df(gof.sort,2)
    write.fwf(gof.sort,file="FitnessOutput.txt",width=c(rep(7,ncol(gof.index))),append=T,quote=F,colnames=FALSE,rownames=FALSE)
  }
  ### (1) FitnessOutput.txt end ###
  ### (2) QuantileOutput.txt
  prob.rainfall <- matrix(nrow=length(t),ncol=length(dist))
  colnames(prob.rainfall) <- dist
  rownames(prob.rainfall) <- t
  prob.rainfall.sum <- matrix(nrow=length(t),ncol=nrow(x))
  rownames(prob.rainfall.sum) <- t
  # write file
  fn2 <- "QuantileOutput.txt"
  if (file.exists(fn2)==TRUE) file.remove(fn2)
  for (i in 1:nrow(x)) {
    data <- x[i,]
    for (j in 1:length(method)) {
      met <- method[j]
      for (k in 1:length(dist)) {
        dis <- dist[k]
        prob.rainfall[,k] <- prob_rainfall(data,t,met,dis)
        if ((dis==gof.opt.dist.met[i,1])&&(met==gof.opt.dist.met[i,2])) {
          prob.rainfall.sum[,i] <- prob_rainfall(data,t,met,dis)
        }
      }
      header[i] <- paste("*** method: ",met,"\t","duration: ",xname[i])
      write(header[i],file="QuantileOutput.txt",append=T)
      header2 <- as.matrix(t(dist))
      row.names(header2) <- "return period"
      write.fwf(header2,width=c(15,rep(7,length(dist))),file="QuantileOutput.txt",append=T,colnames=FALSE,rownames=TRUE)
      write.fwf(format(round(prob.rainfall,1),scientific=F),file="QuantileOutput.txt",width=c(15,rep(7,length(dist))),append=T,quote=F,colnames=FALSE,rownames=TRUE)
    }
  }
  ### (2) QuantileOutput.txt end ###
  ### (3) Summary.txt
  # write file
  fn4 <- "Summary.txt"
  if (file.exists(fn4)==TRUE) file.remove(fn4)
  # write summary header and table
  header3 <- paste("*** summary of probable rainfall")
  write(header3,file="Summary.txt",append=T)
  header4 <- as.matrix(t(xname))
  row.names(header4) <- "Duration time"
  write.fwf(header4,width=c(15,rep(10,nrow(x))),file="Summary.txt",append=T,colnames=FALSE,rownames=TRUE)
  # write recommend distribution
  header5 <- as.matrix(t(gof.opt.dist.met[,1])) # final optimized distribution
  row.names(header5) <- "Rec. dist."
  write.fwf(header5,width=c(15,rep(10,nrow(x))),file="Summary.txt",append=T,colnames=FALSE,rownames=TRUE)
  # write recommend method
  header6 <- as.matrix(t(gof.opt.dist.met[,2])) # final optimized method
  row.names(header6) <- "Rec. method"
  write.fwf(header6,width=c(15,rep(10,nrow(x))),file="Summary.txt",append=T,colnames=FALSE,rownames=TRUE)
  # write recommend probable rainfall 
  write.fwf(format(round(prob.rainfall.sum,1),scientific=F),file="Summary.txt",width=c(15,rep(10,nrow(x))),append=T,quote=F,colnames=FALSE,rownames=TRUE)
  ### (3) Summary.txt end ###
  ### (4) ParameterOutput.txt
  para.estimation <- matrix(nrow=length(dist),ncol=length(method))
  rownames(para.estimation) <- dist; colnames(para.estimation) <- method
  # write file
  fn3 <- "ParameterOutput.txt"
  if (file.exists(fn3)==TRUE) file.remove(fn3)
  for (i in 1:nrow(x)) {
    data <- x[i,]
    for (j in 1:length(method)) {
      met <- method[j]
      for (k in 1:length(dist)) {
        dis <- dist[k]
        para.estimation[k,j] <- para_estimation(data,met,dis)
      }
    }
    header[i] <- paste("*** Duration: ",xname[i])
    write(header[i],file="ParameterOutput.txt",append=T)
    header2 <- c("dist",method[1],method[2],method[3])
    header2 <- as.matrix(t(header2))
    write.fwf(header2,width=c(10,55,55,55),file="ParameterOutput.txt",append=T,colnames=FALSE,rownames=FALSE)
    write.fwf(para.estimation,file="ParameterOutput.txt",width=c(10,55,55,55),append=T,quote=F,colnames=FALSE,rownames=TRUE)
  }
  ### (4) ParameterOutput.txt end ###
}
### function end ###