### come from soil HSG classification so it will be modified

# define a function
CN_calculating <- function(soil_file_name, lulc_file_name, muaggatt_file_name, cn_lookup_file_name, cn_mat_nrow, cn_mat_ncol, cn_mat_cellsize) {

#soil_hsg_return <- soil_hsg_calculating("owlrun_soil.txt", "muaggatt.txt")
soil_hsg_return <- soil_hsg_calculating(soil_file_name, muaggatt_file_name)
#lulc_return <- lulc_loading("owlrun_lulc.txt")
lulc_return <- lulc_loading(lulc_file_name)

soil_hsg_mat <- soil_hsg_return[[1]]
soil_hsg_mat_nrow <- soil_hsg_return[[2]]
soil_hsg_mat_ncol <- soil_hsg_return[[3]]
soil_hsg_mat_nodata <- soil_hsg_return[[4]]
soil_hsg_mat_cellsize <- soil_hsg_return[[5]]

lulc_mat <- lulc_return[[1]]
lulc_mat_nrow <- lulc_return[[2]]
lulc_mat_ncol <- lulc_return[[3]]
lulc_mat_nodata <- lulc_return[[4]]
lulc_mat_cellsize <- lulc_return[[5]]

### CN extraction from soil HSG and lulc code

if (lulc_mat_nrow == soil_hsg_mat_nrow & lulc_mat_ncol == soil_hsg_mat_ncol) {
	cn_mat_nrow <- lulc_mat_nrow
	cn_mat_ncol <- lulc_mat_ncol
} else {
#	error massage and exit loop or program
#	break
}

if (lulc_mat_cellsize == soil_hsg_mat_cellsize) {
	cn_mat_cellsize <- lulc_mat_cellsize
} else {
#	error massage and exit loop or program
#	break
}

#cn_lookup <- read.csv("cn_list.csv", header = TRUE)
cn_lookup <- read.csv(cn_lookup_file_name, header = TRUE)

cn_mat <- matrix(data <- NA, nrow <- lulc_mat_nrow, ncol <- lulc_mat_ncol)

for (i in 1:cn_mat_nrow) {
	for (j in 1:cn_mat_ncol) {
		if (lulc_mat[i,j] != lulc_mat_nodata & soil_hsg_mat[i,j] != soil_hsg_mat_nodata) {
			cn_mat[i,j] <- cn_lookup$CN[cn_lookup$LULC == lulc_mat[i,j] & cn_lookup$HSG == soil_hsg_mat[i,j]]
		}
	}
}

cn_return <- list(cn_mat,cn_mat_cellsize,lulc_mat)

return(cn_return)

}