# define a function

ET_coeff_extraction <- function(growing_stage,etcoeff_list,etcover_list,pave_list,lulc_mat,time_year,time_month,time_day) {

growing_stage_width <- ncol(growing_stage)
growing_stage_day <- growing_stage[growing_stage$Year==time_year & growing_stage$Month==time_month & growing_stage$Day==time_day,1:growing_stage_width]
growing_stage_day_colnames <- colnames(growing_stage_day)
growing_stage_day_length <- length(growing_stage_day)
growing_stage_day_colnames_number <- as.numeric(substr(growing_stage_day_colnames,2,100)[4:growing_stage_day_length])
lulc_code <- append(c(0,1,2),growing_stage_day_colnames_number)
growing_stage_day_data <- data.frame(t(growing_stage_day),lulc_code)
colnames(growing_stage_day_data)[1]<-"Stage"

lulc_code_list <- unique(c(lulc_mat))
lulc_code_list_length <- length(lulc_code_list)
lulc_code_list_char <- paste("X",lulc_code_list,sep="")

kcb_mat <- matrix(data <- NA, nrows <- nrow(lulc_mat), ncols <- ncol(lulc_mat))
kfc_mat <- matrix(data <- NA, nrows <- nrow(lulc_mat), ncols <- ncol(lulc_mat))
pav_mat <- matrix(data <- NA, nrows <- nrow(lulc_mat), ncols <- ncol(lulc_mat))

for (i in 2:lulc_code_list_length) {
	kcb_mat[lulc_mat==lulc_code_list[i]] <- etcoeff_list$kcb[etcoeff_list$Code==lulc_code_list[i] & etcoeff_list$Stage==growing_stage_day_data$Stage[growing_stage_day_data$lulc_code==lulc_code_list[i]]]
	kfc_mat[lulc_mat==lulc_code_list[i]] <- etcover_list$kfc[etcover_list$Code==lulc_code_list[i] & etcover_list$Stage==growing_stage_day_data$Stage[growing_stage_day_data$lulc_code==lulc_code_list[i]]]
	pav_mat[lulc_mat==lulc_code_list[i]] <- pave_list$pav[pave_list$Code==lulc_code_list[i] & pave_list$Stage==growing_stage_day_data$Stage[growing_stage_day_data$lulc_code==lulc_code_list[i]]]
}

ET_coeff_return_list <- list(kcb_mat,kfc_mat,pav_mat)

return(ET_coeff_return_list)

}