
##### define a cn map #####
source("soil_hsg_calculator.R")
source("lulc_loader.R")
source("CN_calculator.R")
cn_mat_return <- CN_calculating("ord_soil.txt","ord_lulc.txt","muaggatt.txt","cn_list.csv")
cn_mat <- cn_mat_return[[1]]
cn_mat_nrow <- nrow(cn_mat)
cn_mat_ncol <- ncol(cn_mat)
cell_size <- cn_mat_return[[2]]
lulc_mat <- cn_mat_return[[3]]
cn_mat <- 1.093567*cn_mat  ### from calibration
cn_mat[!is.na(cn_mat) & cn_mat > 99] <- 99
cn2 <- cn_mat
cn1 <- cn2-(20*(100-cn2))/(100-cn2+exp(2.533-0.0636*(100-cn2)))
cn3 <- cn2*exp(0.00673*(100-cn2))
s1 <- 25400/cn1-254
s3 <- 25400/cn3-254

##### load runoff data #####
source("runoff_data_loader.R")
runoff_data <- runoff_data_loading("all_runoff_hourly_ord.csv")
runoff_data_length <- length(runoff_data)

##### load elevation #####
source("elevation_loader.R")
ele <- elevation_loading("ord_ele.txt",cn_mat)

##### load the slope (percentage) of the watershed ######
source("slope_loader.R")
slope_mat <- slope_loading("ord_slp.txt")
slope_degree_mat <- atan(slope_mat/100)*180/pi

##### load the stream network of the watershed #####
source("stream_network_loader.R")

### threshold_area for defining extention of the stream network, unit: ha ###
threshold_area_ha <- 17.914779 ### from calibration ###
stnet_mat <- stream_network_loading("ord_fac.txt", threshold_area_ha)

##### load the flow direction of the watershed #####
source("flow_direction_loader.R")
ele_fd <- flow_direction_loading("ord_fd.txt")
f_dir <- 2^(c(0:7))

##### define stream width #####
st_width_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

### assume the width of the stream as a function of flow accumulation ###
stnet_mat_max <- max(stnet_mat,na.rm=TRUE)
stnet_mat_min <- min(stnet_mat,na.rm=TRUE)
st_width_max <- 2
st_width_min <- 0.2
st_width_slp <- (st_width_max-st_width_min)/(stnet_mat_max-stnet_mat_min)
st_width_mat <- st_width_slp*(stnet_mat-stnet_mat_min)+st_width_min

##### define a soil code map #####
source("soil_loader.R")
soil_mat <- soil_loading("ord_soil.txt")

##### define fc(field capacity),wp(wilting point), and ks(saturated hydraulic conductivity) for soils #####
source("soil_awc_calculator.R")
soil_fcwp_return <- soil_awc_calculating("comp.txt", "chorizon.txt", soil_mat)
soil_fc_mat <- soil_fcwp_return[[1]]
soil_wp_mat <- soil_fcwp_return[[2]]

### unit of saturated hydraulic conductivity is micrometer per second (10^-6 m/sec or 10^-3 mm/sec) ###
soil_ks_mat <- soil_fcwp_return[[3]]

### define horizontal saturated hydraulic conductivity using anisotropic ratio (an_ratio) ### 
soil_an_ratio <- 0.1639613 ### from calibration
soil_ks_ver_mat <- soil_an_ratio*soil_ks_mat

### define coefficients used for the 'van Genuchten' equation to estimate unsaturated hydraulic conductivity from saturated hydarulic conductivity ###
coeff_L <- 0.6621806 ### from calibration
coeff_m <- 0.3248776 ### from calibration

##### define porosity for soils #####
source("soil_porosity_calculator.R")
soil_porosity_calculator_return <- soil_por_calculating("comp.txt", "chorizon.txt", "chtexgrp.txt", "chtextur.txt", soil_mat)
soil_por_mat <- soil_porosity_calculator_return[[1]]
soil_rs_mat <- soil_porosity_calculator_return[[2]]

##### define effective porosity of channel cells #####
source("effective_porosity_calculator.R")
eff_por_mat_return <- effective_porosity_calculating(stnet_mat,soil_por_mat,soil_wp_mat,cn_mat_nrow,cn_mat_ncol)
eff_por_mat <- eff_por_mat_return[[1]]
st_eff_por_mat <- eff_por_mat_return[[2]]

##### define depth for soils #####
### unit of soil depth is 'cm' (centimeter) ###
source("soil_depth_loader.R")
soil_depth_mat <- soil_depth_loading("comp.txt", "chorizon.txt", soil_mat)

##### calculate TEW,REW,TAW, and RAW #####
source("actual_ET_soil_feature_calculator.R")
TREAW_return <- actual_ET_soil_feather_calculating(lulc_mat,soil_fc_mat,soil_wp_mat,soil_depth_mat)
TEW <- TREAW_return[[1]]
REW <- TREAW_return[[2]]
TAW <- TREAW_return[[3]]
RAW <- TREAW_return[[4]]

##### define depth of top soil #####
soil_depth_mat <- 0.3392743*soil_depth_mat ### from calibration

### soil moisture is high at the vicinity of the stream
source("initial_soil_moisture.R")

##### load manning's n map #####
source("manningN_calculator.R")
manningn_mat <- manningn_calculating("manningn_table.csv","ord_lulc.txt",lulc_mat)
manningn_mat <- 1.053512*manningn_mat ### from calibration

##### define or extract flow path (or direction of flow) #####
### flow path is recorded on the designated files (n_i_list_ws.txt and n_j_list_ws.txt) ###
source("flowpath_loader.R")
flowpath_loading(ele_fd, cell_size, cn_mat, cn_mat_nrow, cn_mat_ncol)

##### load all flow paths for the watershed #####
n_i_list_f <- readLines("n_i_list_ws.txt")
n_j_list_f <- readLines("n_j_list_ws.txt")
n_leng_list_f <- readLines("n_leng_list_ws.txt")
n_leng_list_f_length <- length(n_leng_list_f)
n_i_list_s <- strsplit(n_i_list_f,split=" ")
n_j_list_s <- strsplit(n_j_list_f,split=" ")
n_leng_list_s <- strsplit(n_leng_list_f,split=" ")

##### define or extract flow path (or direction of flow) for only stream #####
### flow path is recorded on the designated files (st_n_i_list_ws.txt and st_n_j_list_ws.txt) ###
source("st_flowpath_loader.R")
st_flowpath_loading(ele_fd, cell_size, stnet_mat, cn_mat_nrow, cn_mat_ncol)

##### load flow paths for only stream #####
st_n_i_list_f <- readLines("st_n_i_list_ws.txt")
st_n_j_list_f <- readLines("st_n_j_list_ws.txt")
st_n_leng_list_f <- readLines("st_n_leng_list_ws.txt")
st_n_leng_list_f_length <- length(st_n_leng_list_f)
st_n_i_list_s <- strsplit(st_n_i_list_f,split=" ")
st_n_j_list_s <- strsplit(st_n_j_list_f,split=" ")
st_n_leng_list_s <- strsplit(st_n_leng_list_f,split=" ")

##### load all hourly rainfall data #####
source("rainfall_uniform_loader.R")
rainfall_all_return <- rainfall_uniform_loading("all_rainfall_uniform_hourly_ord.csv")
rainfall_all <- rainfall_all_return[[1]]
storm_time <- rainfall_all_return[[2]]
storm_no <- rainfall_all_return[[3]]
rainfall_all_length <- rainfall_all_return[[4]]
rainfall_all_width <- rainfall_all_return[[5]]

##### load all temperature data from WDM file #####
source("temperature_loader.R")
temperature_all <- temperature_loading("all_temperature_point_daily_ord.csv")

##### load Thiessen divisions #####
source("Thiessen_loader.R")
thiessen_mat <- thiessen_loading("thiessen_polygon.txt")

##### calculate the accumulated hourly rainfall data for single rainfall gage #####
source("rainfall_uniform_acc_calculator.R")

##### calculate hydrograph and amount of excess rainfall and infiltration #####
### overland and channel routing ###
source("routing_calculator_fixed.R")

### only channel routing ###
source("st_routing_calculator_fixed.R")

### calculate accumulated effectve flow volume ###
source("effective_flow_vol_acc_calculator.R")

### calculate travel time ###
source("traveltime_calculator.R")

### calculate potential ET ###
source("potential_ET_hourly_Hargreaves_calculator.R")

### simulate hydrograph for each event ###
source("surface_flow_nonlinearCN_simulator_realization.R") ### nonlinear CN for perlocation list ###

surface_flow_hydrograph_list <- vector(mode="list")

##### load growing stage database for every land use class #####
source("growing_stage_loader.R")
growing_stage <- growing_stage_loading("all_growing_stage_daily.csv")

##### load crop and land cover coefficient for AET #####
etcoeff_list <- read.csv("ETcoeff_list.csv", header = TRUE)
etcoeff_list$kcb <- 0.5116222*etcoeff_list$kcb ### from calibration

##### load crop and land cover area percentage for AET #####
etcover_list <- read.csv("ETcover_list.csv", header = TRUE)
etcover_list$kfc <- 1.1869996*etcover_list$kfc ### from calibration
etcover_list$kfc[etcover_list$kfc > 1] <- 1

##### load pavement area percentage for AET and sediment transport modeling #####
### pavement includes perennial ice/snow ###
pave_list <- read.csv("Pavement_list.csv")
pave_list$pav[pave_list$pav > 1] <- 1

##### define parameters for AET #####
AET <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
AET_acc <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
ke_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
ks_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
kcb_mat_adj <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

##### define accumulated daily soil moisture depletion matix #####
dwd_acc_mat <- matrix(data <- NA, nrow <- cn_mat_nrow,  ncol <- cn_mat_ncol)
dwd_acc_mat[!is.na(cn_mat)] <- 0
drd_acc_mat <- matrix(data <- NA, nrow <- cn_mat_nrow,  ncol <- cn_mat_ncol)
drd_acc_mat[!is.na(cn_mat)] <- 0

##### calculate actual ET #####
source("actual_ET_hourly_calculator.R")

##### percolation #####
### define initial percolation volume matrix ###
percolation_vol_mat <- matrix(data <- NA, nrow <- cn_mat_nrow,  ncol <- cn_mat_ncol)
percolation_vol_mat[!is.na(cn_mat)] <- 0

##### infiltration volume #####
infil_vol_mat <- matrix(data <- NA, nrow <- cn_mat_nrow,  ncol <- cn_mat_ncol)
infil_acc_vol_mat_list <- vector(mode="list")
infil_acc_vol_mat <- matrix(data <- NA, nrow <- cn_mat_nrow,  ncol <- cn_mat_ncol)

##### evapotranspiration volume #####
et_vol_mat_list <- vector(mode="list")

##### initial stream flow depth #####
### initial depth of stream flow is assumed as 1m ###
st_depth_mat <- matrix(data <- NA, nrow <- cn_mat_nrow,  ncol <- cn_mat_ncol)
st_depth_mat[!is.na(stnet_mat)] <- 0.0001

##### initial sm (soil moisture) map
sm_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

### soil moisture is high at the vicinity of the stream
min_sm <- 0.30
max_sm <- 0.30
sm_mat <- initial_soil_moisture_extraction("ord_fac.txt", min_sm, max_sm, cn_mat)
sm_mat_list <- vector(mode="list")
percolation_vol_mat_daily_list <- vector(mode="list")
percolation_vol_mat_daily_list_temp <- vector(mode="list")

source("st_traveltime_calculator.R")

st_manningn <- 0.03*1.170787 ### from calibration

gw_gl_ratio <- 0.502 ### from calibration

##### scan the hourly rainfall data #####
data_no <- 1

rain_time <- 1
no_rain_time <- 0

percolation_mat_mean <- {}

event_simulation_length <- 0
hydrograph_drawing_time <- 0

day_no <- 1
time_no <- 1 ### the begining time interval shoud be 0:00 - 1:00 AM ###
percolation_vol_sum_mat <- 0

seq_no <- 1

event_no <- 0

while (data_no <= rainfall_all_length) {

	time_year <- rainfall_all$Year[data_no]
	time_month <- rainfall_all$Month[data_no]
	time_day <- rainfall_all$Day[data_no]
	time_hour <- rainfall_all$Hour[data_no]

	if(rainfall_all$Sum[data_no] > 0) {

		event_no <- event_no + 1
		rainfall_length <- storm_time$duration[time_year==storm_time$year & time_month==storm_time$month & time_day==storm_time$day & time_hour==storm_time$hour]
		event_rainfall_hourly_data <- rainfall_all[data_no:(data_no+rainfall_length-1),1:rainfall_all_width]

		##### define rainfall data (hourly) for event #####
		### for continuous modeling, "rainfall_length" should reflect rainfall length of only individual event ###
		### for uniform rainfall ###
		rainfall_acc_mat_list <- rainfall_uniform_acc_calculating(event_rainfall_hourly_data,cn_mat_nrow,cn_mat_ncol,cn_mat)

		if (data_no <= (rainfall_all_length-1)) {
			event_simulation_length <- rainfall_length + storm_time$pause[time_year==storm_time$year & time_month==storm_time$month & time_day==storm_time$day & time_hour==storm_time$hour]
		} else {
			event_simulation_length <- rainfall_length*10
		}
		
		##### CN is calculated from the nonlinear relationship between soil moisture and CN (SWAT version) #####
		surface_flow_hydrograph_return <- surface_flow_nonlinearCN_simulating(slope_mat,slope_degree_mat,stnet_mat,ele_fd,cn2,s1,s3,cn_mat,cn_mat_nrow,cn_mat_ncol,cell_size,soil_fc_mat,soil_por_mat,soil_rs_mat,soil_wp_mat,soil_depth_mat,st_eff_por_mat,soil_ks_mat,soil_ks_ver_mat,rainfall_acc_mat_list,rainfall_length,event_simulation_length,manningn_mat,st_manningn,sm_mat,n_leng_list_f,n_leng_list_f_length,n_i_list_s,n_j_list_s,n_leng_list_s,rainfall_all,data_no,temperature_all,bs_depth_mat,st_width_mat,f_dir,st_ks_mat,st_depth_mat,gw_level_mat,percolation_vol_mat,percolation_vol_sum_mat,percolation_no,percolation_vol_mat_daily_list_temp,coeff_L,coeff_m,day_no,time_no,percolation_mat_mean,seq_no)

		surface_flow_hydrograph <- surface_flow_hydrograph_return[[1]]
		surface_flow_hydrograph_list[[event_no]] <- surface_flow_hydrograph
		efv_mat <- surface_flow_hydrograph_return[[2]]
		hydrograph_drawing_time <- surface_flow_hydrograph_return[[3]]
		st_depth_max_mat <- surface_flow_hydrograph_return[[4]]
		sm_mat <- surface_flow_hydrograph_return[[5]]
		infil_acc_vol_mat <- surface_flow_hydrograph_return[[6]]
		percolation_vol_sum_mat <- surface_flow_hydrograph_return[[7]]
		time_no <- surface_flow_hydrograph_return[[8]]
		day_no <- surface_flow_hydrograph_return[[9]]
		percolation_vol_mat_daily_list_temp <- surface_flow_hydrograph_return[[10]]
		total_day_no <- surface_flow_hydrograph_return[[11]]
		percolation_mat_mean <- surface_flow_hydrograph_return[[12]]
		seq_no <- surface_flow_hydrograph_return[[13]]

		if(total_day_no == 1) {
			percolation_vol_mat_daily_list[[day_no]] <- percolation_vol_mat_daily_list_temp[[total_day_no]]
		} else { if(total_day_no > 1) {
				for (temp_day_no in 1:total_day_no) {
					percolation_vol_mat_daily_list[[day_no - total_day_no + temp_day_no]] <- percolation_vol_mat_daily_list_temp[[temp_day_no]]
				}
			}
		}

		sm_mat_list[[event_no]] <- sm_mat
		infil_acc_vol_mat_list[[event_no]] <- infil_acc_vol_mat ### added on 20100719 ###

		time_no <- time_no + 1

		data_no <- data_no + hydrograph_drawing_time

		##### returning depth of water depletion of the soil surface layer and root zone #####
		### depth of water depletion from the soil surface layer (dwd) and root zone (drd) at the end of the rainfall event ###
		### these are initial conditions for dwd_acc_mat and drd_acc_mat ###
		### soil water amount between saturation and field capasity may be drained ###
		### by gravity, field capacity looks more reasonable to be the maximum soil water to calculate ###
		### initial soil water contents ###
		dwd_acc_mat[!is.na(cn_mat) & infil_acc_vol_mat < REW] <- REW[!is.na(cn_mat) & infil_acc_vol_mat < REW] - infil_acc_vol_mat[!is.na(cn_mat) & infil_acc_vol_mat < REW]
		dwd_acc_mat[!is.na(dwd_acc_mat) & dwd_acc_mat < 0] <- 0
		drd_acc_mat <- (soil_fc_mat/100-sm_mat)*soil_depth_mat*10
		drd_acc_mat[!is.na(drd_acc_mat) & drd_acc_mat < 0] <- 0

		AET_acc[!is.na(AET_acc)] <- 0

		no_rain_time <- 0

	} else {

		no_rain_time <- no_rain_time + 1

		### after rainfall stop, ET may occur ###
		### unit of PET is 'mm' ###
		PET <- potential_ET_hourly_calculating(time_year,time_month,time_day,time_hour,temperature_all)

		if (sum(PET,na.rm=T) > 0) {
			### unit of AET is 'mm' ###		
			AET_return <- actual_ET_hourly_calculating(TEW,REW,TAW,RAW,etcoeff_list,etcover_list,pave_list,soil_wp_mat,lulc_mat,growing_stage,temperature_all,time_year,time_month,time_day,PET,sm_mat,dwd_acc_mat,drd_acc_mat,cn_mat)
			AET <- AET_return[[1]]
			ke_mat <- AET_return[[2]]
			ks_mat <- AET_return[[3]]
			kcb_mat_adj <- AET_return[[4]]
		} else {
			AET[!is.na(cn_mat)] <- 0
			ke_mat[!is.na(cn_mat)] <- 0
			ks_mat[!is.na(cn_mat)] <- 0
			kcb_mat_adj[!is.na(cn_mat)] <- 0
		}
		dwd_acc_mat <- dwd_acc_mat + ke_mat*PET
		drd_acc_mat <- drd_acc_mat + ks_mat*kcb_mat_adj*PET
		if (no_rain_time > 1) {
			AET_acc <- AET_acc + AET
		} else {
			AET_acc <- AET
		}

		##### percolation: movement of soil moisture into the vadose zone and aquifer #####
		### soil moisture is reduced by percolation ###
		re_sat_mat <- (sm_mat*100-soil_rs_mat)/(soil_por_mat*100-soil_rs_mat)
		re_sat_mat[!is.na(cn_mat) & re_sat_mat > 1] <- 1
		soil_ks_unsat_mat <- soil_ks_mat*((re_sat_mat)^coeff_L)*(1-(1-re_sat_mat^(1/coeff_m))^coeff_m)^2
		soil_ks_unsat_ver_mat <- soil_ks_ver_mat*((re_sat_mat)^coeff_L)*(1-(1-re_sat_mat^(1/coeff_m))^coeff_m)^2
			
		### unit of the saturated hydraulic conductivity is 'micrometer/s' ###
		### then unit of percolation become 'mm/h' ###
		percolation_vol_mat[!is.na(cn_mat)] <- soil_ks_unsat_ver_mat[!is.na(cn_mat)]*3600/1000

		### percolation stops when soil moisture become equal to or less than wilting point ###
		percolation_vol_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat] <- 0
		percolation_mat_mean[seq_no] <- mean(percolation_vol_mat[!is.na(percolation_vol_mat)])

		sm_mat <- sm_mat - percolation_vol_mat/(soil_depth_mat*10)

		### update the soil moisture(sm_mat) with AET(dwd_mat and drd_mat) and percolation ###
		depletion_sm_mat <- AET

		### caution!! : unit of sm_mat is fraction (not percentage, 0.0-1.0) and that of dwd_mat and drd_mat is 'mm' (depth) ###
		### but unit of soil_depth_mat is 'cm' ###
		sm_mat[!is.na(sm_mat)] <- sm_mat[!is.na(sm_mat)] - depletion_sm_mat[!is.na(sm_mat)]/(soil_depth_mat[!is.na(sm_mat)]*10)

		### if depletion of the soil moisture is greater than the soil moisture, ###
		### the soil moisture will be zero ###
		sm_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat] <- soil_wp_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat]/100

		percolation_vol_sum_mat <- percolation_vol_sum_mat + percolation_vol_mat

		if (time_no == 24) {
			day_no <- day_no + 1
			percolation_vol_mat_daily_list[[day_no]] <- percolation_vol_sum_mat
			time_no <- 0
			percolation_vol_sum_mat <- 0
		}

		time_no <- time_no + 1

		data_no <- data_no + 1

		seq_no <- seq_no + 1

	}
}

source("runoff_data_loader.R")
runoff_data <- runoff_data_loading("all_runoff_hourly_ord.csv")
runoff_data_length <- length(runoff_data)

percolation_mat_mean <- gw_gl_ratio*percolation_mat_mean

surface_flow_hydrograph_all <- {}
for (h in 1:length(surface_flow_hydrograph_list)) {
	surface_flow_hydrograph_all <- append(surface_flow_hydrograph_all,surface_flow_hydrograph_list[[h]])
}

direct_runoff <- surface_flow_hydrograph_all/1000*900/3600
### 3654 is the number of the watershed cells, then 3654*900 is the watershed area ### 
base_flow <- percolation_mat_mean*3654/1000*900/3600

if (length(direct_runoff) > length(base_flow)) {
	hydro_length <- length(base_flow)
} else {
	hydro_length <- length(direct_runoff)
}

### total_hydrograph is a stream flow hydrograph ###
total_hydrograph <- direct_runoff[1:hydro_length] + base_flow[1:hydro_length]

write.csv(total_hydrograph,"simulated_stream_flow_by_HYSTAR.csv")

if (length(runoff_data) > hydro_length) {
	hydro_plot_length <- hydro_length
} else {
	hydro_plot_length <- length(runoff_data)
}	

plot_data <- data.frame(total_hydrograph[1:hydro_plot_length],runoff_data[1:hydro_plot_length])
plot(ts(plot_data),type="b")

write.csv(plot_data,"comparison_simulated_observed_stream_flow.csv")


