### calculate actual ET with all hourly potential ET data ###

actual_ET_hourly_calculating <- function(TEW,REW,TAW,RAW,etcoeff_list,etcover_list,pave_list,soil_wp_mat,lulc_mat,growing_stage,temperature_all,time_year,time_month,time_day,PET,sm_mat,dwd_acc_mat,drd_acc_mat,cn_mat) {

### determination of kcb ###

##### load ET coefficients for every landuse #####
source("ET_coefficient.R")
ET_coeff_return <- ET_coeff_extraction(growing_stage,etcoeff_list,etcover_list,pave_list,lulc_mat,time_year,time_month,time_day)
kcb_mat <- ET_coeff_return[[1]]

rh_min <- temperature_all$rh_min[temperature_all$Year == time_year & temperature_all$Month == time_month & temperature_all$Day == time_day]

### assuming the mean value for daily wind speed at 2m height over grass as 2m/s ###
### and the mean plant height during the mid or late season stage as 1m ###
plant_height <- 1
kcb_mat_adj <- kcb_mat-0.004*(temperature_all$rh_min[temperature_all$Year == time_year & temperature_all$Month == time_month & temperature_all$Day == time_day])*(plant_height/3)^0.3

### assuming the mean value for daily wind speed at 2m height over grass as 2m/s ###
### and the mean plant height during the mid or late season stage as 1m ###
kcmax_mat_temp1 <- matrix(data <- NA, nrows <- nrow(cn_mat), ncols <- ncol(cn_mat))
kcmax_mat_temp1[!is.na(cn_mat)] <- 1.2-0.004*(rh_min-45)*(plant_height/3)^0.3
kcmax_mat_temp2 <- kcb_mat_adj+0.05
kcmax_mat <- matrix(data <- NA, nrows <- nrow(cn_mat), ncols <- ncol(cn_mat))
#kcmax_mat[!is.na(kcmax_mat_temp1) > !is.na(kcmax_mat_temp2)] <- kcmax_mat_temp1[!is.na(kcmax_mat_temp1) > !is.na(kcmax_mat_temp2)]
kcmax_mat[!is.na(kcmax_mat_temp1) & kcmax_mat_temp1 > kcmax_mat_temp2] <- kcmax_mat_temp1[!is.na(kcmax_mat_temp1) & kcmax_mat_temp1 > kcmax_mat_temp2]
#kcmax_mat[!is.na(kcmax_mat_temp1) < !is.na(kcmax_mat_temp2)] <- kcmax_mat_temp2[!is.na(kcmax_mat_temp1) < !is.na(kcmax_mat_temp2)]
kcmax_mat[!is.na(kcmax_mat_temp1) & kcmax_mat_temp1 < kcmax_mat_temp2] <- kcmax_mat_temp2[!is.na(kcmax_mat_temp1) & kcmax_mat_temp1 < kcmax_mat_temp2]

### dimensionless evaporation reduction coefficient kr ###
kr_mat <- matrix(data <- NA, nrows <- nrow(lulc_mat), ncols <- ncol(lulc_mat))
kr_mat <- (TEW-dwd_acc_mat)/(TEW-REW)
#kr_mat[!is.na(kr_mat) & !is.na(kr_mat) > 1] <- 1
kr_mat[!is.na(kr_mat) & kr_mat > 1] <- 1

### dwd: cumulative depth of evaporation (depletion) from the soil surface layer ###
### if dwd becomes greater than TEW, dwd will be zero and no evapolation occurs from the soil surface ###
### but transpiration may continue to occur even after evaporation stop ###
### so that sm may continue to decrease until sm becomes zero ###
#kr_mat[!is.na(kr_mat) & !is.na(TEW) < !is.na(dwd_acc_mat)] <- 0
kr_mat[!is.na(kr_mat) & TEW < dwd_acc_mat] <- 0
#kr_mat[!is.na(kr_mat) & !is.na(sm_mat) == 0] <- 0
#kr_mat[!is.na(kr_mat) & sm_mat == 0] <- 0
kr_mat[!is.na(kr_mat) & sm_mat <= soil_wp_mat/100] <- 0

### dimensionless evaporation reduction coefficient kr ###
ks_mat <- matrix(data <- NA, nrows <- nrow(lulc_mat), ncols <- ncol(lulc_mat))
ks_mat <- (TAW-drd_acc_mat)/(TAW-RAW)
#ks_mat[!is.na(ks_mat) & !is.na(ks_mat) > 1] <- 1
ks_mat[!is.na(ks_mat) & ks_mat > 1] <- 1

### drd: cumulative depth of transpiration (depletion) from the root zone ###
### if drd becomes greater than TAW, drd will be zero and no transpiration occurs from the root zone ###
### but evaporation may continue to occur even after transpiration stop ###
### so that sm may continue to decrease until sm becomes zero ###
#ks_mat[!is.na(ks_mat) & !is.na(TAW) < !is.na(drd_acc_mat)] <- 0
ks_mat[!is.na(ks_mat) & TAW < drd_acc_mat] <- 0
#ks_mat[!is.na(ks_mat) & !is.na(sm_mat) == 0] <- 0
#ks_mat[!is.na(ks_mat) & sm_mat == 0] <- 0
ks_mat[!is.na(ks_mat) & sm_mat <= soil_wp_mat/100] <- 0

### few = 1-fc instead of min(1-fc,fw) ###
kfc_mat <- ET_coeff_return[[2]]
pav_mat <- ET_coeff_return[[3]]
few_mat <- 1-kfc_mat-pav_mat
few_mat[!is.na(cn_mat) & few_mat < 0] <- 0

max_ke_mat <- few_mat*kcmax_mat
ke_mat <- kr_mat*(kcmax_mat-kcb_mat)
#ke_mat[!is.na(ke_mat) > !is.na(max_ke_mat)] <- max_ke_mat[!is.na(ke_mat) > !is.na(max_ke_mat)]
ke_mat[!is.na(ke_mat) & ke_mat > max_ke_mat] <- max_ke_mat[!is.na(ke_mat) & ke_mat > max_ke_mat]

eta_hourly <- (kcb_mat_adj*ks_mat+ke_mat)*PET
#eta_hourly <- (kcb_mat_adj+ke_mat)*PET

eta_return_list <- list(eta_hourly,ke_mat,ks_mat,kcb_mat_adj)
return(eta_return_list)

}