### calculate TEW, REW, TAW, and RAW from the soil characteristics ###

actual_ET_soil_feather_calculating <- function(lulc_data_mat,soil_fc_mat,soil_wp_mat,soil_depth_mat) {


### assume the depth of the surface soil layer (Ze) that is subject to drying by way of evaporation as 10% of the soil depth ###
### calculate the total evaporable water (TEW) or the maximum depth of water that can be evaporated from the soil when the topsoil has been initially completely wetted ###
### unit of TEW is 'mm' ###
#TEW <- 1000*(soil_fc_mat/100-0.5*soil_wp_mat/100)*(soil_depth_mat/100*0.1)

### the depth of the surface soil layer that is subjective to drying by way of evaporation is assumed as 10.0 cm regardless of soil depth, fixed on 20100825 ###
TEW <- 1000*(soil_fc_mat/100-0.5*soil_wp_mat/100)*0.10
TEW[!is.na(soil_fc_mat) & TEW > soil_depth_mat] <- soil_depth_mat[!is.na(soil_fc_mat) & TEW > soil_depth_mat]

### TEW is adjusted with consideration of pavement of land cover ###
### if land cover is residential, commercial/industrical/transportation, bare rock, and quarries ###
### it will be assumed that TEW of them has very low or zero total evapoable water (TEW) ###
### for residential, 25% of TEW ###
TEW[!is.na(lulc_data_mat) & lulc_data_mat==21] <- 0.25*TEW[!is.na(lulc_data_mat) & lulc_data_mat==21]
### for commercial, 10% of TEW ###
TEW[!is.na(lulc_data_mat) & lulc_data_mat==22] <- 0.1*TEW[!is.na(lulc_data_mat) & lulc_data_mat==22]
### for inderstial, 10% of TEW or almost completlly paved (impervious) ###
TEW[!is.na(lulc_data_mat) & lulc_data_mat==23] <- 0.1*TEW[!is.na(lulc_data_mat) & lulc_data_mat==23]
### for the other impervious land use, 5% of TEW ###
TEW[!is.na(lulc_data_mat) & lulc_data_mat==31] <- 0.05*TEW[!is.na(lulc_data_mat) & lulc_data_mat==31]
TEW[!is.na(lulc_data_mat) & lulc_data_mat==32] <- 0.05*TEW[!is.na(lulc_data_mat) & lulc_data_mat==32]
TEW[!is.na(lulc_data_mat) & lulc_data_mat==33] <- 0.05*TEW[!is.na(lulc_data_mat) & lulc_data_mat==33]

### assume the readily evaporable water (REW) as 50% of the TEW ###
REW <- TEW*0.5


### calculate the total available soil water in the root zone evaporable water (TAW) ###
### unit of TAW is 'mm' ###
### the depth of the surface soil layer that is subjective to drying by way of evaporation is assumed as soil depth initially provided by the soil database (SSURGO) but it is not changed with soil depth variation later in calibration and uncertainty analysis, fixed on 20101003 ###
TAW <- 1000*(soil_fc_mat/100-soil_wp_mat/100)*(soil_depth_mat/100)

### TAW is adjusted with consideration of pavement of land cover ###
### if land cover is residential, commercial/industrical/transportation, bare rock, and quarries ###
### it will be assumed that TAW of them has very low or zero total evapoable water (TAW) ###
### for residential, 25% of TAW ###
TAW[!is.na(lulc_data_mat) & lulc_data_mat==21] <- 0.5*TAW[!is.na(lulc_data_mat) & lulc_data_mat==21]
### for commercial, 10% of TAW ###
TAW[!is.na(lulc_data_mat) & lulc_data_mat==22] <- 0.1*TAW[!is.na(lulc_data_mat) & lulc_data_mat==22]
### for inderstial, 10% of TAW or completle paved (impervious) ###
TAW[!is.na(lulc_data_mat) & lulc_data_mat==23] <- 0.1*TAW[!is.na(lulc_data_mat) & lulc_data_mat==23]
### for the other impervious land use, 5% of TAW ###
TAW[!is.na(lulc_data_mat) & lulc_data_mat==31] <- 0.05*TAW[!is.na(lulc_data_mat) & lulc_data_mat==31]
TAW[!is.na(lulc_data_mat) & lulc_data_mat==32] <- 0.05*TAW[!is.na(lulc_data_mat) & lulc_data_mat==32]
TAW[!is.na(lulc_data_mat) & lulc_data_mat==33] <- 0.05*TAW[!is.na(lulc_data_mat) & lulc_data_mat==33]

### assume the readily available soil water (RAW) as 50% of the TAW ###
RAW <- TAW*0.5

actual_ET_soil_feature_return_list <- list(TEW,REW,TAW,RAW)

return(actual_ET_soil_feature_return_list)

}