### elevation extraction

# define a function
elevation_loading <- function(ele_file_name,cn_mat) {

# Load flow direction map from a text file
#ele_line_data <- readLines("owlrun_ele.txt")
ele_line_data <- readLines(ele_file_name)
ele_line_split <- strsplit(ele_line_data, " +")
ele_line_ncols <- unlist(ele_line_split[1])
ele_map_ncols <- as.numeric(ele_line_ncols[2])
ele_line_nrows <- unlist(ele_line_split[2])
ele_map_nrows <- as.numeric(ele_line_nrows[2])
ele_line_nodata <- unlist(ele_line_split[6])
ele_map_nodata <- as.numeric(ele_line_nodata[2])
ele_line_length <- length(ele_line_split)

ele_data_mat <- matrix(data <- NA, nrow <- ele_map_nrows, ncol <- ele_map_ncols)

for (i in 1:ele_map_nrows) {
	ele_data_mat[i,] <- as.numeric(unlist(ele_line_split[i+6]))
}

ele_data_mat[is.na(cn_mat)] <- NA

return(ele_data_mat)

}


