# define a function

ex_radiation_daily_calculator <- function(ws_lat,ws_lon,sim_date) {

source("JulianDay.R")
jul_day <- JulianDay_calculator(sim_date)
lat_rad <- ws_lat/180*pi
IRD_ES <- 1+0.033*cos(2*pi/365*jul_day)
S_dec <- 0.409*sin(2*pi/365*jul_day-1.39)
SS_angle <- acos(-tan(lat_rad)*tan(S_dec))
sinsin <- sin(lat_rad)*sin(S_dec)
coscos <- cos(lat_rad)*cos(S_dec)
ex_radiation_daily <- 24*60/pi*0.082*IRD_ES*(SS_angle*sinsin+coscos*sin(SS_angle))

return(ex_radiation_daily)

}