# define a function

ex_radiation_hourly_calculator <- function(ws_lat,ws_lon,time_year,time_month,time_day,time_hour,LLTZ) {

source("JulianDay.R")
jul_day <- JulianDay_calculator(time_year,time_month,time_day,time_hour)
lat_rad <- ws_lat/180*pi
IRD_ES <- 1+0.033*cos(2*pi/365*jul_day)
S_dec <- 0.409*sin(2*pi/365*jul_day-1.39)
par_b <- 2*pi*(jul_day-81)/364
SC_ST <- 0.1645*sin(2*par_b)-0.1255*cos(par_b)-0.025*sin(par_b)

#source("JulianDayTime.R")
#sun_begin_time_jul_daytime <- JulianDayTime_calculator(sun_begin_time)
#sun_end_time_jul_daytime <- JulianDayTime_calculator(sun_end_time)
#sun_mid_time_jul_daytime <- (sun_begin_time_jul_daytime + sun_end_time_jul_daytime)/2
#sun_mid_time <- (sun_begin_time+sun_end_time)/2
sun_mid_time <- time_hour+1/2
#sun_time_duration <- sun_end_time-sun_begin_time
sun_time_duration <- 1
STA_mid <- pi/12*((sun_mid_time+0.06667*(LLTZ-abs(ws_lon))+SC_ST)-12)
STA_begin <- STA_mid-pi*sun_time_duration/24
STA_end <- STA_mid+pi*sun_time_duration/24
sinsin <- sin(lat_rad)*sin(S_dec)
coscos <- cos(lat_rad)*cos(S_dec)
sinmsin <- sin(STA_end)-sin(STA_begin)

ex_radiation_hourly <- 12*60/pi*0.082*IRD_ES*((STA_end-STA_begin)*sinsin+coscos*sinmsin)

return(ex_radiation_hourly)

}