### groundwater flow simulation is done in the time step of a day ###

groundwater_flow_simulating <- function(gw_level_mat,cn_mat,gw_fd,cn_mat_nrow,cn_mat_ncol,f_dir,cell_size,soil_ks_mat,percolation_vol_mat_daily_list,soil_depth_mat) {

gw_simulation_daily_length <- length(percolation_vol_mat_daily_list)

gw_iso_vol_list <- vector(mode="list")
gw_sub_iso_vol <- {}
length(gw_sub_iso_vol) <- gw_simulation_daily_length

for (gw_day in 1:gw_simulation_daily_length) {

	### update groundwater level with the routed groundwater volume ###
	gw_route_flow_vol_mat <- gw_routing_calculating(gw_level_mat,cn_mat,gw_fd,cn_mat_nrow,cn_mat_ncol,f_dir,cell_size,soil_ks_mat)

	### note: unit of groundwater route flow volume is 'mm' but that of groundwater level is 'm' ###
	gw_level_mat <- gw_level_mat + gw_route_flow_vol_mat/1000

	### update groundwater level with percolation (positive) ###
	### there must be some time lag for the percolated water volume to infiltrate the vadose zone and then get the groundwater table ###
	### but the process is ignored in this time ###
	### it will be added after some tests ###
	gw_level_mat <- gw_level_mat + percolation_vol_mat_daily_list[[gw_day]]/1000

	### if groundwater level is higher than the bottom of the root zone ###
	### depth of the root zone will be decreased as much as height of groundwater level about the bottom level ###
	### note: unit of elevation (ele) and groundwater depth (gw_depth_mat) are meter (m), ###
	### but that of soil depth (soil_depth_mat) is centimeter (cm) ###
	gw_depth_mat <- (ele-gw_level_mat)*100
	gw_depth_mat[!is.na(cn_mat) & gw_depth_mat < 10] <- 10

	### soil depth will not be affected by groundwater level ###
	#soil_depth_mat[!is.na(cn_mat) & soil_depth_mat > gw_depth_mat] <- gw_depth_mat[!is.na(cn_mat) & soil_depth_mat > gw_depth_mat]
	#soil_depth_mat[!is.na(cn_mat) & soil_depth_mat < 10] <- 10

	### calculate vadose zone depth with soil and groundwater depths ###
	vz_depth_mat <- gw_depth_mat - soil_depth_mat

	### update groundwater level with deep percolation (negative) ###
	#gw_level_mat <- gw_level_mat - deep_percolation_vol_mat/1000

	### capillary rise (negative for groundwater level but positive for soil moisture of the vadoze zone or root zone) ###
	### capillary rise is assumed as not occuring at this time ###
	#gw_level_mat <- gw_level_mat - capillary_rise_vol_mat

	### groundwater level (gw_level_mat) is linked to bank storage depth (bs_depth_mat) in the stream cells ###
	### unit of bs_depth_mat is 'm' ###
	bs_depth_mat[!is.na(stnet_mat)] <- 0
	bs_depth_mat[!is.na(stnet_mat) & gw_level_mat > ch_level_mat] <- gw_level_mat[!is.na(stnet_mat) & gw_level_mat > ch_level_mat] - ch_level_mat[!is.na(stnet_mat) & gw_level_mat > ch_level_mat]

	##### update seepate #####
	### unit of unit_seep_flow_vol_mat is 'mm/day' or unit discharge, which is equatl to 'Q/A=-kdh/dl' ###
	### but unit of st_ks_mat is 'micrometer/sec' ###
	### the channel is located at the center of the cell so that dl = (cell_size/2) ###
	### assuming drop of the groundwater level is the same as the bs_depth_mat ###
	unit_seep_flow_vol_mat <- st_ks_mat*3600*24/1000*(bs_depth_mat)/(cell_size/2)

	### seepage calculation ###
	### unit of seep_flow_vol_mat is 'm3/day' ###
	### and unit of bs_depth_mat is 'm' ###
	seep_flow_vol_mat <- (unit_seep_flow_vol_mat/1000)*bs_depth_mat*cell_size*2

	### unit of st_efv_mat is 'mm/day' ###
	### st_efv_mat is updated daily ###
#	st_efv_mat <- seep_flow_vol_mat/cell_size/st_width_mat*1000
	st_efv_mat[!is.na(stnet_mat)] <- 240

	### update groundwater level ###
	gw_level_mat[!is.na(stnet_mat)] <- gw_level_mat[!is.na(stnet_mat)] - unit_seep_flow_vol_mat[!is.na(stnet_mat)]

	### unit of stream effective flow volume is 'mm/day' ###
#	if (gw_day > 1) {
##		st_efv_mat <- seep_flow_vol_mat - st_infiltration_vol_mat + st_route_flow_vol_mat
#		st_efv_mat <- seep_flow_vol_mat + st_route_flow_vol_mat
#	} else {
##		st_efv_mat <- seep_flow_vol_mat - st_infiltration_vol_mat
#		st_efv_mat <- seep_flow_vol_mat
#	}

	st_efv_mat[!is.na(stnet_mat) & st_efv_mat < 0] <- 0

	st_travel_time_return <- st_travel_time_calculating(st_efv_mat,stnet_mat,slope_mat,slope_degree_mat,manningn_mat,st_n_i_list_s,st_n_j_list_s,st_n_leng_list_s,st_n_leng_list_f_length,cell_size,cn_mat_nrow,cn_mat_ncol,st_depth_mat,st_width_mat)
	st_travel_time_sec <- st_travel_time_return[[1]]
	st_travel_time_day <- st_travel_time_sec/24/3600
#	st_v_list[[gw_day]] <- st_travel_time_return[[2]]
	st_depth_mat <- st_travel_time_return[[3]]

	st_route_flow_vol_mat <- st_routing_calculating(st_travel_time_day,st_efv_mat,cn_mat,ele_fd,cn_mat_nrow,cn_mat_ncol,f_dir)

	### do 'channel routing' just for the stream ###
	### isochrone will be constructed only when effective flow volume exists in any cell of the channel ###
#	if (sum(st_efv_mat[!is.na(stnet_mat)],na.rm=T) > 0) {
#		st_travel_time_return <- st_travel_time_calculating(st_efv_mat,stnet_mat,slope_mat,slope_degree_mat,manningn_mat,st_n_i_list_s,st_n_j_list_s,st_n_leng_list_s,st_n_leng_list_f_length,cell_size,cn_mat_nrow,cn_mat_ncol,st_depth_mat,st_width_mat)
#		st_travel_time_sec <- st_travel_time_return[[1]]
#		st_travel_time_day <- st_travel_time_sec/3600
##		st_v_list[[data_no]] <- travel_time_return[[2]]
#		st_depth_mat <- st_travel_time_return[[3]]
#
#		st_route_flow_vol_mat <- st_routing_calculating(st_travel_time_day,st_efv_mat,cn_mat,ele_fd,cn_mat_nrow,cn_mat_ncol,f_dir)
#	} else {
#		st_route_flow_vol_mat[!is.na(stnet_mat)] <- 0
#	}

	### save isochrone area for constructing isochrone ###
#	gw_sub_iso_area <- {}
#	gw_sub_st_flow_vol_sum <- {}

	gw_iso_vol_acc_old <- 0

#	gw_st_flow_vol_sum_acc_old <- 0

	### grawing time for groundwater flow is 60 days or 2 months ###
	gw_hydrograph_drawing_time <- 60
	
	for (gw_iso_time in 1:gw_hydrograph_drawing_time) {
#	for (gw_iso_time in 1:gw_simulation_daily_length) {
#		gw_iso_area_acc <- length(st_travel_time_day[st_travel_time_day <= gw_iso_time & !is.na(st_travel_time_day)])*cell_size^2

		gw_iso_vol_acc <- cell_size*sum(st_efv_mat[st_travel_time_day <= gw_iso_time & !is.na(st_travel_time_day)] * st_width_mat[st_travel_time_day <= gw_iso_time & !is.na(st_travel_time_day)],na.rm=T)

#		gw_st_flow_vol_sum_acc <- sum(st_efv_mat[st_travel_time_day <= gw_iso_time & !is.na(st_travel_time_day)])

		if (gw_iso_time >= 2) {
			gw_iso_vol <- gw_iso_vol_acc - gw_iso_vol_acc_old
		} else {
			gw_iso_vol <- gw_iso_vol_acc
		}
		gw_iso_vol_acc_old <- gw_iso_vol_acc
		gw_sub_iso_vol[gw_iso_time] <- gw_iso_vol
	}
	gw_iso_vol_list[[gw_day]] <- gw_sub_iso_vol
}

### construct isochrone map for groundwater flow ###
gw_isochrone_vol <- gw_iso_vol_list[[1]]

for(gw_day2 in 2:gw_simulation_daily_length) {
	gw_iso_vol_temp <- gw_iso_vol_list[[gw_day2]]
	if ((length(gw_iso_vol_temp[gw_iso_vol_temp>0])+gw_day2-1)>1) {
		if ((length(gw_iso_vol_temp[gw_iso_vol_temp>0])+gw_day2-1)>gw_simulation_daily_length) {
			gw_length_iso_vol_temp <- gw_simulation_daily_length
			gw_length_gab1 <- (length(gw_iso_vol_temp[gw_iso_vol_temp>0])+gw_day2-1)-gw_simulation_daily_length
			if (length(gw_iso_vol_temp[gw_iso_vol_temp>0]) > 0) {
				gw_iso_vol_temp2 <- gw_iso_vol_temp[gw_iso_vol_temp>0]
				gw_iso_vol_temp[gw_day2:gw_length_iso_vol_temp] <- gw_iso_vol_temp2[1:(length(gw_iso_vol_temp2)-gw_length_gab1)]
				gw_iso_vol_temp[1:(gw_day2-1)] <- 0
			} else {
				gw_iso_vol_temp[1:(gw_day2-1)] <- 0
			}
		} else {
			gw_length_iso_vol_temp <- (length(gw_iso_vol_temp[gw_iso_vol_temp>0])+gw_day2-1)
			if (length(gw_iso_vol_temp[gw_iso_vol_temp>0]) > 0) {
				gw_iso_vol_temp[gw_day2:gw_length_iso_vol_temp] <- gw_iso_vol_temp[gw_iso_vol_temp>0]
				gw_iso_vol_temp[1:(gw_day2-1)] <- 0
			} else {
				gw_iso_vol_temp[1:(gw_day2-1)] <- 0
			}
		}
	} else {
		gw_iso_vol_temp <- rep(0,gw_simulation_daily_length)
	}
	gw_isochrone_vol <- gw_isochrone_vol + gw_iso_vol_temp
}
plot(gw_isochrone_vol/1000/24/3600,type="b")

}
