### groundwater routing ###

# define a function #
gw_routing_calculating <- function(gw_level_mat,cn_mat,gw_fd,cn_mat_nrow,cn_mat_ncol,f_dir,cell_size,soil_ks_mat,gw_base_level) {

gw_level_re_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

gw_level_re_mat <- gw_level_mat - gw_base_level

### groundwater flow simulation is done at the time step of a day ###
gw_route_inflow_vol_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
gw_route_inflow_vol_mat[!is.na(cn_mat)] <- 0

gw_route_outflow_vol_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
gw_route_outflow_vol_mat[!is.na(cn_mat)] <- 0

gw_gradient_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
gw_gradient_mat[!is.na(cn_mat)] <- 0

for (i in 1:cn_mat_nrow) {
	for (j in 1:cn_mat_ncol) {
		if (!is.na(cn_mat[i,j])) {
			curr_gw_level <- gw_level_re_mat[i,j]
			gw_flow_direction <- gw_fd[i,j]
			for (k in 1:8) {
				if (gw_flow_direction == f_dir[k]) {
					if (k == 1) {
						n_i <- i; n_j <- j+1; gw_distance <- cell_size
					} else { if (k == 2) { n_i <- i+1; n_j <- j+1; gw_distance <- cell_size*(2^0.5)
					} else { if (k == 3) { n_i <- i+1; n_j <- j; gw_distance <- cell_size
					} else { if (k == 4) { n_i <- i+1; n_j <- j-1; gw_distance <- cell_size*(2^0.5)
					} else { if (k == 5) { n_i <- i; n_j <- j-1; gw_distance <- cell_size
					} else { if (k == 6) { n_i <- i-1; n_j <- j-1; gw_distance <- cell_size*(2^0.5)
					} else { if (k == 7) { n_i <- i-1; n_j <- j; gw_distance <- cell_size
					} else { if (k == 8) { n_i <- i-1; n_j <- j+1; gw_distance <- cell_size*(2^0.5)
					} else { end_index <- 0 }}}}}}}
					}
					break
				}
			}
			next_gw_level <- gw_level_re_mat[n_i,n_j]
			if (is.na(cn_mat[n_i,n_j])) {
				next
			}

			### gw_gradient_mat was commented out on 20100511 ###
#			gw_gradient_mat[i,j] <- (curr_gw_level-next_gw_level)/gw_distance

#			if (gw_gradient_mat[i,j] < 0) {
#				gw_gradient_mat[i,j] <- 0
#			}

			### calculte groundwater volume, which is moving to the next downstream cell ###
			### that volume is an unit groundwater volume per unit cross sectional area ###
			### note: unit of saturated hydraulic conductivity of soil is micrometer per second ###
			### note: unit of groundwater volume is 'mm/day' ###
#			unit_gw_q <- ((soil_ks_mat[i,j]+soil_ks_mat[n_i,n_j])/1000*3600*24/2)*gw_gradient_mat[i,j]

#			if(curr_gw_level > next_gw_level) {
#				### fixed on 20100511 ###
#				unit_gw_q <- ((soil_ks_mat[i,j]+soil_ks_mat[n_i,n_j])/1000*3600*24/2)*(curr_gw_level^2-next_gw_level^2)/2/gw_distance^2
#			} else {
#				unit_gw_q <- 0
#			}

			### fixed on 20100528 ###
#			unit_gw_q <- ((soil_ks_mat[i,j]+soil_ks_mat[n_i,n_j])/1000*3600*24/2)*(curr_gw_level^2-next_gw_level^2)/2/gw_distance^2
#			unit_gw_q <- ((soil_ks_mat[i,j]+soil_ks_mat[n_i,n_j]/soil_por_mat[n_i,n_j])/1000*3600*24/2)*(curr_gw_level^2-next_gw_level^2)/2/gw_distance^2
			unit_gw_q <- 10*((soil_ks_mat[i,j]+soil_ks_mat[n_i,n_j])/1000*3600*24/2)*(curr_gw_level^2-next_gw_level^2)/2/gw_distance^2

			gw_route_outflow_vol_mat[i,j] <- gw_route_outflow_vol_mat[i,j] - unit_gw_q
			gw_route_inflow_vol_mat[n_i,n_j] <- gw_route_inflow_vol_mat[n_i,n_j] + unit_gw_q
		}
	}
}

#mean(gw_route_inflow_vol_mat,na.rm=T)
#mean(gw_route_outflow_vol_mat,na.rm=T)

gw_route_flow_vol_mat <- gw_route_inflow_vol_mat + gw_route_outflow_vol_mat

#mean(gw_route_flow_vol_mat,na.rm=T)

return(gw_route_flow_vol_mat)

}