source("runoff_data_loader.R")
runoff_data <- runoff_data_loading("all_runoff_hourly_ord.csv")
#runoff_data <- runoff_data[29274:35064]
runoff_data_length <- length(runoff_data)

surface_flow_hydrograph_list <- list(c(...))
#storm_time <- read.csv("storm_time_20100531.csv",header=T)
#storm_time <- storm_time[252:298,]

surface_flow_hydrograph_list_length <- length(surface_flow_hydrograph_list)
storm_time_length <- nrow(storm_time)

hydrograph <- {}

if (surface_flow_hydrograph_list_length == storm_time_length) {
	data_length <- storm_time_length
}

for (i in 1:data_length) {
	duration <- storm_time$duration[i] + storm_time$pause[i]
	simulation_period <- length(surface_flow_hydrograph_list[[i]])
	if(duration > simulation_period) {
		hydrograph <- append(hydrograph, surface_flow_hydrograph_list[[i]])
		zero_period <- duration - simulation_period
		hydrograph <- append(hydrograph, rep(0,zero_period))
	} else {
		hydrograph <- append(hydrograph, surface_flow_hydrograph_list[[i]])
	}
}

plot_data <- data.frame(hydrograph/1000*900/3600,runoff_data[1:length(hydrograph)])
plot(ts(plot_data),type="b")

plot(runoff_data[1:length(hydrograph)],ylim=c(0,100))
par(new=TRUE) 
plot(hydrograph/1000*900/3600,ylim=c(0,100),type="l")

write.csv(plot_data,"flow_comparison_201000503.csv")

