### derive the stream network with flow accumulation map

# define a function
initial_bank_storage_extraction <- function(flow_accumulation_file_name, min_bs, max_bs, stnet_mat) {

# load stream network map from a text file
#fac_line_data <- readLines("ord_fac.txt")
fac_line_data <- readLines(flow_accumulation_file_name)
fac_line_split <- strsplit(fac_line_data, " +")
fac_line_ncols <- unlist(fac_line_split[1])
fac_map_ncols <- as.numeric(fac_line_ncols[2])
fac_line_nrows <- unlist(fac_line_split[2])
fac_map_nrows <- as.numeric(fac_line_nrows[2])
fac_line_cellsize <- unlist(fac_line_split[5])
fac_map_cellsize <- as.numeric(fac_line_cellsize[2])
fac_line_nodata <- unlist(fac_line_split[6])
fac_map_nodata <- as.numeric(fac_line_nodata[2])
fac_line_length <- length(fac_line_split)

fac_mat <- matrix(data <- NA, nrow <- fac_map_nrows, ncol <- fac_map_ncols)

for (i in 1:fac_map_nrows) {
	fac_mat[i,] <- as.numeric(unlist(fac_line_split[i+6]))
}

max_fac_mat <- max(fac_mat,na.rm=TRUE)
bs_mat <- matrix(data <- NA, nrow <- fac_map_nrows, ncol <- fac_map_ncols)
bs_mat <- fac_mat/max_fac_mat*(max_bs-min_bs)+min_bs
bs_mat[is.na(stnet_mat)] <- NA

return(bs_mat)

}