### derive the stream network with flow accumulation map

# define a function
initial_soil_moisture_extraction <- function(flow_accumulation_file_name, min_sm, max_sm, cn_mat) {

# load stream network map from a text file
fac_line_data <- readLines(flow_accumulation_file_name)
fac_line_split <- strsplit(fac_line_data, " +")
fac_line_ncols <- unlist(fac_line_split[1])
fac_map_ncols <- as.numeric(fac_line_ncols[2])
fac_line_nrows <- unlist(fac_line_split[2])
fac_map_nrows <- as.numeric(fac_line_nrows[2])
fac_line_cellsize <- unlist(fac_line_split[5])
fac_map_cellsize <- as.numeric(fac_line_cellsize[2])
fac_line_nodata <- unlist(fac_line_split[6])
fac_map_nodata <- as.numeric(fac_line_nodata[2])
fac_line_length <- length(fac_line_split)

fac_mat <- matrix(data <- NA, nrow <- fac_map_nrows, ncol <- fac_map_ncols)

for (i in 1:fac_map_nrows) {
	fac_mat[i,] <- as.numeric(unlist(fac_line_split[i+6]))
}

max_fac_mat <- max(fac_mat,na.rm=TRUE)
sm_mat <- matrix(data <- NA, nrow <- fac_map_nrows, ncol <- fac_map_ncols)
sm_mat <- fac_mat/max_fac_mat*(max_sm-min_sm)+min_sm
sm_mat[is.na(cn_mat)] <- NA

return(sm_mat)

}