### LULC code extraction

# define a function
lulc_loading <- function(lulc_file_name) {

# Load lulc mat from a text file
lulc_line_data <- readLines(lulc_file_name)
lulc_line_split <- strsplit(lulc_line_data, " +")
lulc_line_ncols <- unlist(lulc_line_split[1])
lulc_mat_ncols <- as.numeric(lulc_line_ncols[2])
lulc_line_nrows <- unlist(lulc_line_split[2])
lulc_mat_nrows <- as.numeric(lulc_line_nrows[2])
lulc_line_cellsize <- unlist(lulc_line_split[5])
lulc_mat_cellsize <- as.numeric(lulc_line_cellsize[2])
lulc_line_nodata <- unlist(lulc_line_split[6])
lulc_mat_nodata <- as.numeric(lulc_line_nodata[2])
lulc_line_length <- length(lulc_line_split)

lulc_mat <- matrix(data <- NA, nrow <- lulc_mat_nrows, ncol <- lulc_mat_ncols)

for (i in 1:lulc_mat_nrows) {
	lulc_mat[i,] <- as.numeric(unlist(lulc_line_split[i+6]))
}

lulc_return <- list(lulc_mat, lulc_mat_nrows, lulc_mat_ncols, lulc_mat_nodata, lulc_mat_cellsize)
return(lulc_return)

###
}