### calculate potential ET with all hourly thiessen rainfall and temperature data ###

potential_ET_hourly_calculating <- function(time_year,time_month,time_day,time_hour,temperature_all) {

####### Evapotranspiration #######
##### define coordinate system and center point of the watershed #####
### need a program capable of converting UTM to Geo. ###
ws_lat <- 38.61
ws_lon <- -77.74
LLTZ <- 75 ### for Eastern
#LLTZ <- 90 ### for Central
#LLTZ <- 105 ### for Rocky
#LLTZ <- 120 ### for Pacific

##### calculate reference ET using Hargreave's equation #####
### hourly ET ###
# define the beginning and ending times of the storm event #
#sun_begin_time <- "1990/05/28/14.00"
#sun_end_time <- "1990/05/28/15.00"
sun_begin_time <- time_hour
sun_end_time <- time_hour+1
source("extraterrestrial_radiation_hourly.R")
ex_radiation_hourly <- ex_radiation_hourly_calculator(ws_lat,ws_lon,time_year,time_month,time_day,time_hour,LLTZ)

if (ex_radiation_hourly < 0) {
	ex_radiation_hourly <- 0
}

temperature_mean <- temperature_all$ave[temperature_all$Year == time_year & temperature_all$Month == time_month & temperature_all$Day == time_day]
temperature_max <- temperature_all$TMAX[temperature_all$Year == time_year & temperature_all$Month == time_month & temperature_all$Day == time_day]
temperature_min <- temperature_all$TMIN[temperature_all$Year == time_year & temperature_all$Month == time_month & temperature_all$Day == time_day]

#et0_daily <- 0.0023*(temperature_mean+17.8)*((temperature_max-temperature_min)^0.5)*ex_radiation_daily
et0_hourly <- 0.0023*(temperature_mean+17.8)*((temperature_max-temperature_min)^0.5)*ex_radiation_hourly

return(et0_hourly)

}
