### load all hourly thiessen rainfall data ###

rainfall_uniform_loading <- function(all_rainfall_file_name) {

#all_rainfall_data <- read.csv("all_rainfall_uniform_hourly.csv")
all_rainfall_data <- read.csv(all_rainfall_file_name)
all_rainfall_data_length <- nrow(all_rainfall_data)
all_rainfall_data_width <- ncol(all_rainfall_data)
Sum <- rowSums(all_rainfall_data[5:all_rainfall_data_width])
Mean <- rowMeans(all_rainfall_data[5:all_rainfall_data_width])
all_rainfall_data <- data.frame(all_rainfall_data,Sum,Mean)

row <- 1
pause_row <- 1

storm_no <- 0
year <- {}
month <- {}
day <- {}
hour <- {}
smean <- {}
duration <- {}
pause <- {}

while (row <= all_rainfall_data_length) {
	if (all_rainfall_data$Sum[row] > 0) {
		storm_no <- storm_no + 1
		year[storm_no] <- all_rainfall_data$Year[row]
		month[storm_no] <- all_rainfall_data$Month[row]
		day[storm_no] <- all_rainfall_data$Day[row]
		hour[storm_no] <- all_rainfall_data$Hour[row]
		smean[storm_no] <- 0
		pause[storm_no] <- pause_row - 1
		pause_row <- 0
		add_row <- 0
		while (all_rainfall_data$Sum[(row+add_row)] > 0) {
			smean[storm_no] <- smean[storm_no] + all_rainfall_data$Mean[(row+add_row)]
			add_row <- add_row + 1
		}
		duration[storm_no] <- add_row
		row <- row + add_row - 1
	}
	row <- row + 1
	pause_row <- pause_row + 1
}

pause <- pause[2:storm_no]
pause <- append(pause,0)

storm_time <- data.frame(year,month,day,hour,smean,duration,pause)
storm_time_original <- storm_time

### if temperal gab between two seperated storms is under 6 hours, ###
### they will be combined into a single storm ###
time_interval_between_events <- 12
storm_time_length <- length(storm_time_original$pause[storm_time_original$pause > time_interval_between_events])

#for (i in 1:(storm_time_length-1)) {
i <- 1
while (i <= storm_time_length) {
	if (storm_time$pause[i] <= time_interval_between_events) {
		storm_time$smean[i] <- storm_time$smean[i] + storm_time$smean[i+1]
		storm_time$duration[i] <- storm_time$duration[i] + storm_time$duration[i+1] + storm_time$pause[i]
		storm_time$pause[i] <- storm_time$pause[i+1]
		storm_time <- storm_time[-(i+1),]
		i <- i - 1
	}
	i <- i + 1
}

storm_time_adj <- storm_time

all_rainfall_data_list <- list(all_rainfall_data,storm_time_adj,storm_no,all_rainfall_data_length,all_rainfall_data_width)

return(all_rainfall_data_list)

}
