### define a function ###

sed_trans_capacity_calculating <- function(sediment_transport_equation_selection_code,flow_code,slope_mat,slope_degree_mat,manningn_mat,over_v_mat,st_v_mat,over_depth_mat,st_depth_mat,over_width_mat,st_width_mat,stnet_mat,water_density,soil_density,soil_d50_mat,soil_D50_mat,soil_D30_mat,soil_D90_mat,soil_D40_mat,gravity_acc,cn_mat,cn_mat_nrow,cn_mat_ncol,adj_settling_v_mat,SG,kinematic_viscosity,CSO,CSC) {

extent_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
flow_hydraulic_radius_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

if (flow_code == 1) {
	### in the case of overland flow ###
	extent_mat <- cn_mat
	flow_v_mat <- over_v_mat
	flow_depth_mat <- over_depth_mat
	flow_depth_mat[flow_depth_mat == 0] <- 0.000001
	flow_width_mat <- over_width_mat
	flow_hydraulic_radius_mat <- over_depth_mat
} else {
	### in the case of channel flow ###
	extent_mat <- stnet_mat
	flow_v_mat <- st_v_mat
	flow_depth_mat <- st_depth_mat
	flow_depth_mat[flow_depth_mat == 0] <- 0.000001
	flow_width_mat <- st_width_mat
	flow_hydraulic_radius_mat <- st_depth_mat*st_width_mat/(st_width_mat+2*st_depth_mat)
}

flow_hydraulic_radius_mat[flow_hydraulic_radius_mat == 0] <- 0.000001

flow_cms_mat <- 1/manningn_mat*(slope_mat^0.5)*((flow_hydraulic_radius_mat)^(2/3))*flow_depth_mat*flow_width_mat

sine_slope_mat <- sin(slope_degree_mat/180*pi)

### unit of shear_v_mat is 'm/s' ###
shear_v_mat <- (gravity_acc*flow_hydraulic_radius_mat*sine_slope_mat)^0.5

shear_Reynold_No <- shear_v_mat*soil_D50_mat/kinematic_viscosity

critical_Shield_parameter <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

### critial Shiled parameter ###
if (flow_code == 1) {
	### in the case of overland flow ###
	critical_Shield_parameter <- CSO/(shear_Reynold_No^0.1709)
#	critical_Shield_parameter <- 0.1224/(shear_Reynold_No^0.1709)
} else {
	### in the case of channel flow ###
	critical_Shield_parameter[!is.na(extent_mat)] <- CSC
#	critical_Shield_parameter[!is.na(extent_mat)] <- 0.056
}

### Shiled_parameter is dimensionless ###
Shield_par_mat <- flow_hydraulic_radius_mat*sine_slope_mat/(soil_D50_mat*(SG-1))

### fluid density ###
### if sediment concentration is high, ###
### density of fluid becomes bigger than that of clean water ###
#fluid_density_mat <- (1-sed_con_mat/soil_density)*water_density+sed_con_mat

### unit of gravity_acc (9.8) is 'm/s^2' ###
### unit of soil_density (2.65) and water_density (1.00) is 'g/l' ###
### unit of soil_d50_mat is 'micro meter' ###
### unit of D50_mat is 'm' ###

soil_d50_mat <- soil_D50_mat*(10^6)

if (sediment_transport_equation_selection_code == 1) {

	##### Gover equation for equation_selection_code of 1 #####

	### unit of Gover_c is 'micro meter' ###
	Gover_c <- ((soil_d50_mat+5)/0.32)^(-0.6)
	Gover_d <- ((soil_d50_mat+5)/300)^0.25

	### unit of Gover_S_Vcr is 'cm/s' ###
	### it is assumed 0.4cm/s ###
	Gover_S_Vcr_mat <- matrix(data <- 0.4, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

	### unit of velocity of flow in Gover equation is 'cm/s' ###
	### but unit of flow velocity (flow_v_mat) is 'm/s' ###
	Gover_S_V_mat <- slope_mat*flow_v_mat*100

	Gover_Tcf_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
	if (length(Gover_c[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat]) > 0) {
#		Gover_Tcf_mat[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat] <- Gover_c[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat]*((Gover_S_V_mat[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat]-Gover_S_Vcr_mat[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat])^Gover_d[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat])*(1000*SG)
		Gover_Tcf_mat[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat] <- Gover_c[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat]*((Gover_S_V_mat[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat]-Gover_S_Vcr_mat[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat])^Gover_d[!is.na(extent_mat) & Gover_S_V_mat > Gover_S_Vcr_mat])*(1000*SG)
		Gover_Tcf_mat[!is.na(extent_mat) & Gover_S_V_mat <= Gover_S_Vcr_mat] <- 0
	} else {
		Gover_Tcf_mat[!is.na(extent_mat)] <- 0
	}
	
	Gover_Tcf_mat[Gover_Tcf_mat > 1250] <- 1250

	### unit of Gover_Tc is 'g/l' ###
	Gover_Tc_mat <- Gover_Tcf_mat/(1-Gover_Tcf_mat/(1000*SG))
	Tc_mat <- Gover_Tc_mat

} else { if (sediment_transport_equation_selection_code == 2) {

	##### Abrahams equation for equation_selection_code of 2 #####

	### Abra_Cr_mat is dimensionless ###
	Abra_Cr_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
	Abra_Cr_mat[!is.na(extent_mat)] <- 0
	Abra_Cr_mat[!is.na(stnet_mat)] <- 0.7

	### unit of Abra_Dr is 'm' ###
	Abra_Dr <- 0.1

	### Abra_a_mat is dimensionless ###
	Abra_a_mat <- 10^(-0.42*((Abra_Cr_mat/Abra_Dr)^0.2))

	### Abra_b is dimensionless ###
	Abra_b <- 3.4

	### Abra_c is dimensionless ###
	Abra_c_mat <- 1+0.42*(Abra_Cr_mat/Abra_Dr)^0.2

	### unit of Abra_w_mat is 'm/s' ###
	Abra_w_mat <- (gravity_acc*(SG-1)*soil_D50_mat)^0.5

	### Abra_d is different from the Gover_d ###
	Abra_d_mat <- matrix(data <- -0.5, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
	if (length(unique(shear_v_mat[!is.na(extent_mat) & adj_settling_v_mat/shear_v_mat > 3])) > 0) {
		Abra_d_mat[!is.na(extent_mat) & Abra_w_mat/shear_v_mat > 3] <- 0
	}

	### critical Shield paramter is dimensionless ###
	Abra_Ycr <- critical_Shield_parameter

	### unit of Abra_qb_mat is 'm3/s' ###
	### Abra_qb_mat: volumetric bedload transport per unit width ###
	Abra_qb_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
	if (length(Shield_par_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]) > 0) {
#		Abra_qb_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat] <- Abra_a_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]*soil_D50_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]*shear_v_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]*Shield_par_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]*((1-Abra_Ycr[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]/Shield_par_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat])^Abra_b[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat])*((flow_v_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]/shear_v_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat])^Abra_c_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat])*((Abra_w_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat]/shear_v_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat])^Abra_d_mat[!is.na(extent_mat) & 1 < Abra_Ycr/Shield_par_mat])
		Abra_qb_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat] <- Abra_a_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]*soil_D50_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]*shear_v_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]*Shield_par_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]*((1-Abra_Ycr[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]/Shield_par_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat])^Abra_b[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat])*((flow_v_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]/shear_v_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat])^Abra_c_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat])*((Abra_w_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat]/shear_v_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat])^Abra_d_mat[!is.na(extent_mat) & 1 > Abra_Ycr/Shield_par_mat])
		Abra_qb_mat[!is.na(extent_mat) & 1 <= Abra_Ycr/Shield_par_mat] <- 0
	} else {
		Abra_qb_mat[!is.na(extent_mat)] <- 0
	}

	Abra_Tc_mat <- Abra_qb_mat*flow_width_mat*(1000*SG)/flow_cms_mat
	Tc_mat <- Abra_Tc_mat

} else { if (sediment_transport_equation_selection_code == 3) {

	##### Low equation for equation_selection_code of 3 #####

	### critical Shield paramter is dimensionless ###
	Low_Ycr <- critical_Shield_parameter

	Low_qb_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
	if (length(unique(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr])) > 0) {
#		Low_qb_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr] <- (6.42/((SG-1)^0.5))*(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]-Low_Ycr)*soil_D50_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]*flow_v_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]*(slope_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]^0.6)
		Low_qb_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr] <- (6.42/((SG-1)^0.5))*(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]-Low_Ycr)*soil_D50_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]*flow_v_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]*(slope_mat[!is.na(extent_mat) & Shield_par_mat > Low_Ycr]^0.6)
		Low_qb_mat[!is.na(extent_mat) & Shield_par_mat <= Low_Ycr] <- 0
	} else {
		Low_qb_mat[!is.na(extent_mat)] <- 0
	}

	Low_Tc_mat <- Low_qb_mat*flow_width_mat*(1000*SG)/flow_cms_mat
	Tc_mat <- Low_Tc_mat

} else { if (sediment_transport_equation_selection_code == 4) {

	##### Rickenmann equation for equation_selection_code of 4 #####

	Rick_q_mat <- flow_cms_mat/flow_width_mat
	Rick_qcr_mat <- 0.065*((SG-1)^1.67)*(gravity_acc^0.5)*(soil_D50_mat^1.5)*(slope_mat^(-1.12))

	Rick_qb_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
	if (length(Rick_q_mat[Rick_q_mat[!is.na(extent_mat)] > Rick_qcr_mat[!is.na(extent_mat)]]) > 0) {
#		Rick_qb_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat] <- 12.6/((SG-1)^1.6)*((soil_D90_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat]/soil_D30_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat])^0.2)*(Rick_q_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat]-Rick_qcr_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat])*(slope_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat]^2)
		Rick_qb_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat] <- 12.6/((SG-1)^1.6)*((soil_D90_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat]/soil_D30_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat])^0.2)*(Rick_q_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat]-Rick_qcr_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat])*(slope_mat[!is.na(extent_mat) & Rick_q_mat > Rick_qcr_mat]^2)
		Rick_qb_mat[!is.na(extent_mat) & Rick_q_mat - Rick_qcr_mat] <- 0
	} else {
		Rick_qb_mat[!is.na(extent_mat)] <- 0
	}

	Rick_Tc_mat <- Rick_qb_mat*flow_width_mat*(1000*SG)/flow_cms_mat
	Rick_Tc_mat[!is.na(extent_mat) & flow_cms_mat == 0] <- 0
	Tc_mat <- Rick_Tc_mat

} else { if (sediment_transport_equation_selection_code == 5) {

	##### Yalin equation for equation_selection_code of 5 #####

	Yalin_as <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
#	Yalin_as[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter] <- 2.45/(SG^0.4)*((critical_Shield_parameter*(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]/critical_Shield_parameter-1))^0.5)
	Yalin_as[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter] <- 2.45/(SG^0.4)*(critical_Shield_parameter[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]^0.5)*(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]/critical_Shield_parameter[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]-1)
	Yalin_as[!is.na(extent_mat) & Shield_par_mat <= critical_Shield_parameter] <- 0.00001

	Yalin_P_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
#	Yalin_P_mat[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter] <- 0.635*(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]/critical_Shield_parameter-1)*(1-log(1+Yalin_as[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter])/Yalin_as[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter])
	Yalin_P_mat[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter] <- 0.635*(Shield_par_mat[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]/critical_Shield_parameter[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter]-1)*(1-log(1+Yalin_as[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter])/Yalin_as[!is.na(extent_mat) & Shield_par_mat > critical_Shield_parameter])
	Yalin_P_mat[!is.na(extent_mat) & Shield_par_mat <= critical_Shield_parameter] <- 0.00001

	Yalin_qs_mat <- (1000*(SG-water_density))*soil_D50_mat*shear_v_mat*Yalin_P_mat
	Yalin_qs_mat[Yalin_qs_mat < 0] <- 0

	Yalin_Tc_mat <- Yalin_qs_mat*flow_width_mat/flow_cms_mat
	Yalin_Tc_mat[!is.na(extent_mat) & flow_cms_mat == 0] <- 0
	Tc_mat <- Yalin_Tc_mat

} else { if (sediment_transport_equation_selection_code == 6) {

	##### Yang equation for equation_selection_code of 6 #####

	Yang_I_mat <- 5.435-0.286*log10(adj_settling_v_mat*soil_D50_mat/kinematic_viscosity)-0.457*log10(shear_v_mat/adj_settling_v_mat)
	Yang_J_mat <- 1.799-0.409*log10(adj_settling_v_mat*soil_D50_mat/kinematic_viscosity)-0.314*log10(shear_v_mat/adj_settling_v_mat)

	Yang_Vcr_omega_mat <- 2.5/(log10(shear_v_mat*soil_D50_mat/kinematic_viscosity)-0.06)+0.66
	Yang_Vcr_omega_mat[Yang_Vcr_omega_mat < 2.05] <- 2.05

	Yang_Cp_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
#	Yang_Cp_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat] <- 10^(Yang_I_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]+Yang_J_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]*log10(flow_v_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]*slope_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]/(adj_settling_v_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]/3600)-Yang_Vcr_omega_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]*slope_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]))
	Yang_Cp_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat] <- 10^(Yang_I_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]+Yang_J_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]*log10(flow_v_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]*slope_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]/adj_settling_v_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]-Yang_Vcr_omega_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]*slope_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) > Yang_Vcr_omega_mat*slope_mat]))
	Yang_Cp_mat[!is.na(extent_mat) & flow_v_mat*slope_mat/(adj_settling_v_mat/3600) <= Yang_Vcr_omega_mat*slope_mat] <- 0.00001

	Yang_Cp_mat[!is.na(extent_mat) & Yang_Cp_mat > 1060] <- 1060

	Yang_Tc_mat <- ((1000*water_density)*Yang_Cp_mat/(10^6))/(1-Yang_Cp_mat/(10^6))
	Tc_mat <- Yang_Tc_mat
	
} else { if (sediment_transport_equation_selection_code == 7) {

	##### Bagnold equation for equation_selection_code of 7 #####

	### unit of stream power is 'kg/s^3' ###
	Bag_stream_power_mat <- (1000*water_density)*flow_depth_mat*slope_mat*flow_v_mat
	Bag_critical_stream_power_mat <- 290*(soil_D50_mat^1.5)*log10(12*flow_depth_mat/soil_D50_mat)
	Bag_ref_excess_stream_power <- 0.5

	### unit of reference water depth is 'm' ###
	Bag_ref_water_depth <- 0.1

	### unit of reference grain size is 'm' ###
	Bag_ref_grain_size <- 0.0011

	### unit of reference sediment tranport rate is 'kg/m/s' ###
	Bag_ref_sed_trans_rate <- 0.1
	
	### unit of sediment transport rate is 'kg/m/s' ###
	Bag_qs_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
#	Bag_qs_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat] <- Bag_ref_grain_size*(((Bag_stream_power_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat]-Bag_critical_stream_power_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat])/Bag_ref_excess_stream_power)^(3/2))*((flow_depth_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat]/Bag_ref_water_depth)^(-2/3))*((soil_D50_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat]/Bag_ref_grain_size)^(-1/2))
	Bag_qs_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat] <- Bag_ref_sed_trans_rate*(((Bag_stream_power_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat]-Bag_critical_stream_power_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat])/Bag_ref_excess_stream_power)^(3/2))*((flow_depth_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat]/Bag_ref_water_depth)^(-2/3))*((soil_D50_mat[!is.na(extent_mat) & Bag_stream_power_mat > Bag_critical_stream_power_mat]/Bag_ref_grain_size)^(-1/2))
	Bag_qs_mat[!is.na(extent_mat) & Bag_stream_power_mat <= Bag_critical_stream_power_mat] <- 0

	Bag_Tc_mat <- Bag_qs_mat*flow_width_mat/flow_cms_mat
	Tc_mat <- Bag_Tc_mat

} else { if (sediment_transport_equation_selection_code == 8) {

	##### Schoklitsch equation for equation_selection_code of 8 #####
	
	Sch_qcr_mat <- 0.26*((SG-1)^(5/3))*(soil_D40_mat^(3/2))*(slope_mat^(-7/6))
	Sch_q_mat <- flow_cms_mat/flow_width_mat
#	Sch_qs_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat] <- 2.5*water_density*(slope_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat]^1.5)*(Sch_q_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat]-Sch_qcr_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat])
	Sch_qs_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat] <- 2.5*(1000*water_density)*(slope_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat]^1.5)*(Sch_q_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat]-Sch_qcr_mat[!is.na(extent_mat) & Sch_q_mat > Sch_qcr_mat])
	Sch_qs_mat[!is.na(extent_mat) & Sch_q_mat <= Sch_qcr_mat] <- 0

	Sch_Tc_mat <- Sch_qs_mat*flow_width_mat/flow_cms_mat
	Tc_mat <- Sch_Tc_mat

}}}}}}}}

return(Tc_mat)

}


