### define a function ###

sediment_transport_simulating <- function(sed_con_m_mat, sediment_transport_equation_selection_code, soil_text_mat, cn_mat, cn_mat_nrow, cn_mat_ncol, rainfall_mat, over_depth_mat, over_width_mat, st_depth_mat, slope_mat, slope_degree_mat, manningn_mat, over_v_mat, st_v_mat, st_width_mat, stnet_mat, water_density, soil_density, soil_D30_mat, soil_D40_mat, soil_D50_mat, soil_D90_mat, gravity_acc, soil_cohesion_mat, SG, plant_height_mat, kinematic_viscosity, soil_detachability_mat, growing_stage, etcoeff_list, etcover_list, pave_list, lulc_mat, time_year, time_month, time_day, rain_time, st_length_mat, efv_mat, CSO, CSC, cell_size) {

### rainfall_mat should be rainfall intensity so thus its unit is mm/hr ###
### therefore, it temporal scale of the model is changed, its calculation should be adjusted ###

rainfall_1mm_mat <- rainfall_mat
rainfall_1mm_mat[rainfall_1mm_mat < 1] <- 1
ero_KE_rain_mat <- 8.95+8.44*log10(rainfall_1mm_mat)

### depth of flow ###
### flow should be seperated into overland and channel ###

### width of flow ###
### it should be fixed with consideration of flow direction ###
### in addition, flow should be seperated into overland and channel ###

### unit of gravity_acc is m/s^2 ###
gravity_acc <- 9.8

### SG: specific gravity of soil particle = 2.65 (g/cm^3) ###
SG <- 2.65

### water density ###
water_density <- 1.00

### kinematic viscosity of water at 20 Celcius degree ###
### unit of kinematic_viscosity is m^2/s ###
kinematic_viscosity <- 1.1171*10^-6

dep_DF_mass_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

### soil_Dxx_mat: mass fraction of soil particle whose radius is less than 'xx' ###

### unit of settling velocity 'm/hour' ###
settling_v_mat <- 1/18*(SG-1)*gravity_acc*(soil_D50_mat^2)/kinematic_viscosity*3600

#Reynold_No <- (settling_v_mat/3600)*soil_D50_mat/kinematic_viscosity

### unit of adh_settling velocity 'm/hour' ###
adj_settling_v_mat <- settling_v_mat/2
#adj_settling_v_mat <- (1-2.15*c)*(1-0.75*c^0.33)*settling_v_mat

### plant_height should be estimated based on land use map ###
### but it was assumed as 1 m corresponding to plant_height used for actual ET calculation ###
plant_height <- 1
ero_KE_throughfall_mat <- 15.8*(plant_height^0.5)-5.87

ero_KE_mat <- ero_KE_rain_mat + ero_KE_throughfall_mat

### the exponent can vary from 0.9 to 3.1, and 2.0 is recommended ###
ero_DR_b <- 2.0

### 'soil_detachability_mat' should be determined experimentally ###
### however, in this study, the lookup table of EUROSEM was adapted ###
### unit of ero_DR_m_mat is 'g/m^2/hour' (rate per unit area) ###
### detachment of soil particle (erosion) by rainfall drop energy is assumed occured on the overland ###
ero_DR_over_m_mat <- soil_detachability_mat*ero_KE_mat*exp(-ero_DR_b*over_depth_mat*1000)

### pavement surface should be determined based on land use ###
### Now, unit of ero_DR_over_m_mat is converted to 'kg/m^2/hour' ###
source("ET_coefficient.R")
ET_coeff_return <- ET_coeff_extraction(growing_stage,etcoeff_list,etcover_list,pave_list,lulc_mat,time_year,time_month,time_day)
ero_DR_pave_mat <- ET_coeff_return[[3]]
ero_DR_over_m_mat <- (1-ero_DR_pave_mat)*ero_DR_over_m_mat/1000

### unit of ero_DR_mass_mat is 'kg/hour' ###
ero_DR_mass_mat <- ero_DR_over_m_mat*cell_size^2
#ero_DR_mass_mat[!is.na(cn_mat)] <- 0

sediment_transport_equation_selection_code_for_overland <- 5
sediment_transport_equation_selection_code_for_stream <- 5

### unit of sed_trans_capacity_m_mat is 'g/l' or 'kg/m^3' ###
sed_trans_capacity_over_m_mat <- sed_trans_capacity_calculating(sediment_transport_equation_selection_code_for_overland,1,slope_mat,slope_degree_mat,manningn_mat,over_v_mat,st_v_mat,over_depth_mat,st_depth_mat,over_width_mat,st_width_mat,stnet_mat,water_density,soil_density,soil_d50_mat,soil_D50_mat,soil_D30_mat,soil_D90_mat,soil_D40_mat,gravity_acc,cn_mat,cn_mat_nrow,cn_mat_ncol,adj_settling_v_mat,SG,kinematic_viscosity,CSO,CSC)
sed_trans_capacity_st_m_mat <- sed_trans_capacity_calculating(sediment_transport_equation_selection_code_for_stream,2,slope_mat,slope_degree_mat,manningn_mat,over_v_mat,st_v_mat,over_depth_mat,st_depth_mat,over_width_mat,st_width_mat,stnet_mat,water_density,soil_density,soil_d50_mat,soil_D50_mat,soil_D30_mat,soil_D90_mat,soil_D40_mat,gravity_acc,cn_mat,cn_mat_nrow,cn_mat_ncol,adj_settling_v_mat,SG,kinematic_viscosity,CSO,CSC)

sed_con_over_m_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
sed_con_st_m_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

### assign the initial sediment concentration ###
if (rain_time == 1) {
	sed_con_over_m_mat <- ero_DR_over_m_mat/(rainfall_mat/1000+settling_v_mat)
	sed_con_st_m_mat[!is.na(stnet_mat)] <- 0
} else {
	sed_con_over_m_mat[!is.na(cn_mat)] <- sed_con_m_mat[!is.na(cn_mat)]
	sed_con_st_m_mat[!is.na(stnet_mat)] <- sed_con_m_mat[!is.na(stnet_mat)]
}

### unit of ero_DF_over_m_mat and ero_DF_st_m_mat is 'kg/m^2/hour' or rate per unit area ###
### unit of sed_con_over_m_mat is 'kg/m^3'###
### unit of sed_trans_capacity_over_m_mat is 'g/l' or 'kg/m^3' ###
ero_DF_over_m_mat <- adj_settling_v_mat*(sed_trans_capacity_over_m_mat-sed_con_over_m_mat)
ero_DF_st_m_mat <- adj_settling_v_mat*(sed_trans_capacity_st_m_mat-sed_con_st_m_mat)

##### it should be connected to 'sediment_detach_index_mat' ###
ero_DF_beta_over_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
ero_DF_beta_st_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
sediment_detach_index_over_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
sediment_detach_index_st_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

if (length(unique(ero_DF_over_m_mat[!is.na(cn_mat) & ero_DF_over_m_mat <= 0])) > 0) {
	ero_DF_beta_over_mat[!is.na(cn_mat) & ero_DF_over_m_mat <= 0] <- 1
	sediment_detach_index_over_mat[!is.na(cn_mat) & ero_DF_over_m_mat <= 0] <- -1 ### deposition ###
}

if (length(unique(ero_DF_st_m_mat[!is.na(stnet_mat) & ero_DF_st_m_mat <= 0])) > 0) {
	ero_DF_beta_st_mat[!is.na(stnet_mat) & ero_DF_st_m_mat <= 0] <- 1
	sediment_detach_index_st_mat[!is.na(stnet_mat) & ero_DF_st_m_mat <= 0] <- -1 ### deposition ###
}

if (length(unique(ero_DF_over_m_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat <= 1])) > 0) {
	ero_DF_beta_over_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat <= 1] <- 0.335 ### erosion ###
	sediment_detach_index_over_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat <= 1] <- 1 ### erosion ###
}

if (length(unique(ero_DF_over_m_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat > 1])) > 0) {
	ero_DF_beta_over_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat > 1] <- 0.79*exp(-0.85*soil_cohesion_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat > 1]) ### erosion ###
	sediment_detach_index_over_mat[!is.na(cn_mat) & ero_DF_over_m_mat > 0 & soil_cohesion_mat > 1] <- 1 ### erosion ###
}

if (length(unique(ero_DF_st_m_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat <= 1])) > 0) {
	ero_DF_beta_st_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat <= 1] <- 1 ### erosion ###
	sediment_detach_index_st_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat <= 1] <- 1 ### erosion ###
}

if (length(unique(ero_DF_st_m_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat > 1])) > 0) {
	ero_DF_beta_st_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat > 1] <- 0.79*exp(-0.85*soil_cohesion_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat > 1]) ### erosion ###
	sediment_detach_index_st_mat[!is.na(stnet_mat) & ero_DF_st_m_mat > 0 & soil_cohesion_mat > 1] <- 1 ### erosion ###
}

ero_DF_over_m_mat <- ero_DF_beta_over_mat*ero_DF_over_m_mat
#ero_DF_over_m_mat[!is.na(cn_mat) & ero_DF_over_m_mat < 0] <- 0
ero_DF_st_m_mat <- ero_DF_beta_st_mat*ero_DF_st_m_mat
#ero_DF_st_m_mat[!is.na(stnet_mat) & ero_DF_st_m_mat < 0] <- 0

### unit of ero_DF_over_m_mat is 'kg/m^2/hour' ###
### unit of ero_DF_over_mass_mat is 'kg/hour' ###
ero_DF_over_mass_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
ero_DF_over_mass_mat[!is.na(cn_mat)] <- 0
if (length(sediment_detach_index_over_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == 1]) > 0) {
	ero_DF_over_mass_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == 1] <- ero_DF_over_m_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == 1]*cell_size^2
}
if (length(sediment_detach_index_over_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1]) > 0) {
#	ero_DF_over_mass_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1] <- adj_settling_v_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1]*sed_trans_capacity_over_m_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1]*cell_size^2
	ero_DF_over_mass_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1] <- 0
}

ero_DF_over_mass_mat <- (1-ero_DR_pave_mat)*ero_DF_over_mass_mat

ero_DF_st_mass_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
ero_DF_st_mass_mat[!is.na(stnet_mat)] <- 0
if (length(sediment_detach_index_st_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == 1]) > 0) {
	ero_DF_st_mass_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == 1] <- ero_DF_st_m_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == 1]*st_width_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == 1]*st_length_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == 1]
}
if (length(sediment_detach_index_st_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]) > 0) {
#	ero_DF_st_mass_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1] <- adj_settling_v_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]*sed_trans_capacity_st_m_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]*st_width_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]*st_length_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]
	ero_DF_st_mass_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1] <- 0
}

ero_DF_mass_mat <- ero_DF_over_mass_mat
ero_DF_mass_mat[!is.na(stnet_mat)] <- ero_DF_mass_mat[!is.na(stnet_mat)] + ero_DF_st_mass_mat[!is.na(stnet_mat)]

### unit of water_vol_mat is 'm^3' ###
water_vol_mat_check <- efv_mat/1000*(cell_size^2)
water_vol_mat_check[!is.na(cn_mat) & water_vol_mat_check == 0] <- 0.0001

sed_con_m_mat_check <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
sed_con_m_mat_check[!is.na(cn_mat) & water_vol_mat_check > 0] <- ero_DF_mass_mat[!is.na(cn_mat) & water_vol_mat_check > 0]/water_vol_mat_check[!is.na(cn_mat) & water_vol_mat_check > 0]/2.65

sed_con_m_mat_check_old <- sed_con_m_mat_check
ero_DF_mass_mat[!is.na(cn_mat) & sed_con_m_mat_check > 1060] <- water_vol_mat_check[!is.na(cn_mat) & sed_con_m_mat_check > 1060]*1060
dep_DF_mass_mat[!is.na(cn_mat) & sed_con_m_mat_check > 1060] <- (sed_con_m_mat_check_old[!is.na(cn_mat) & sed_con_m_mat_check > 1060] - 1060)*water_vol_mat_check[!is.na(cn_mat) & sed_con_m_mat_check > 1060]

#if (rain_time == 1) {
#	dep_DF_acc_mass_mat <- dep_DF_mass_mat
#} else {
#	dep_DF_acc_mass_mat[!is.na(cn_mat) & sed_con_m_mat_check > 1060] <- dep_DF_acc_mass_mat[!is.na(cn_mat) & sed_con_m_mat_check > 1060] + dep_DF_mass_mat[!is.na(cn_mat) & sed_con_m_mat_check > 1060]
#}

sed_con_m_mat_check[!is.na(cn_mat) & sed_con_m_mat_check > 1060] <- 1060

#ero_DF_mass_mat[54,28] <- 0
#ero_DF_mass_mat[54,29] <- 0
#ero_DF_mass_mat[54,30] <- 0
#ero_DF_mass_mat[55,27] <- 0
#ero_DF_mass_mat[55,28] <- 0
#ero_DF_mass_mat[55,29] <- 0
#ero_DF_mass_mat[55,30] <- 0
#ero_DF_mass_mat[56,27] <- 0
#ero_DF_mass_mat[56,28] <- 0
#ero_DF_mass_mat[56,29] <- 0
#ero_DF_mass_mat[73,47] <- 0
#ero_DF_mass_mat[74,46] <- 0
#ero_DF_mass_mat[74,47] <- 0

ero_mass_mat <- ero_DF_mass_mat + ero_DR_mass_mat

#################
### depostion ###
#################

dep_DF_over_mass_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
dep_DF_st_mass_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

dep_DF_over_mass_mat[!is.na(cn_mat)] <- 0
if (length(dep_DF_over_mass_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1]) > 0) {
	dep_DF_over_mass_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1] <- -ero_DF_over_m_mat[!is.na(cn_mat) & sediment_detach_index_over_mat == -1]*cell_size^2
}

dep_DF_st_mass_mat[!is.na(stnet_mat)] <- 0
if (length(dep_DF_st_mass_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]) > 0) {
	dep_DF_st_mass_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1] <- -ero_DF_st_m_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]*st_width_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]*st_length_mat[!is.na(stnet_mat) & sediment_detach_index_st_mat == -1]
}

dep_DF_mass_mat[!is.na(cn_mat)] <- dep_DF_mass_mat[!is.na(cn_mat)] + dep_DF_over_mass_mat[!is.na(cn_mat)]
dep_DF_mass_mat[!is.na(stnet_mat)] <- dep_DF_mass_mat[!is.na(stnet_mat)] + dep_DF_over_mass_mat[!is.na(stnet_mat)]

#dep_DF_acc_mass_mat[!is.na(cn_mat)] <- dep_DF_acc_mass_mat[!is.na(cn_mat)] + dep_DF_over_mass_mat[!is.na(cn_mat)]
#dep_DF_acc_mass_mat[!is.na(stnet_mat)] <- dep_DF_acc_mass_mat[!is.na(stnet_mat)] + dep_DF_st_mass_mat[!is.na(stnet_mat)]

sediment_transport_simulation_return_list <- list(ero_mass_mat,ero_DR_mass_mat,ero_DF_over_mass_mat,ero_DF_st_mass_mat,ero_DF_mass_mat,dep_DF_over_mass_mat,dep_DF_st_mass_mat,dep_DF_mass_mat,sed_trans_capacity_over_m_mat,sed_trans_capacity_st_m_mat)

return(sediment_transport_simulation_return_list)

}




