### load slope matrix in percentage ###

### define a function ###
slope_loading <- function(slope_file_name) {

#### Load slope map from a text file ###
slope_line_data <- readLines(slope_file_name)
#slope_line_data <- readLines("owlrun_slp.txt")
slope_line_split <- strsplit(slope_line_data, " +")
slope_line_ncols <- unlist(slope_line_split[1])
slope_map_ncols <- as.numeric(slope_line_ncols[2])
slope_line_nrows <- unlist(slope_line_split[2])
slope_map_nrows <- as.numeric(slope_line_nrows[2])
slope_line_cellsize <- unlist(slope_line_split[5])
cell_size <- as.numeric(slope_line_cellsize[2])
slope_line_nodata <- unlist(slope_line_split[6])
slope_map_nodata <- as.numeric(slope_line_nodata[2])
slope_line_length <- length(slope_line_split)

slope_data_mat <- matrix(data <- NA, nrow <- slope_map_nrows, ncol <- slope_map_ncols)

for (i in 1:slope_map_nrows) {
	slope_data_mat[i,] <- as.numeric(unlist(slope_line_split[i+6]))
}

slope_data_mat[slope_data_mat < 0] <- NA

return(slope_data_mat)

}
