
soil_EUROSEM_loading <- function(soil_comp_file_name, soil_chorizon_file_name, soil_chtextgrp_file_name, soil_chtexture_file_name, soil_mat) {

# Identify percentages of components in a soil map
soil_comp_line_data <- readLines(soil_comp_file_name)
#soil_comp_line_data <- readLines("comp.txt")
soil_comp_line_length <- length(soil_comp_line_data)
soil_comp_perc <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_mukey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_cokey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)

for (i in 1:soil_comp_line_length) {
	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", fixed=TRUE)
#	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", extended=FALSE)
	soil_comp_line_split_unlist <- unlist(soil_comp_line_split)
	soil_comp_line_split_unlist_length <- length(soil_comp_line_split_unlist)
	soil_comp_perc[i] <- as.numeric(soil_comp_line_split_unlist[2])
	soil_mukey_temp4 <- soil_comp_line_split_unlist[soil_comp_line_split_unlist_length]
	soil_mukey_temp5 <- unlist(strsplit(soil_mukey_temp4,"\""))[2]
	soil_mukey_temp6 <- unlist(strsplit(soil_mukey_temp5,":"))[1]
	soil_comp_mukey[i] <- as.numeric(soil_mukey_temp6)
	soil_cokey_temp4 <- unlist(strsplit(soil_mukey_temp5,":"))[2]
	soil_comp_cokey[i] <- as.numeric(soil_cokey_temp4)
}

soil_data_comp <- data.frame(soil_comp_mukey, soil_comp_cokey, soil_comp_perc)

soil_mukey_list <- unique(soil_comp_mukey)
soil_mukey_list_length <- length(soil_mukey_list)

# Identify soil map unit with MUKEY, soil components with COKEY, and soil horizon with CHKEY
soil_chorizon_line_data <- readLines(soil_chorizon_file_name)
#soil_chorizon_line_data <- readLines("chorizon.txt")
soil_chorizon_line_length <- length(soil_chorizon_line_data)
soil_mukey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_cokey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chkey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_depth <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

for (i in 1:soil_chorizon_line_length) {
#	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", extended=FALSE)
	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", fixed=TRUE)
	soil_chorizon_line_split_unlist <- unlist(soil_chorizon_line_split)
	soil_chorizon_line_split_unlist_length <- length(soil_chorizon_line_split_unlist)
	soil_mukey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length]
	soil_mukey_temp2 <- unlist(strsplit(soil_mukey_temp1,"\""))[2]
	soil_mukey_temp3 <- unlist(strsplit(soil_mukey_temp2,":"))[1]
	soil_chkey_temp1 <- unlist(strsplit(soil_mukey_temp2,":"))[2]
	soil_mukey[i] <- as.numeric(soil_mukey_temp3)
	soil_chkey[i] <- as.numeric(soil_chkey_temp1)
	soil_cokey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length-1]
	soil_cokey_temp2 <- unlist(strsplit(soil_cokey_temp1,"\""))[2]
	soil_cokey_temp3 <- unlist(strsplit(soil_cokey_temp2,":"))[2]
	soil_cokey[i] <- as.numeric(soil_cokey_temp3)
	soil_top_depth[i] <- as.numeric(soil_chorizon_line_split_unlist[7])
}

soil_chorizon_perc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

soil_data_chorizon <- data.frame(soil_mukey, soil_cokey, soil_chorizon_perc, soil_chkey, soil_top_depth)

soil_cokey_list <- unique(soil_data_chorizon$soil_cokey)
soil_cokey_list_length <- length(soil_cokey_list)

for (i in 1:soil_cokey_list_length) {
	soil_data_chorizon$soil_chorizon_perc[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_cokey == soil_cokey_list[i]]
}

soil_data_chorizon_top_chkey <- soil_data_chorizon$soil_chkey[soil_data_chorizon$soil_top_depth == 0]

soil_data_chorizon_top_chkey_length <- length(soil_data_chorizon_top_chkey)

soil_top_mukey2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_cokey2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_cokey_perc2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_chkey2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)

for (i in 1:soil_data_chorizon_top_chkey_length) {
	soil_top_mukey2[i] <- soil_data_chorizon$soil_mukey[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_cokey2[i] <- soil_data_chorizon$soil_cokey[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_cokey_perc2[i] <- soil_data_chorizon$soil_chorizon_perc[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_chkey2[i] <- soil_data_chorizon$soil_chkey[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
}

soil_EUROSEM_data <- data.frame(soil_top_mukey2, soil_top_cokey2, soil_top_cokey_perc2, soil_top_chkey2)

soil_top_mukey2_list <- unique(soil_EUROSEM_data$soil_top_mukey2)
soil_top_mukey2_list_length <- length(soil_top_mukey2_list)

soil_top_mukey3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_cokey3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_chkey3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)

for (i in 1:soil_top_mukey2_list_length) {
	if (length(soil_EUROSEM_data$soil_top_mukey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i]]) > 1) {
		biggest_perc2 <- max(c(soil_EUROSEM_data$soil_top_cokey_perc2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i]]))
		if (length(soil_EUROSEM_data$soil_top_mukey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2]) > 1) {
			soil_top_mukey3[i] <- soil_EUROSEM_data$soil_top_mukey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_cokey3[i] <- soil_EUROSEM_data$soil_top_cokey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_chkey3[i] <- soil_EUROSEM_data$soil_top_chkey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2][1]
		} else {
			soil_top_mukey3[i] <- soil_EUROSEM_data$soil_top_mukey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_cokey3[i] <- soil_EUROSEM_data$soil_top_cokey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_chkey3[i] <- soil_EUROSEM_data$soil_top_chkey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_EUROSEM_data$soil_top_cokey_perc2 == biggest_perc2]
		}
	} else {
		soil_top_mukey3[i] <- soil_EUROSEM_data$soil_top_mukey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_cokey3[i] <- soil_EUROSEM_data$soil_top_cokey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_chkey3[i] <- soil_EUROSEM_data$soil_top_chkey2[soil_EUROSEM_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
	}
}

soil_EUROSEM_data3 <- data.frame(soil_top_mukey3, soil_top_cokey3, soil_top_chkey3)

################################################
################################################

# identify texture key with chtg_key
soil_chtexture_line_data <- readLines(soil_chtexture_file_name)
#soil_chtexture_line_data <- readLines("chtextur.txt")
soil_chtexture_line_length <- length(soil_chtexture_line_data)

soil_chtexture_mukey <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_chtgkey <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_texture <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_detachability <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_cohesion <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)

for (i in 1:soil_chtexture_line_length) {
	soil_chtexture_line_split <- strsplit(soil_chtexture_line_data[i],"|", fixed=TRUE)
#	soil_chtexture_line_split <- strsplit(soil_chtexture_line_data[i],"|", extended=FALSE)
	soil_chtexture_line_split_unlist <- unlist(soil_chtexture_line_split)
	soil_chtexture_line_split_unlist_length <- length(soil_chtexture_line_split_unlist)
	soil_chtexture_temp1 <- soil_chtexture_line_split_unlist[soil_chtexture_line_split_unlist_length-1]
	soil_chtexture_temp2 <- unlist(strsplit(soil_chtexture_temp1,"\""))[2]
	soil_chtexture_temp3 <- unlist(strsplit(soil_chtexture_temp2,":"))[1]
	soil_chtexture_mukey[i] <- as.numeric(soil_chtexture_temp3)
	soil_chtexture_temp4 <- unlist(strsplit(soil_chtexture_temp2,":"))[2]
	soil_chtexture_chtgkey[i] <- as.numeric(soil_chtexture_temp4)
	soil_chtexture_temp5 <- soil_chtexture_line_split_unlist[1]
	soil_chtexture_texture[i] <- unlist(strsplit(soil_chtexture_temp5,"\""))[2]
}

soil_chtexture_gtexture <- soil_chtexture_texture
soil_data_chtexture <- data.frame(soil_chtexture_mukey, soil_chtexture_chtgkey, soil_chtexture_texture, soil_chtexture_gtexture, soil_chtexture_detachability, soil_chtexture_cohesion)

chtexture_list <- unique(soil_chtexture_texture)
chtexture_list <- chtexture_list[!is.na(chtexture_list)]
chtexture_list_length <- length(chtexture_list)

detail_texture_list <- c("Coarse sand", "Fine sand", "Very fine sand", "Loamy coarse sand", "Loamy fine sand", "Loamy very fine sand", "Coarse sandy loam", "Fine sandy loam", "Very fine sandy loam")
general_texture_list <- c("Sand", "Sand", "Sand", "Loamy sand", "Loamy sand", "Loamy sand", "Sandy loam", "Sandy loam", "Sandy loam")
texture_list <- data.frame(detail_texture_list, general_texture_list)
texture_list_length <- length(general_texture_list)

for (i in 1:texture_list_length) {
	soil_data_chtexture$soil_chtexture_gtexture[soil_data_chtexture$soil_chtexture_texture == detail_texture_list[i]] <- general_texture_list[i]
}

# identify soil detachability and cohesion for texture key
#soil_property_data <- read.csv(soil_property_file_name)
soil_property_data <- read.csv("EUROSEM_soil_texture_properties.csv")
soil_texture_list <- as.character(soil_property_data$Texture)
soil_texture_list <- soil_texture_list[!is.na(soil_texture_list)]
soil_texture_list_length <- length(soil_property_data$Texture)
soil_detachability_list <- soil_property_data$SOILDETACH
soil_cohesion_list <- soil_property_data$SOILCOHESION

for (i in 1:soil_texture_list_length) {
	soil_data_chtexture$soil_chtexture_detachability[soil_data_chtexture$soil_chtexture_gtexture == soil_texture_list[i]] <- soil_detachability_list[i]
	soil_data_chtexture$soil_chtexture_cohesion[soil_data_chtexture$soil_chtexture_gtexture == soil_texture_list[i]] <- soil_cohesion_list[i]
}

soil_data_chtexture$soil_chtexture_detachability <- as.numeric(soil_data_chtexture$soil_chtexture_detachability)
soil_data_chtexture$soil_chtexture_cohesion <- as.numeric(soil_data_chtexture$soil_chtexture_cohesion)

#######
#######

# identify group texture key (chtg_key)
soil_chtextgrp_line_data <- readLines(soil_chtextgrp_file_name)
#soil_chtextgrp_line_data <- readLines("chtexgrp.txt")
soil_chtextgrp_line_length <- length(soil_chtextgrp_line_data)

soil_chtextgrp_mukey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_chkey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_chtgkey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_detachability <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_cohesion <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)

for (i in 1:soil_chtextgrp_line_length) {
	soil_chtextgrp_line_split <- strsplit(soil_chtextgrp_line_data[i],"|", fixed=TRUE)
#	soil_chtextgrp_line_split <- strsplit(soil_chtextgrp_line_data[i],"|", extended=FALSE)
	soil_chtextgrp_line_split_unlist <- unlist(soil_chtextgrp_line_split)
	soil_chtextgrp_line_split_unlist_length <- length(soil_chtextgrp_line_split_unlist)
	soil_chtextgrp_temp1 <- soil_chtextgrp_line_split_unlist[soil_chtextgrp_line_split_unlist_length]
	soil_chtextgrp_temp2 <- unlist(strsplit(soil_chtextgrp_temp1,"\""))[2]
	soil_chtextgrp_temp3 <- unlist(strsplit(soil_chtextgrp_temp2,":"))[1]
	soil_chtextgrp_mukey[i] <- as.numeric(soil_chtextgrp_temp3)
	soil_chtextgrp_temp4 <- unlist(strsplit(soil_chtextgrp_temp2,":"))[2]
	soil_chtextgrp_chtgkey[i] <- as.numeric(soil_chtextgrp_temp4)
	soil_chtextgrp_temp5 <- soil_chtextgrp_line_split_unlist[soil_chtextgrp_line_split_unlist_length-1]
	soil_chtextgrp_temp6 <- unlist(strsplit(soil_chtextgrp_temp5,"\""))[2]
	soil_chtextgrp_temp7 <- unlist(strsplit(soil_chtextgrp_temp6,":"))[2]
	soil_chtextgrp_chkey[i] <- as.numeric(soil_chtextgrp_temp7)
}

soil_data_chtextgrp <- data.frame(soil_chtextgrp_mukey, soil_chtextgrp_chkey, soil_chtextgrp_chtgkey, soil_chtextgrp_detachability, soil_chtextgrp_cohesion)

soil_chtextgrp_chtgkey_list <- unique(soil_chtextgrp_chtgkey)
soil_chtextgrp_chtgkey_list_length <- length(soil_chtextgrp_chtgkey_list)

for (i in 1:soil_chtextgrp_chtgkey_list_length) {
	if (length(soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]]) == length(soil_data_chtexture$soil_chtexture_detachability[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]])) {
		soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_detachability[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]]
		soil_data_chtextgrp$soil_chtextgrp_cohesion[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_cohesion[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]]
	} else {
		soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_detachability[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]][1]
		soil_data_chtextgrp$soil_chtextgrp_cohesion[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_cohesion[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]][1]
	}
}

soil_chkey_list <- unique(soil_EUROSEM_data3$soil_top_chkey3)
soil_chkey_list_length <- length(soil_chkey_list)

soil_EUROSEM3_detachability <- matrix(data <- NA, nrow <- soil_chkey_list_length, ncol <- 1)
soil_EUROSEM3_cohesion <- matrix(data <- NA, nrow <- soil_chkey_list_length, ncol <- 1)

for (i in 1:soil_chkey_list_length) {
	if (length(soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]]) > 1) {
		biggest_detachability <- max(soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]],na.rm=T)
		biggest_cohesion <- max(soil_data_chtextgrp$soil_chtextgrp_cohesion[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]],na.rm=T)
		soil_EUROSEM3_detachability[i] <- biggest_detachability
		soil_EUROSEM3_cohesion[i] <- biggest_cohesion
#		soil_EUROSEM3_detachability[i] <- soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]][1]
	} else {
		soil_EUROSEM3_detachability[i] <- soil_data_chtextgrp$soil_chtextgrp_detachability[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]]
		soil_EUROSEM3_cohesion[i] <- soil_data_chtextgrp$soil_chtextgrp_cohesion[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]]
	}
}

soil_EUROSEM3_detachability_ave <- mean(soil_EUROSEM3_detachability,na.rm=T)
soil_EUROSEM3_cohesion_ave <- mean(soil_EUROSEM3_cohesion,na.rm=T)

soil_EUROSEM3_detachability[is.na(soil_EUROSEM3_detachability)] <- soil_EUROSEM3_detachability_ave
soil_EUROSEM3_cohesion[is.na(soil_EUROSEM3_detachability)] <- soil_EUROSEM3_cohesion_ave

soil_EUROSEM_detachability_final <- data.frame(soil_EUROSEM_data3, soil_EUROSEM3_detachability)
soil_EUROSEM_cohesion_final <- data.frame(soil_EUROSEM_data3, soil_EUROSEM3_cohesion)

#############################################################################################################################################

soil_detachability_mat <- matrix(data <- NA, nrow <- nrow(soil_mat), ncol <- ncol(soil_mat))
soil_cohesion_mat <- matrix(data <- NA, nrow <- nrow(soil_mat), ncol <- ncol(soil_mat))

soil_mat_list <- unique(c(soil_mat))
soil_mat_list_length <- length(soil_mat_list)

for (i in 2:soil_mat_list_length) {
	if (length(soil_EUROSEM_detachability_final$soil_EUROSEM3_detachability[soil_EUROSEM_detachability_final$soil_top_mukey3 == soil_mat_list[i]]) > 0) {
		soil_detachability_mat[soil_mat == soil_mat_list[i]] <- soil_EUROSEM_detachability_final$soil_EUROSEM3_detachability[soil_EUROSEM_detachability_final$soil_top_mukey3 == soil_mat_list[i]]
		soil_cohesion_mat[soil_mat == soil_mat_list[i]] <- soil_EUROSEM_cohesion_final$soil_EUROSEM3_cohesion[soil_EUROSEM_cohesion_final$soil_top_mukey3 == soil_mat_list[i]]
	} else {
		### in the case of ROCK ###
		soil_detachability_mat[soil_mat == soil_mat_list[i]] <- 0	
		soil_cohesion_mat[soil_mat == soil_mat_list[i]] <- 0
	}
}

#soil_detachability_mat[soil_detachability_mat == 0] <- mean(soil_detachability_mat[soil_detachability_mat > 0],na.rm=TRUE)

soil_EUROSEM_return_list <- list(soil_detachability_mat, soil_cohesion_mat)

return(soil_EUROSEM_return_list)

}
