# soil available water, field capacity, and wilting point
# 3 ways to get HSG from soil map
# 1. directly from a source map
# 2. from soil texture
# 3. from soil texture estimated by composition of sand, silt, and clay
# This code is for the way of 1.

### define a function ###
soil_awc_calculating <- function(soil_comp_file_name, soil_chorizon_file_name, soil_mat) {

### identify percentages of components in a soil map ###
soil_comp_line_data <- readLines(soil_comp_file_name)
#soil_comp_line_data <- readLines("comp.txt")
soil_comp_line_length <- length(soil_comp_line_data)
soil_comp_perc <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_mukey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_cokey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)

for (i in 1:soil_comp_line_length) {
	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", fixed=TRUE) # for the new version of R 2.10.x
#	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", extended=FALSE) # for the old version of R 2.9.x
	soil_comp_line_split_unlist <- unlist(soil_comp_line_split)
	soil_comp_line_split_unlist_length <- length(soil_comp_line_split_unlist)
	soil_comp_perc[i] <- as.numeric(soil_comp_line_split_unlist[2])
	soil_mukey_temp4 <- soil_comp_line_split_unlist[soil_comp_line_split_unlist_length]
	soil_mukey_temp5 <- unlist(strsplit(soil_mukey_temp4,"\""))[2]
	soil_mukey_temp6 <- unlist(strsplit(soil_mukey_temp5,":"))[1]
	soil_comp_mukey[i] <- as.numeric(soil_mukey_temp6)
	soil_cokey_temp4 <- unlist(strsplit(soil_mukey_temp5,":"))[2]
	soil_comp_cokey[i] <- as.numeric(soil_cokey_temp4)
}

soil_comp_perc_mod <- soil_comp_perc
soil_data_comp <- data.frame(soil_comp_perc, soil_comp_perc_mod, soil_comp_mukey, soil_comp_cokey)

soil_mukey_list <- unique(soil_comp_mukey)
soil_mukey_list_length <- length(soil_mukey_list)

for (i in 1:soil_mukey_list_length) {
	soil_comp_perc_sum <- sum(soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]], na.rm=TRUE)
	soil_comp_perc_list <- soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]]/soil_comp_perc_sum*100
	soil_data_comp$soil_comp_perc_mod[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]] <- soil_comp_perc_list
}

### identify soil map unit with MUKEY, soil components with COKEY, and soil horizon with CHKEY ###
soil_chorizon_line_data <- readLines(soil_chorizon_file_name)
#soil_chorizon_line_data <- readLines("chorizon.txt")
soil_chorizon_line_length <- length(soil_chorizon_line_data)
soil_awc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_fc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_wp <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_ks <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_mukey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_cokey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chkey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_depth <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

for (i in 1:soil_chorizon_line_length) {
	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", fixed=TRUE)
#	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", extended=FALSE)
	soil_chorizon_line_split_unlist <- unlist(soil_chorizon_line_split)
	soil_awc[i] <- as.numeric(soil_chorizon_line_split_unlist[86])
	soil_fc[i] <- as.numeric(soil_chorizon_line_split_unlist[92])
	soil_wp[i] <- as.numeric(soil_chorizon_line_split_unlist[95])
	soil_ks[i] <- as.numeric(soil_chorizon_line_split_unlist[83])
	soil_chorizon_line_split_unlist_length <- length(soil_chorizon_line_split_unlist)
	soil_mukey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length]
	soil_mukey_temp2 <- unlist(strsplit(soil_mukey_temp1,"\""))[2]
	soil_mukey_temp3 <- unlist(strsplit(soil_mukey_temp2,":"))[1]
	soil_chkey_temp1 <- unlist(strsplit(soil_mukey_temp2,":"))[2]
	soil_mukey[i] <- as.numeric(soil_mukey_temp3)
	soil_chkey[i] <- as.numeric(soil_chkey_temp1)
	soil_cokey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length-1]
	soil_cokey_temp2 <- unlist(strsplit(soil_cokey_temp1,"\""))[2]
	soil_cokey_temp3 <- unlist(strsplit(soil_cokey_temp2,":"))[2]
	soil_cokey[i] <- as.numeric(soil_cokey_temp3)
	soil_top_depth <- as.numeric(soil_chorizon_line_split_unlist[7])
	soil_bottom_depth <- as.numeric(soil_chorizon_line_split_unlist[10])
	soil_depth[i] <- soil_bottom_depth - soil_top_depth
}

soil_chorizon_perc <- NA
soil_comp_perc_mod2 <- NA
soil_chorizon_percf <- NA
soil_chorizon_percf_sum <- NA
soil_fc_frac <- NA
soil_wp_frac <- NA
soil_ks_frac <- NA
soil_data_chorizon <- data.frame(soil_awc, soil_fc, soil_wp, soil_ks, soil_mukey, soil_cokey, soil_chkey, soil_depth, soil_chorizon_perc, soil_comp_perc_mod2, soil_chorizon_percf, soil_fc_frac, soil_wp_frac, soil_ks_frac)

soil_cokey_list <- unique(soil_comp_cokey)
soil_cokey_list_length <- length(soil_cokey_list)

for (i in 1:soil_cokey_list_length) {
	soil_chorizon_perc_sum <- sum(soil_data_chorizon$soil_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]], na.rm=TRUE)
	soil_chorizon_perc_list <- soil_data_chorizon$soil_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]]/soil_chorizon_perc_sum*100
	soil_data_chorizon$soil_chorizon_perc[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_chorizon_perc_list
	soil_data_chorizon$soil_comp_perc_mod2[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_data_comp$soil_comp_perc_mod[soil_data_comp$soil_comp_cokey == soil_cokey_list[i]]
	soil_data_chorizon$soil_chorizon_percf <- soil_data_chorizon$soil_chorizon_perc * soil_data_chorizon$soil_comp_perc_mod2 / 10000
}

soil_data_chorizon$soil_chorizon_percf[is.na(soil_data_chorizon$soil_fc)] <- 0
soil_data_chorizon$soil_chorizon_percf[is.na(soil_data_chorizon$soil_wp)] <- 0
soil_data_chorizon$soil_chorizon_percf[is.na(soil_data_chorizon$soil_ks)] <- 0

for (i in 1:soil_cokey_list_length) {
	soil_chorizon_percf_sum_temp <- sum(soil_data_chorizon$soil_chorizon_percf[soil_data_chorizon$soil_cokey == soil_cokey_list[i]])
	if (soil_chorizon_percf_sum_temp == 0) {
		next
	} else {
		if (soil_chorizon_percf_sum_temp != soil_data_chorizon$soil_comp_perc_mod2[soil_data_chorizon$soil_cokey == soil_cokey_list[i]][1]/100) {
			soil_chorizon_percf_list <- soil_data_chorizon$soil_chorizon_percf[soil_data_chorizon$soil_cokey == soil_cokey_list[i]]/soil_chorizon_percf_sum_temp*soil_data_chorizon$soil_comp_perc_mod2[soil_data_chorizon$soil_cokey == soil_cokey_list[i]][1]/100
			soil_data_chorizon$soil_chorizon_percf[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_chorizon_percf_list
		}
	}
}

soil_data_chorizon$soil_fc_frac <- soil_data_chorizon$soil_fc * soil_data_chorizon$soil_chorizon_percf
soil_data_chorizon$soil_wp_frac <- soil_data_chorizon$soil_wp * soil_data_chorizon$soil_chorizon_percf
soil_data_chorizon$soil_ks_frac <- soil_data_chorizon$soil_ks * soil_data_chorizon$soil_chorizon_percf

soil_chorizon_fc_ave <- matrix(data <- NA, nrow <- soil_mukey_list_length, ncol <- 1)
soil_chorizon_wp_ave <- matrix(data <- NA, nrow <- soil_mukey_list_length, ncol <- 1)
soil_chorizon_ks_ave <- matrix(data <- NA, nrow <- soil_mukey_list_length, ncol <- 1)

for (i in 1:soil_mukey_list_length) {
	soil_chorizon_fc_ave[i] <- sum(soil_data_chorizon$soil_fc_frac[soil_data_chorizon$soil_mukey == soil_mukey_list[i]], na.rm=TRUE)
	soil_chorizon_wp_ave[i] <- sum(soil_data_chorizon$soil_wp_frac[soil_data_chorizon$soil_mukey == soil_mukey_list[i]], na.rm=TRUE)
	soil_chorizon_ks_ave[i] <- sum(soil_data_chorizon$soil_ks_frac[soil_data_chorizon$soil_mukey == soil_mukey_list[i]], na.rm=TRUE)
}

soil_data_awc <- data.frame(soil_mukey_list, soil_chorizon_fc_ave, soil_chorizon_wp_ave, soil_chorizon_ks_ave)

soil_fc_mat <- matrix(data <- NA, nrow <- nrow(soil_mat), ncol <- ncol(soil_mat))
soil_wp_mat <- matrix(data <- NA, nrow <- nrow(soil_mat), ncol <- ncol(soil_mat))
soil_ks_mat <- matrix(data <- NA, nrow <- nrow(soil_mat), ncol <- ncol(soil_mat))

soil_mat_list <- unique(c(soil_mat))
soil_mat_list_length <- length(soil_mat_list)

for (i in 2:soil_mat_list_length) {
	soil_fc_mat[soil_mat == soil_mat_list[i]] <- soil_data_awc$soil_chorizon_fc_ave[soil_data_awc$soil_mukey_list == soil_mat_list[i]]
	soil_wp_mat[soil_mat == soil_mat_list[i]] <- soil_data_awc$soil_chorizon_wp_ave[soil_data_awc$soil_mukey_list == soil_mat_list[i]]
	soil_ks_mat[soil_mat == soil_mat_list[i]] <- soil_data_awc$soil_chorizon_ks_ave[soil_data_awc$soil_mukey_list == soil_mat_list[i]]
}

soil_fc_mat[soil_fc_mat == 0] <- mean(soil_fc_mat[soil_fc_mat > 0],na.rm=TRUE)
soil_wp_mat[soil_wp_mat == 0] <- mean(soil_wp_mat[soil_wp_mat > 0],na.rm=TRUE)
soil_ks_mat[soil_ks_mat == 0] <- mean(soil_ks_mat[soil_wp_mat > 0],na.rm=TRUE)

soil_data_awc_return_list <- list(soil_fc_mat,soil_wp_mat,soil_ks_mat)

return(soil_data_awc_return_list)

}

