
soil_char_particlesize_loading <- function (fsand_pc, vfsand_pc, silt_pc, clay_pc) {

### fraction of soil particle type for every cell should be loaded from SSURGO ###
clay <- clay_pc/100
silt <- silt_pc/100
fvfsand <- (fsand_pc+vfsand_pc)/100

### upper limits of the soil paricles are fixed ###
ul_clay <- 1
ul_silt <- 25
ul_fvfsand <- 125
#ul_fvfsand <- 999

psd_v <- log((1/(clay+silt)-1)/(1/clay-1))
psd_w <- log((1/(clay+silt+fvfsand)-1)/(1/clay-1))
psd_alpha <- 1/log((ul_silt-ul_clay)/(ul_fvfsand-ul_clay))
psd_beta <- psd_alpha*log((ul_silt-ul_clay)/ul_clay)
psd_u <- ((-psd_v)^(1-psd_beta))/((-psd_w)^(-psd_beta))
psd_c <- psd_alpha*log(psd_v/psd_w)

### for D30, D40, D50, and D90 ###
psd_D_list <- c(0.3, 0.4, 0.5, 0.9)

#psdist <- matrix(data <- NA, nrow <- 1000, ncol <- 2)
psdist <- {}

for (psd_R in 1:1000) {
#	psdist[psd_R,1] <- 1/(1+(1/clay-1)*exp((-psd_u)*(psd_R-1)^psd_c))
#	psdist[psd_R,2] <- psd_R
	psdist[psd_R] <- 1/(1+(1/clay-1)*exp((-psd_u)*(psd_R-1)^psd_c))
}

#findInterval(c(0.3, 0.4, 0.5, 0.9),psdist[,1])
char_Ds <- findInterval(c(0.3, 0.4, 0.5, 0.9),psdist)
char_Ds_candidates <- sort(append(char_Ds,char_Ds+1))
char_Ds_candidates[char_Ds_candidates > 1000] <- 1000

for (i in 1:4) {
	if (abs(psdist[char_Ds_candidates[2*(i-1)+1]]-psd_D_list[i]) >= abs(psdist[char_Ds_candidates[2*(i-1)+2]]-psd_D_list[i])) {
		char_Ds[i] <- char_Ds_candidates[2*(i-1)+2]
	} else {
		char_Ds[i] <- char_Ds_candidates[2*(i-1)+1]
	}
}

### units of the characteristic particle sizes is micro meter, 10^-6 m ###
D30 <- char_Ds[1]
D40 <- char_Ds[2]
D50 <- char_Ds[3]
D90 <- char_Ds[4]

return_list <- list(D30, D40, D50, D90)
return(return_list)

}