# soil depth
# 1 way to get porosity from soil map
# 1. directly from a source map
# This code is for the way of 1.

### define a function ###
soil_depth_loading <- function(soil_comp_file_name, soil_chorizon_file_name, soil_data_mat) {

### identify percentages of components in a soil map ###
soil_comp_line_data <- readLines(soil_comp_file_name)
#soil_comp_line_data <- readLines("comp.txt")
soil_comp_line_length <- length(soil_comp_line_data)
soil_comp_perc <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_mukey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_cokey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_bottom_depth_max <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_bottom_depth_frac <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)

for (i in 1:soil_comp_line_length) {
	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", fixed=TRUE)
#	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", extended=FALSE)
	soil_comp_line_split_unlist <- unlist(soil_comp_line_split)
	soil_comp_line_split_unlist_length <- length(soil_comp_line_split_unlist)
	soil_comp_perc[i] <- as.numeric(soil_comp_line_split_unlist[2])
	soil_mukey_temp4 <- soil_comp_line_split_unlist[soil_comp_line_split_unlist_length]
	soil_mukey_temp5 <- unlist(strsplit(soil_mukey_temp4,"\""))[2]
	soil_mukey_temp6 <- unlist(strsplit(soil_mukey_temp5,":"))[1]
	soil_comp_mukey[i] <- as.numeric(soil_mukey_temp6)
	soil_cokey_temp4 <- unlist(strsplit(soil_mukey_temp5,":"))[2]
	soil_comp_cokey[i] <- as.numeric(soil_cokey_temp4)
}

soil_comp_perc_mod <- soil_comp_perc
soil_data_comp <- data.frame(soil_comp_perc, soil_comp_perc_mod, soil_comp_mukey, soil_comp_cokey, soil_comp_bottom_depth_max, soil_comp_bottom_depth_frac)

soil_mukey_list <- unique(soil_comp_mukey)
soil_mukey_list_length <- length(soil_mukey_list)

for (i in 1:soil_mukey_list_length) {
	soil_comp_perc_sum <- sum(soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]], na.rm=TRUE)
	soil_comp_perc_list <- soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]]/soil_comp_perc_sum*100
	soil_data_comp$soil_comp_perc_mod[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]] <- soil_comp_perc_list
}

### identify soil map unit with MUKEY, soil components with COKEY, and soil horizon with CHKEY ###
soil_chorizon_line_data <- readLines(soil_chorizon_file_name)
#soil_chorizon_line_data <- readLines("chorizon.txt")
soil_chorizon_line_length <- length(soil_chorizon_line_data)
soil_awc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_fc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_wp <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_mukey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_cokey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chkey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_bottom_depth <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

for (i in 1:soil_chorizon_line_length) {
	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", fixed=TRUE)
#	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", extended=FALSE)
	soil_chorizon_line_split_unlist <- unlist(soil_chorizon_line_split)
	soil_chorizon_line_split_unlist_length <- length(soil_chorizon_line_split_unlist)
	soil_mukey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length]
	soil_mukey_temp2 <- unlist(strsplit(soil_mukey_temp1,"\""))[2]
	soil_mukey_temp3 <- unlist(strsplit(soil_mukey_temp2,":"))[1]
	soil_chkey_temp1 <- unlist(strsplit(soil_mukey_temp2,":"))[2]
	soil_mukey[i] <- as.numeric(soil_mukey_temp3)
	soil_chkey[i] <- as.numeric(soil_chkey_temp1)
	soil_cokey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length-1]
	soil_cokey_temp2 <- unlist(strsplit(soil_cokey_temp1,"\""))[2]
	soil_cokey_temp3 <- unlist(strsplit(soil_cokey_temp2,":"))[2]
	soil_cokey[i] <- as.numeric(soil_cokey_temp3)
	soil_bottom_depth[i] <- as.numeric(soil_chorizon_line_split_unlist[10])
}

soil_data_chorizon <- data.frame(soil_mukey, soil_cokey, soil_chkey, soil_bottom_depth)

soil_cokey_list <- unique(soil_comp_cokey)
soil_cokey_list_length <- length(soil_cokey_list)

for (i in 1:soil_cokey_list_length) {
	if (length(soil_data_chorizon$soil_bottom_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]])>0) {
		soil_data_comp$soil_comp_bottom_depth_max[i] <- max(soil_data_chorizon$soil_bottom_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]])
	}
}

soil_data_comp$soil_comp_bottom_depth_frac <- soil_data_comp$soil_comp_perc_mod * soil_data_comp$soil_comp_bottom_depth_max/100
soil_depth_ave <- matrix(data <- NA, nrow <- soil_mukey_list_length, ncol <- 1)

for (i in 1:soil_mukey_list_length) {
	soil_depth_ave[i] <- sum(soil_data_comp$soil_comp_bottom_depth_frac[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]], na.rm=TRUE)
}

soil_data_depth <- data.frame(soil_mukey_list, soil_depth_ave)

soil_depth_mat <- matrix(data <- NA, nrow <- nrow(soil_data_mat), ncol <- ncol(soil_data_mat))

soil_data_mat_list <- unique(c(soil_data_mat))
soil_data_mat_list_length <- length(soil_data_mat_list)

for (i in 2:soil_data_mat_list_length) {
	soil_depth_mat[soil_data_mat == soil_data_mat_list[i]] <- soil_data_depth$soil_depth_ave[soil_data_depth$soil_mukey_list == soil_data_mat_list[i]]
}

soil_depth_mat[soil_depth_mat == 0] <- mean(soil_depth_mat[soil_depth_mat > 0],na.rm=TRUE)

return(soil_depth_mat)

}
