# hydrologic soil group (HSG)
# 3 ways to get HSG from soil map
# 1. directly from a source map
# 2. from soil texture
# 3. from soil texture estimated by composition of sand, silt, and clay
# This code is for the way of 1.

# define a function
soil_hsg_calculating <- function(soil_file_name, soil_muaggatt_file_name) {

# Identify soil map unit with MUKEY
soil_muaggatt_line_data <- readLines(soil_muaggatt_file_name)
#soil_muaggatt_line_data <- readLines("muaggatt.txt")
soil_muaggatt_line_length <- length(soil_muaggatt_line_data)
soil_munit <- matrix(data <- NA, nrow <- soil_muaggatt_line_length, ncol <- 1)
soil_hsg <- matrix(data <- NA, nrow <- soil_muaggatt_line_length, ncol <- 1)
soil_mukey <- matrix(data <- NA, nrow <- soil_muaggatt_line_length, ncol <- 1)

for (i in 1:soil_muaggatt_line_length) {
	soil_muaggatt_line_split <- strsplit(soil_muaggatt_line_data[i],"\"")
	soil_muaggatt_line_split_unlist <- unlist(soil_muaggatt_line_split)
	soil_munit[i] <- soil_muaggatt_line_split_unlist[2]
	soil_hsg[i] <- soil_muaggatt_line_split_unlist[16]
	soil_muaggatt_line_split_unlist_length <- length(soil_muaggatt_line_split_unlist)
	soil_mukey[i] <- as.numeric(soil_muaggatt_line_split_unlist[soil_muaggatt_line_split_unlist_length])
}

soil_data <- data.frame(soil_munit, soil_hsg, soil_mukey)

# Load soil map from a text file
soil_line_data <- readLines(soil_file_name)
#soil_line_data <- readLines("owlrun_soil.txt")
soil_line_split <- strsplit(soil_line_data, " +")
soil_line_ncols <- unlist(soil_line_split[1])
soil_map_ncols <- as.numeric(soil_line_ncols[2])
soil_line_nrows <- unlist(soil_line_split[2])
soil_map_nrows <- as.numeric(soil_line_nrows[2])
soil_line_cellsize <- unlist(soil_line_split[5])
soil_map_cellsize <- as.numeric(soil_line_cellsize[2])
soil_line_nodata <- unlist(soil_line_split[6])
soil_map_nodata <- as.numeric(soil_line_nodata[2])
soil_line_length <- length(soil_line_split)

soil_data_mat <- matrix(data <- NA, nrow <- soil_map_nrows, ncol <- soil_map_ncols)
soil_hsg_mat <- matrix(data <- NA, nrow <- soil_map_nrows, ncol <- soil_map_ncols)

for (i in 1:soil_map_nrows) {
	soil_data_mat[i,] <- as.numeric(unlist(soil_line_split[i+6]))
}

soil_hsg_mat <- matrix(data <- NA, nrow <- nrow(soil_data_mat), ncol <- ncol(soil_data_mat))

soil_data_mat_list <- unique(c(soil_data_mat))
soil_data_mat_list_length <- length(soil_data_mat_list)

for (i in 2:soil_data_mat_list_length) {
	if (nchar(as.character(soil_data$soil_hsg[soil_data$soil_mukey == soil_data_mat_list[i]])) > 1) {
		soil_hsg_mat[soil_data_mat == soil_data_mat_list[i]] <- "D"
	} else {
		soil_hsg_mat[soil_data_mat == soil_data_mat_list[i]] <- as.character(soil_data$soil_hsg[soil_data$soil_mukey == soil_data_mat_list[i]])
	}
}

#for (i in 1:soil_map_nrows) {
#	for (j in 1:soil_map_ncols) {
#		if (soil_data_mat[i,j] != soil_map_nodata) {
#			soil_hsg_mat[i,j] <- soil_hsg[soil_mukey == soil_data_mat[i,j]]
#			if (nchar(soil_hsg_mat[i,j]) > 1) {
#				soil_hsg_mat[i,j] <- "D"
#			}
#		}
#	}
#}

soil_return <- list(soil_hsg_mat, soil_map_nrows, soil_map_ncols, soil_map_nodata, soil_map_cellsize)
return(soil_return)

}



