
soil_particlesize_loading <- function(soil_comp_file_name, soil_chorizon_file_name, soil_mat, cn_mat_nrow, cn_mat_ncol) {

# Identify percentages of components in a soil map
soil_comp_line_data <- readLines(soil_comp_file_name)
#soil_comp_line_data <- readLines("comp.txt")
soil_comp_line_length <- length(soil_comp_line_data)
soil_comp_perc <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_mukey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_cokey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)

for (i in 1:soil_comp_line_length) {
	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", fixed=TRUE)
#	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", extended=FALSE)
	soil_comp_line_split_unlist <- unlist(soil_comp_line_split)
	soil_comp_line_split_unlist_length <- length(soil_comp_line_split_unlist)
	soil_comp_perc[i] <- as.numeric(soil_comp_line_split_unlist[2])
	soil_mukey_temp4 <- soil_comp_line_split_unlist[soil_comp_line_split_unlist_length]
	soil_mukey_temp5 <- unlist(strsplit(soil_mukey_temp4,"\""))[2]
	soil_mukey_temp6 <- unlist(strsplit(soil_mukey_temp5,":"))[1]
	soil_comp_mukey[i] <- as.numeric(soil_mukey_temp6)
	soil_cokey_temp4 <- unlist(strsplit(soil_mukey_temp5,":"))[2]
	soil_comp_cokey[i] <- as.numeric(soil_cokey_temp4)
}

soil_data_comp <- data.frame(soil_comp_mukey, soil_comp_cokey, soil_comp_perc)

soil_mukey_list <- unique(soil_comp_mukey)
soil_mukey_list_length <- length(soil_mukey_list)

# Identify soil map unit with MUKEY, soil components with COKEY, and soil horizon with CHKEY
soil_chorizon_line_data <- readLines(soil_chorizon_file_name)
#soil_chorizon_line_data <- readLines("chorizon.txt")
soil_chorizon_line_length <- length(soil_chorizon_line_data)
soil_mukey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_cokey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chkey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_depth <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_fine_sand <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_veryfine_sand <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_silt <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_clay <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

for (i in 1:soil_chorizon_line_length) {
#	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", extended=FALSE)
	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", fixed=TRUE)
	soil_chorizon_line_split_unlist <- unlist(soil_chorizon_line_split)
	soil_chorizon_line_split_unlist_length <- length(soil_chorizon_line_split_unlist)
	soil_mukey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length]
	soil_mukey_temp2 <- unlist(strsplit(soil_mukey_temp1,"\""))[2]
	soil_mukey_temp3 <- unlist(strsplit(soil_mukey_temp2,":"))[1]
	soil_chkey_temp1 <- unlist(strsplit(soil_mukey_temp2,":"))[2]
	soil_mukey[i] <- as.numeric(soil_mukey_temp3)
	soil_chkey[i] <- as.numeric(soil_chkey_temp1)
	soil_cokey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length-1]
	soil_cokey_temp2 <- unlist(strsplit(soil_cokey_temp1,"\""))[2]
	soil_cokey_temp3 <- unlist(strsplit(soil_cokey_temp2,":"))[2]
	soil_cokey[i] <- as.numeric(soil_cokey_temp3)
	soil_top_depth[i] <- as.numeric(soil_chorizon_line_split_unlist[7])
	soil_top_fine_sand[i] <- as.numeric(soil_chorizon_line_split_unlist[46])
	soil_top_veryfine_sand[i] <- as.numeric(soil_chorizon_line_split_unlist[49])
	soil_top_silt[i] <- as.numeric(soil_chorizon_line_split_unlist[52])
	soil_top_clay[i] <- as.numeric(soil_chorizon_line_split_unlist[61])
}

soil_chorizon_perc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

soil_data_chorizon <- data.frame(soil_mukey, soil_cokey, soil_chorizon_perc, soil_chkey, soil_top_depth, soil_top_fine_sand, soil_top_veryfine_sand, soil_top_silt, soil_top_clay)

soil_cokey_list <- unique(soil_data_chorizon$soil_cokey)
soil_cokey_list_length <- length(soil_cokey_list)

for (i in 1:soil_cokey_list_length) {
	soil_data_chorizon$soil_chorizon_perc[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_cokey == soil_cokey_list[i]]
}

soil_data_chorizon_top_chkey <- soil_data_chorizon$soil_chkey[soil_data_chorizon$soil_top_depth == 0]

soil_data_chorizon_top_chkey_length <- length(soil_data_chorizon_top_chkey)

soil_top_mukey2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_cokey2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_cokey_perc2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_chkey2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_fine_sand2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_veryfine_sand2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_silt2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)
soil_top_clay2 <- matrix(data <- NA, nrow <- soil_data_chorizon_top_chkey_length, ncol <- 1)

for (i in 1:soil_data_chorizon_top_chkey_length) {
	soil_top_mukey2[i] <- soil_data_chorizon$soil_mukey[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_cokey2[i] <- soil_data_chorizon$soil_cokey[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_cokey_perc2[i] <- soil_data_chorizon$soil_chorizon_perc[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_chkey2[i] <- soil_data_chorizon$soil_chkey[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_fine_sand2[i] <- soil_data_chorizon$soil_top_fine_sand[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_veryfine_sand2[i] <- soil_data_chorizon$soil_top_veryfine_sand[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_silt2[i] <- soil_data_chorizon$soil_top_silt[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
	soil_top_clay2[i] <- soil_data_chorizon$soil_top_clay[soil_data_chorizon$soil_chkey == soil_data_chorizon_top_chkey[i]]
}

soil_particlesize_data <- data.frame(soil_top_mukey2, soil_top_cokey2, soil_top_cokey_perc2, soil_top_chkey2, soil_top_fine_sand2, soil_top_veryfine_sand2, soil_top_silt2, soil_top_clay2)

soil_top_mukey2_list <- unique(soil_particlesize_data$soil_top_mukey2)
soil_top_mukey2_list_length <- length(soil_top_mukey2_list)

soil_top_mukey3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_cokey3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_chkey3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_fine_sand3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_veryfine_sand3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_silt3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)
soil_top_clay3 <- matrix(data <- NA, nrow <- soil_top_mukey2_list_length, ncol <- 1)

for (i in 1:soil_top_mukey2_list_length) {
	if (length(soil_particlesize_data$soil_top_mukey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]) > 1) {
		biggest_perc2 <- max(c(soil_particlesize_data$soil_top_cokey_perc2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]))
		if (length(soil_particlesize_data$soil_top_mukey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]) > 1) {
			soil_top_mukey3[i] <- soil_particlesize_data$soil_top_mukey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_cokey3[i] <- soil_particlesize_data$soil_top_cokey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_chkey3[i] <- soil_particlesize_data$soil_top_chkey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_fine_sand3[i] <- soil_particlesize_data$soil_top_fine_sand2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_veryfine_sand3[i] <- soil_particlesize_data$soil_top_veryfine_sand2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_silt3[i] <- soil_particlesize_data$soil_top_silt2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
			soil_top_clay3[i] <- soil_particlesize_data$soil_top_clay2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2][1]
		} else {
			soil_top_mukey3[i] <- soil_particlesize_data$soil_top_mukey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_cokey3[i] <- soil_particlesize_data$soil_top_cokey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_chkey3[i] <- soil_particlesize_data$soil_top_chkey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_fine_sand3[i] <- soil_particlesize_data$soil_top_fine_sand2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_veryfine_sand3[i] <- soil_particlesize_data$soil_top_veryfine_sand2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_silt3[i] <- soil_particlesize_data$soil_top_silt2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
			soil_top_clay3[i] <- soil_particlesize_data$soil_top_clay2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i] & soil_particlesize_data$soil_top_cokey_perc2 == biggest_perc2]
		}
	} else {
		soil_top_mukey3[i] <- soil_particlesize_data$soil_top_mukey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_cokey3[i] <- soil_particlesize_data$soil_top_cokey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_chkey3[i] <- soil_particlesize_data$soil_top_chkey2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_fine_sand3[i] <- soil_particlesize_data$soil_top_fine_sand2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_veryfine_sand3[i] <- soil_particlesize_data$soil_top_veryfine_sand2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_silt3[i] <- soil_particlesize_data$soil_top_silt2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
		soil_top_clay3[i] <- soil_particlesize_data$soil_top_clay2[soil_particlesize_data$soil_top_mukey2 == soil_top_mukey2_list[i]]
	}
}

soil_particlesize_data3 <- data.frame(soil_top_mukey3, soil_top_cokey3, soil_top_chkey3, soil_top_fine_sand3, soil_top_veryfine_sand3, soil_top_silt3, soil_top_clay3)

D30 <- {}
D40 <- {}
D50 <- {}
D90 <- {}

for (i in 1:length(soil_top_mukey3)) {
	soil_char_particlesize_return <- soil_char_particlesize_loading(soil_particlesize_data3$soil_top_fine_sand3[i], soil_particlesize_data3$soil_top_veryfine_sand3[i], soil_particlesize_data3$soil_top_silt3[i], soil_particlesize_data3$soil_top_clay3[i])
	D30[i] <- soil_char_particlesize_return[[1]]
	D40[i] <- soil_char_particlesize_return[[2]]
	D50[i] <- soil_char_particlesize_return[[3]]
	D90[i] <- soil_char_particlesize_return[[4]]
}

soil_char_particlesize_data <- data.frame(soil_top_mukey3, D30, D40, D50, D90)

soil_D30_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
soil_D40_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
soil_D50_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
soil_D90_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

soil_mat_list <- unique(c(soil_mat))
soil_mat_list_length <- length(soil_mat_list)

for (i in 2:soil_mat_list_length) {
	if (length(unique(soil_char_particlesize_data$soil_top_mukey3 == soil_mat_list[i])) == 1) {
		soil_D30_mat[soil_mat == soil_mat_list[i]] <- 1
		soil_D40_mat[soil_mat == soil_mat_list[i]] <- 1
		soil_D50_mat[soil_mat == soil_mat_list[i]] <- 1
		soil_D90_mat[soil_mat == soil_mat_list[i]] <- 1
	} else {
		soil_D30_mat[soil_mat == soil_mat_list[i]] <- soil_char_particlesize_data$D30[soil_char_particlesize_data$soil_top_mukey3 == soil_mat_list[i]]
		soil_D40_mat[soil_mat == soil_mat_list[i]] <- soil_char_particlesize_data$D40[soil_char_particlesize_data$soil_top_mukey3 == soil_mat_list[i]]
		soil_D50_mat[soil_mat == soil_mat_list[i]] <- soil_char_particlesize_data$D50[soil_char_particlesize_data$soil_top_mukey3 == soil_mat_list[i]]
		soil_D90_mat[soil_mat == soil_mat_list[i]] <- soil_char_particlesize_data$D90[soil_char_particlesize_data$soil_top_mukey3 == soil_mat_list[i]]
	}
}

return_list <- list(soil_D30_mat, soil_D40_mat, soil_D50_mat, soil_D90_mat)
return(return_list)


}

