# soil porosity
# 3 ways to get porosity from soil map
# 1. directly from a source map
# 2. from soil texture
# 3. from soil texture estimated by composition of sand, silt, and clay
# This code is for the way of 2.

# define a function
soil_por_calculating <- function(soil_comp_file_name, soil_chorizon_file_name, soil_chtextgrp_file_name, soil_chtexture_file_name, soil_data_mat) {

# Identify percentages of components in a soil map
soil_comp_line_data <- readLines(soil_comp_file_name)
#soil_comp_line_data <- readLines("comp.txt")
soil_comp_line_length <- length(soil_comp_line_data)
soil_comp_perc <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_mukey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_cokey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)

for (i in 1:soil_comp_line_length) {
	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", fixed=TRUE)
#	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", extended=FALSE)
	soil_comp_line_split_unlist <- unlist(soil_comp_line_split)
	soil_comp_line_split_unlist_length <- length(soil_comp_line_split_unlist)
	soil_comp_perc[i] <- as.numeric(soil_comp_line_split_unlist[2])
	soil_mukey_temp4 <- soil_comp_line_split_unlist[soil_comp_line_split_unlist_length]
	soil_mukey_temp5 <- unlist(strsplit(soil_mukey_temp4,"\""))[2]
	soil_mukey_temp6 <- unlist(strsplit(soil_mukey_temp5,":"))[1]
	soil_comp_mukey[i] <- as.numeric(soil_mukey_temp6)
	soil_cokey_temp4 <- unlist(strsplit(soil_mukey_temp5,":"))[2]
	soil_comp_cokey[i] <- as.numeric(soil_cokey_temp4)
}

soil_comp_perc_mod <- soil_comp_perc
soil_data_comp <- data.frame(soil_comp_perc, soil_comp_perc_mod, soil_comp_mukey, soil_comp_cokey)

soil_mukey_list <- unique(soil_comp_mukey)
soil_mukey_list_length <- length(soil_mukey_list)

for (i in 1:soil_mukey_list_length) {
	soil_comp_perc_sum <- sum(soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]], na.rm=TRUE)
	soil_comp_perc_list <- soil_data_comp$soil_comp_perc[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]]/soil_comp_perc_sum*100
	soil_data_comp$soil_comp_perc_mod[soil_data_comp$soil_comp_mukey == soil_mukey_list[i]] <- soil_comp_perc_list
}

# Identify soil map unit with MUKEY, soil components with COKEY, and soil horizon with CHKEY
soil_chorizon_line_data <- readLines(soil_chorizon_file_name)
#soil_chorizon_line_data <- readLines("chorizon.txt")
soil_chorizon_line_length <- length(soil_chorizon_line_data)
soil_awc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_fc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_wp <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_mukey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_cokey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chkey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_depth <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

for (i in 1:soil_chorizon_line_length) {
	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", fixed=TRUE)
#	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", extended=FALSE)
	soil_chorizon_line_split_unlist <- unlist(soil_chorizon_line_split)
	soil_awc[i] <- as.numeric(soil_chorizon_line_split_unlist[86])
	soil_fc[i] <- as.numeric(soil_chorizon_line_split_unlist[92])
	soil_wp[i] <- as.numeric(soil_chorizon_line_split_unlist[95])
	soil_chorizon_line_split_unlist_length <- length(soil_chorizon_line_split_unlist)
	soil_mukey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length]
	soil_mukey_temp2 <- unlist(strsplit(soil_mukey_temp1,"\""))[2]
	soil_mukey_temp3 <- unlist(strsplit(soil_mukey_temp2,":"))[1]
	soil_chkey_temp1 <- unlist(strsplit(soil_mukey_temp2,":"))[2]
	soil_mukey[i] <- as.numeric(soil_mukey_temp3)
	soil_chkey[i] <- as.numeric(soil_chkey_temp1)
	soil_cokey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length-1]
	soil_cokey_temp2 <- unlist(strsplit(soil_cokey_temp1,"\""))[2]
	soil_cokey_temp3 <- unlist(strsplit(soil_cokey_temp2,":"))[2]
	soil_cokey[i] <- as.numeric(soil_cokey_temp3)
	soil_top_depth <- as.numeric(soil_chorizon_line_split_unlist[7])
	soil_bottom_depth <- as.numeric(soil_chorizon_line_split_unlist[10])
	soil_depth[i] <- soil_bottom_depth - soil_top_depth
}

soil_chorizon_perc <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_comp_perc_mod2 <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chorizon_percf <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chorizon_percf_sum <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_por <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_por_frac <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_rs <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_rs_frac <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

soil_data_chorizon <- data.frame(soil_awc, soil_fc, soil_wp, soil_mukey, soil_cokey, soil_chkey, soil_depth, soil_chorizon_perc, soil_comp_perc_mod2, soil_chorizon_percf, soil_por, soil_rs, soil_por_frac, soil_rs_frac)

soil_cokey_list <- unique(soil_comp_cokey)
soil_cokey_list_length <- length(soil_cokey_list)

for (i in 1:soil_cokey_list_length) {
	soil_chorizon_perc_depth_sum <- sum(soil_data_chorizon$soil_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]], na.rm=TRUE)
	soil_chorizon_perc_list <- soil_data_chorizon$soil_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]]/soil_chorizon_perc_depth_sum*100
	soil_data_chorizon$soil_chorizon_perc[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_chorizon_perc_list
	soil_data_chorizon$soil_comp_perc_mod2[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_data_comp$soil_comp_perc_mod[soil_data_comp$soil_comp_cokey == soil_cokey_list[i]]
	soil_data_chorizon$soil_chorizon_percf <- soil_data_chorizon$soil_chorizon_perc * soil_data_chorizon$soil_comp_perc_mod2 / 10000
}

soil_data_chorizon$soil_chorizon_percf[is.na(soil_data_chorizon$soil_fc)] <- 0
soil_data_chorizon$soil_chorizon_percf[is.na(soil_data_chorizon$soil_wp)] <- 0

for (i in 1:soil_cokey_list_length) {
	soil_chorizon_percf_sum_temp <- sum(soil_data_chorizon$soil_chorizon_percf[soil_data_chorizon$soil_cokey == soil_cokey_list[i]])
	if (soil_chorizon_percf_sum_temp == 0) {
		next
	} else {
		if (soil_chorizon_percf_sum_temp != soil_data_chorizon$soil_comp_perc_mod2[soil_data_chorizon$soil_cokey == soil_cokey_list[i]][1]/100) {
			soil_chorizon_percf_list <- soil_data_chorizon$soil_chorizon_percf[soil_data_chorizon$soil_cokey == soil_cokey_list[i]]/soil_chorizon_percf_sum_temp*soil_data_chorizon$soil_comp_perc_mod2[soil_data_chorizon$soil_cokey == soil_cokey_list[i]][1]/100
			soil_data_chorizon$soil_chorizon_percf[soil_data_chorizon$soil_cokey == soil_cokey_list[i]] <- soil_chorizon_percf_list
		}
	}
}


#############################################################################################################################################


# identify texture key with chtg_key
soil_chtexture_line_data <- readLines(soil_chtexture_file_name)
#soil_chtexture_line_data <- readLines("chtextur.txt")
soil_chtexture_line_length <- length(soil_chtexture_line_data)

soil_chtexture_mukey <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_chtgkey <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_texture <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_porosity <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_residual <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)

for (i in 1:soil_chtexture_line_length) {
	soil_chtexture_line_split <- strsplit(soil_chtexture_line_data[i],"|", fixed=TRUE)
#	soil_chtexture_line_split <- strsplit(soil_chtexture_line_data[i],"|", extended=FALSE)
	soil_chtexture_line_split_unlist <- unlist(soil_chtexture_line_split)
	soil_chtexture_line_split_unlist_length <- length(soil_chtexture_line_split_unlist)
	soil_chtexture_temp1 <- soil_chtexture_line_split_unlist[soil_chtexture_line_split_unlist_length-1]
	soil_chtexture_temp2 <- unlist(strsplit(soil_chtexture_temp1,"\""))[2]
	soil_chtexture_temp3 <- unlist(strsplit(soil_chtexture_temp2,":"))[1]
	soil_chtexture_mukey[i] <- as.numeric(soil_chtexture_temp3)
	soil_chtexture_temp4 <- unlist(strsplit(soil_chtexture_temp2,":"))[2]
	soil_chtexture_chtgkey[i] <- as.numeric(soil_chtexture_temp4)
	soil_chtexture_temp5 <- soil_chtexture_line_split_unlist[1]
	soil_chtexture_texture[i] <- unlist(strsplit(soil_chtexture_temp5,"\""))[2]
}

soil_chtexture_gtexture <- soil_chtexture_texture
soil_data_chtexture <- data.frame(soil_chtexture_mukey, soil_chtexture_chtgkey, soil_chtexture_texture, soil_chtexture_gtexture, soil_chtexture_porosity, soil_chtexture_residual)

chtexture_list <- unique(soil_chtexture_texture)
chtexture_list <- chtexture_list[!is.na(chtexture_list)]
chtexture_list_length <- length(chtexture_list)

detail_texture_list <- c("Coarse sand", "Fine sand", "Very fine sand", "Loamy coarse sand", "Loamy fine sand", "Loamy very fine sand", "Coarse sandy loam", "Fine sandy loam", "Very fine sandy loam")
general_texture_list <- c("Sand", "Sand", "Sand", "Loamy sand", "Loamy sand", "Loamy sand", "Sandy loam", "Sandy loam", "Sandy loam")
texture_list <- data.frame(detail_texture_list, general_texture_list)
texture_list_length <- length(general_texture_list)

for (i in 1:texture_list_length) {
	soil_data_chtexture$soil_chtexture_gtexture[soil_data_chtexture$soil_chtexture_texture == detail_texture_list[i]] <- general_texture_list[i]
}

# identify porosity for texture key
#soil_property_data <- read.csv(soil_property_file_name)
soil_property_data <- read.csv("soil_texture_properties.csv")
soil_texture_list <- as.character(soil_property_data$Texture)
soil_texture_list <- soil_texture_list[!is.na(soil_texture_list)]
soil_texture_list_length <- length(soil_property_data$Texture)
soil_por_list <- soil_property_data$TPRep
soil_por_list <- soil_por_list[!is.na(soil_por_list)]
soil_rs_list <- soil_property_data$RSRep
soil_rs_list <- soil_rs_list[!is.na(soil_rs_list)]

for (i in 1:soil_texture_list_length) {
	soil_data_chtexture$soil_chtexture_porosity[soil_data_chtexture$soil_chtexture_gtexture == soil_texture_list[i]] <- soil_por_list[i]
	soil_data_chtexture$soil_chtexture_residual[soil_data_chtexture$soil_chtexture_gtexture == soil_texture_list[i]] <- soil_rs_list[i]
}

soil_data_chtexture$soil_chtexture_porosity <- as.numeric(soil_data_chtexture$soil_chtexture_porosity)
soil_data_chtexture$soil_chtexture_residual <- as.numeric(soil_data_chtexture$soil_chtexture_residual)

# identify group texture key (chtg_key)
soil_chtextgrp_line_data <- readLines(soil_chtextgrp_file_name)
#soil_chtextgrp_line_data <- readLines("chtexgrp.txt")
soil_chtextgrp_line_length <- length(soil_chtextgrp_line_data)

soil_chtextgrp_mukey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_chkey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_chtgkey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_porosity <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_residual <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)

for (i in 1:soil_chtextgrp_line_length) {
	soil_chtextgrp_line_split <- strsplit(soil_chtextgrp_line_data[i],"|", fixed=TRUE)
#	soil_chtextgrp_line_split <- strsplit(soil_chtextgrp_line_data[i],"|", extended=FALSE)
	soil_chtextgrp_line_split_unlist <- unlist(soil_chtextgrp_line_split)
	soil_chtextgrp_line_split_unlist_length <- length(soil_chtextgrp_line_split_unlist)
	soil_chtextgrp_temp1 <- soil_chtextgrp_line_split_unlist[soil_chtextgrp_line_split_unlist_length]
	soil_chtextgrp_temp2 <- unlist(strsplit(soil_chtextgrp_temp1,"\""))[2]
	soil_chtextgrp_temp3 <- unlist(strsplit(soil_chtextgrp_temp2,":"))[1]
	soil_chtextgrp_mukey[i] <- as.numeric(soil_chtextgrp_temp3)
	soil_chtextgrp_temp4 <- unlist(strsplit(soil_chtextgrp_temp2,":"))[2]
	soil_chtextgrp_chtgkey[i] <- as.numeric(soil_chtextgrp_temp4)
	soil_chtextgrp_temp5 <- soil_chtextgrp_line_split_unlist[soil_chtextgrp_line_split_unlist_length-1]
	soil_chtextgrp_temp6 <- unlist(strsplit(soil_chtextgrp_temp5,"\""))[2]
	soil_chtextgrp_temp7 <- unlist(strsplit(soil_chtextgrp_temp6,":"))[2]
	soil_chtextgrp_chkey[i] <- as.numeric(soil_chtextgrp_temp7)
}

soil_data_chtextgrp <- data.frame(soil_chtextgrp_mukey, soil_chtextgrp_chkey, soil_chtextgrp_chtgkey, soil_chtextgrp_porosity, soil_chtextgrp_residual)

soil_chtextgrp_chtgkey_list <- unique(soil_chtextgrp_chtgkey)
soil_chtextgrp_chtgkey_list_length <- length(soil_chtextgrp_chtgkey_list)

for (i in 1:soil_chtextgrp_chtgkey_list_length) {
	if (length(soil_data_chtextgrp$soil_chtextgrp_porosity[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]]) == length(soil_data_chtexture$soil_chtexture_porosity[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]])) {
		soil_data_chtextgrp$soil_chtextgrp_porosity[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_porosity[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]]
		soil_data_chtextgrp$soil_chtextgrp_residual[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_residual[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]]
	} else {
		soil_data_chtextgrp$soil_chtextgrp_porosity[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_porosity[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]][1]
		soil_data_chtextgrp$soil_chtextgrp_residual[soil_data_chtextgrp$soil_chtextgrp_chtgkey == soil_chtextgrp_chtgkey_list[i]] <- soil_data_chtexture$soil_chtexture_residual[soil_data_chtexture$soil_chtexture_chtgkey == soil_chtextgrp_chtgkey_list[i]][1]
	}
}

soil_chkey_list <- unique(soil_chkey)
soil_chkey_list_length <- length(soil_chkey_list)

for (i in 1:soil_chkey_list_length) {
	porosity_mean <- mean(soil_data_chtextgrp$soil_chtextgrp_porosity[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]])
	residual_mean <- mean(soil_data_chtextgrp$soil_chtextgrp_residual[soil_data_chtextgrp$soil_chtextgrp_chkey == soil_chkey_list[i]])
	soil_data_chorizon$soil_por[soil_data_chorizon$soil_chkey == soil_chkey_list[i]] <- porosity_mean
	soil_data_chorizon$soil_rs[soil_data_chorizon$soil_chkey == soil_chkey_list[i]] <- residual_mean
}

#############################################################################################################################################

soil_data_chorizon$soil_por_frac <- soil_data_chorizon$soil_por * soil_data_chorizon$soil_chorizon_percf
soil_data_chorizon$soil_rs_frac <- soil_data_chorizon$soil_rs * soil_data_chorizon$soil_chorizon_percf

soil_por_ave <- matrix(data <- NA, nrow <- soil_mukey_list_length, ncol <- 1)
soil_rs_ave <- matrix(data <- NA, nrow <- soil_mukey_list_length, ncol <- 1)

for (i in 1:soil_mukey_list_length) {
	soil_por_ave[i] <- sum(soil_data_chorizon$soil_por_frac[soil_data_chorizon$soil_mukey == soil_mukey_list[i]], na.rm=TRUE)
	soil_rs_ave[i] <- sum(soil_data_chorizon$soil_rs_frac[soil_data_chorizon$soil_mukey == soil_mukey_list[i]], na.rm=TRUE)
}

soil_data_porosity <- data.frame(soil_mukey_list, soil_por_ave)
soil_data_residual <- data.frame(soil_mukey_list, soil_rs_ave)

soil_por_mat <- matrix(data <- NA, nrow <- nrow(soil_data_mat), ncol <- ncol(soil_data_mat))
soil_rs_mat <- matrix(data <- NA, nrow <- nrow(soil_data_mat), ncol <- ncol(soil_data_mat))

soil_data_mat_list <- unique(c(soil_data_mat))
soil_data_mat_list_length <- length(soil_data_mat_list)

for (i in 2:soil_data_mat_list_length) {
	soil_por_mat[soil_data_mat == soil_data_mat_list[i]] <- soil_data_porosity$soil_por_ave[soil_data_porosity$soil_mukey_list == soil_data_mat_list[i]]
	soil_rs_mat[soil_data_mat == soil_data_mat_list[i]] <- soil_data_residual$soil_rs_ave[soil_data_residual$soil_mukey_list == soil_data_mat_list[i]]
}

soil_por_mat[soil_por_mat == 0] <- mean(soil_por_mat[soil_por_mat > 0],na.rm=TRUE)
soil_rs_mat[soil_rs_mat == 0] <- mean(soil_rs_mat[soil_rs_mat > 0],na.rm=TRUE)

soil_porosity_return_list <- list(soil_por_mat, soil_rs_mat)

return(soil_porosity_return_list)

}
