
soil_texture_loading <- function(soil_comp_file_name, soil_chorizon_file_name, soil_chtextgrp_file_name, soil_chtexture_file_name, soil_data_mat) {

# Identify percentages of components in a soil map
soil_comp_line_data <- readLines(soil_comp_file_name)
#soil_comp_line_data <- readLines("comp.txt")
soil_comp_line_length <- length(soil_comp_line_data)
soil_comp_perc <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_mukey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)
soil_comp_cokey <- matrix(data <- NA, nrow <- soil_comp_line_length, ncol <- 1)

for (i in 1:soil_comp_line_length) {
	soil_comp_line_split <- strsplit(soil_comp_line_data[i],"|", extended=FALSE)
	soil_comp_line_split_unlist <- unlist(soil_comp_line_split)
	soil_comp_line_split_unlist_length <- length(soil_comp_line_split_unlist)
	soil_comp_perc[i] <- as.numeric(soil_comp_line_split_unlist[2])
	soil_mukey_temp4 <- soil_comp_line_split_unlist[soil_comp_line_split_unlist_length]
	soil_mukey_temp5 <- unlist(strsplit(soil_mukey_temp4,"\""))[2]
	soil_mukey_temp6 <- unlist(strsplit(soil_mukey_temp5,":"))[1]
	soil_comp_mukey[i] <- as.numeric(soil_mukey_temp6)
	soil_cokey_temp4 <- unlist(strsplit(soil_mukey_temp5,":"))[2]
	soil_comp_cokey[i] <- as.numeric(soil_cokey_temp4)
}

soil_data_comp <- data.frame(soil_comp_mukey, soil_comp_cokey, soil_comp_perc)

soil_mukey_list <- unique(soil_comp_mukey)
soil_mukey_list_length <- length(soil_mukey_list)

# Identify soil map unit with MUKEY, soil components with COKEY, and soil horizon with CHKEY
soil_chorizon_line_data <- readLines(soil_chorizon_file_name)
#soil_chorizon_line_data <- readLines("chorizon.txt")
soil_chorizon_line_length <- length(soil_chorizon_line_data)
soil_mukey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_cokey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_chkey <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)
soil_top_depth <- matrix(data <- NA, nrow <- soil_chorizon_line_length, ncol <- 1)

for (i in 1:soil_chorizon_line_length) {
	soil_chorizon_line_split <- strsplit(soil_chorizon_line_data[i],"|", extended=FALSE)
	soil_chorizon_line_split_unlist <- unlist(soil_chorizon_line_split)
	soil_chorizon_line_split_unlist_length <- length(soil_chorizon_line_split_unlist)
	soil_mukey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length]
	soil_mukey_temp2 <- unlist(strsplit(soil_mukey_temp1,"\""))[2]
	soil_mukey_temp3 <- unlist(strsplit(soil_mukey_temp2,":"))[1]
	soil_chkey_temp1 <- unlist(strsplit(soil_mukey_temp2,":"))[2]
	soil_mukey[i] <- as.numeric(soil_mukey_temp3)
	soil_chkey[i] <- as.numeric(soil_chkey_temp1)
	soil_cokey_temp1 <- soil_chorizon_line_split_unlist[soil_chorizon_line_split_unlist_length-1]
	soil_cokey_temp2 <- unlist(strsplit(soil_cokey_temp1,"\""))[2]
	soil_cokey_temp3 <- unlist(strsplit(soil_cokey_temp2,":"))[2]
	soil_cokey[i] <- as.numeric(soil_cokey_temp3)
	soil_top_depth[i] <- as.numeric(soil_chorizon_line_split_unlist[7])
}

soil_data_chorizon <- data.frame(soil_mukey, soil_cokey, soil_chkey, soil_top_depth)

soil_cokey_list <- unique(soil_data_chorizon$soil_cokey)
soil_cokey_list_length <- length(soil_cokey_list)

soil_cokey_min_depth_chkey <- matrix(data <- NA, nrow <- soil_cokey_list_length, ncol <- 1)

for (i in 1:soil_cokey_list_length) {
	soil_depth_list_of_soil_cokey <- soil_data_chorizon$soil_top_depth[soil_data_chorizon$soil_cokey == soil_cokey_list[i]]
	min_depth_of_soil_cokey <- sort(soil_depth_list_of_soil_cokey)[1]	
	if (length(soil_data_chorizon$soil_chkey[soil_data_chorizon$soil_cokey == soil_cokey_list[i] & soil_data_chorizon$soil_top_depth == min_depth_of_soil_cokey]) > 1) break
	soil_cokey_min_depth_chkey[i] <- soil_data_chorizon$soil_chkey[soil_data_chorizon$soil_cokey == soil_cokey_list[i] & soil_data_chorizon$soil_top_depth == min_depth_of_soil_cokey]
}

soil_data_cokey_min_depth_chkey <- data.frame(soil_cokey_list, soil_cokey_min_depth_chkey)

soil_min_depth_chkey <- matrix(data <- NA, nrow <- length(soil_data_comp$soil_comp_mukey), ncol <- 1)
soil_data_comp <- data.frame(soil_data_comp, soil_min_depth_chkey)

soil_cokey_list_length <- length(unique(soil_data_cokey_min_depth_chkey$soil_cokey_list))

for (i in 1:soil_cokey_list_length) {
	soil_data_comp$soil_min_depth_chkey[soil_data_comp$soil_comp_cokey == soil_cokey_list[i]] <- soil_data_cokey_min_depth_chkey$soil_cokey_min_depth_chkey[soil_data_cokey_min_depth_chkey$soil_cokey_list == soil_cokey_list[i]]

}


# identify group texture key (chtg_key)
soil_chtextgrp_line_data <- readLines(soil_chtextgrp_file_name)
#soil_chtextgrp_line_data <- readLines("chtexgrp.txt")
soil_chtextgrp_line_length <- length(soil_chtextgrp_line_data)

soil_chtextgrp_mukey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_chkey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_chtgkey <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_rv <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)
soil_chtextgrp_text <- matrix(data <- NA, nrow <- soil_chtextgrp_line_length, ncol <- 1)

for (i in 1:soil_chtextgrp_line_length) {
	soil_chtextgrp_line_split <- strsplit(soil_chtextgrp_line_data[i],"|", extended=FALSE)
	soil_chtextgrp_line_split_unlist <- unlist(soil_chtextgrp_line_split)
	soil_chtextgrp_line_split_unlist_length <- length(soil_chtextgrp_line_split_unlist)
	soil_chtextgrp_temp1 <- soil_chtextgrp_line_split_unlist[soil_chtextgrp_line_split_unlist_length]
	soil_chtextgrp_temp2 <- unlist(strsplit(soil_chtextgrp_temp1,"\""))[2]
	soil_chtextgrp_temp3 <- unlist(strsplit(soil_chtextgrp_temp2,":"))[1]
	soil_chtextgrp_mukey[i] <- as.numeric(soil_chtextgrp_temp3)
	soil_chtextgrp_temp4 <- unlist(strsplit(soil_chtextgrp_temp2,":"))[2]
	soil_chtextgrp_chtgkey[i] <- as.numeric(soil_chtextgrp_temp4)
	soil_chtextgrp_temp5 <- soil_chtextgrp_line_split_unlist[soil_chtextgrp_line_split_unlist_length-1]
	soil_chtextgrp_temp6 <- unlist(strsplit(soil_chtextgrp_temp5,"\""))[2]
	soil_chtextgrp_temp7 <- unlist(strsplit(soil_chtextgrp_temp6,":"))[2]
	soil_chtextgrp_chkey[i] <- as.numeric(soil_chtextgrp_temp7)
	soil_chtextgrp_temp8 <- soil_chtextgrp_line_split_unlist[3]
	soil_chtextgrp_temp9 <- unlist(strsplit(soil_chtextgrp_temp8,"\""))[2]
	soil_chtextgrp_rv[i] <- unlist(strsplit(soil_chtextgrp_temp9," "))[1]
}

soil_data_chtextgrp <- data.frame(soil_chtextgrp_mukey, soil_chtextgrp_chkey, soil_chtextgrp_chtgkey, soil_chtextgrp_rv, soil_chtextgrp_text)

soil_chtextgrp_chtgkey_list <- unique(soil_data_chtextgrp$soil_chtextgrp_chtgkey)
soil_chtextgrp_chtgkey_list_length <- length(soil_chtextgrp_chtgkey_list)



# identify texture key with chtg_key
soil_chtexture_line_data <- readLines(soil_chtexture_file_name)
#soil_chtexture_line_data <- readLines("chtextur.txt")
soil_chtexture_line_length <- length(soil_chtexture_line_data)

soil_chtexture_mukey <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_chtgkey <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)
soil_chtexture_texture <- matrix(data <- NA, nrow <- soil_chtexture_line_length, ncol <- 1)

for (i in 1:soil_chtexture_line_length) {
	soil_chtexture_line_split <- strsplit(soil_chtexture_line_data[i],"|", extended=FALSE)
	soil_chtexture_line_split_unlist <- unlist(soil_chtexture_line_split)
	soil_chtexture_line_split_unlist_length <- length(soil_chtexture_line_split_unlist)
	soil_chtexture_temp1 <- soil_chtexture_line_split_unlist[soil_chtexture_line_split_unlist_length-1]
	soil_chtexture_temp2 <- unlist(strsplit(soil_chtexture_temp1,"\""))[2]
	soil_chtexture_temp3 <- unlist(strsplit(soil_chtexture_temp2,":"))[1]
	soil_chtexture_mukey[i] <- as.numeric(soil_chtexture_temp3)
	soil_chtexture_temp4 <- unlist(strsplit(soil_chtexture_temp2,":"))[2]
	soil_chtexture_chtgkey[i] <- as.numeric(soil_chtexture_temp4)
	soil_chtexture_temp5 <- soil_chtexture_line_split_unlist[1]
	soil_chtexture_texture[i] <- unlist(strsplit(soil_chtexture_temp5,"\""))[2]
}

soil_chtexture_gtexture <- soil_chtexture_texture
soil_data_chtexture <- data.frame(soil_chtexture_mukey, soil_chtexture_chtgkey, soil_chtexture_texture, soil_chtexture_gtexture)

chtexture_list <- unique(soil_chtexture_texture)
chtexture_list <- chtexture_list[!is.na(chtexture_list)]
chtexture_list_length <- length(chtexture_list)

detail_texture_list <- c("Coarse sand", "Fine sand", "Very fine sand", "Loamy coarse sand", "Loamy fine sand", "Loamy very fine sand", "Coarse sandy loam", "Fine sandy loam", "Very fine sandy loam")
general_texture_list <- c("Sand", "Sand", "Sand", "Loamy sand", "Loamy sand", "Loamy sand", "Sandy loam", "Sandy loam", "Sandy loam")
texture_list <- data.frame(detail_texture_list, general_texture_list)
texture_list_length <- length(general_texture_list)

for (i in 1:texture_list_length) {
	soil_data_chtexture$soil_chtexture_gtexture[soil_data_chtexture$soil_chtexture_texture == detail_texture_list[i]] <- general_texture_list[i]
}



for (i in 1: soil_chtextgrp_chtgkey_list_length) {
	soil_data_chtextgrp$soil_chtextgrp_text[soil_chtextgrp_chtgkey_list[i] == soil_data_chtextgrp$soil_chtextgrp_chtgkey] <- as.character(soil_data_chtexture$soil_chtexture_gtexture[soil_chtextgrp_chtgkey_list[i] == soil_data_chtexture$soil_chtexture_chtgkey])

}

soil_data_soil_min_depth_chkey_list <- unique(soil_data_comp$soil_min_depth_chkey)
soil_data_soil_min_depth_chkey_list_length <- length(unique(soil_data_comp$soil_min_depth_chkey))
soil_data_comp_text <- matrix(data <- NA, nrow <- length(soil_data_comp$soil_min_depth_chkey), ncol <- 1)
soil_data_comp <- data.frame(soil_data_comp, soil_data_comp_text)

temp1 <- soil_data_comp

for (i in 1:soil_data_soil_min_depth_chkey_list_length) {
	if (!is.na(soil_data_soil_min_depth_chkey_list[i])) {
		soil_data_comp$soil_data_comp_text[soil_data_comp$soil_min_depth_chkey == soil_data_soil_min_depth_chkey_list[i]] <- soil_data_chtextgrp$soil_chtextgrp_text[soil_data_chtextgrp$soil_chtextgrp_rv == "Yes" & soil_data_chtextgrp$soil_chtextgrp_chkey == soil_data_soil_min_depth_chkey_list[i]]
	}
}

soil_data_comp$soil_data_comp_text[is.na(soil_data_comp$soil_data_comp_text)] <- "Rock"

}