### derive the stream network with flow accumulation map ###

### define a function ###
stream_network_loading <- function(flow_accumulation_file_name, threshold_area_ha) {

### load stream network map from a text file ###
#fac_line_data <- readLines("owlrun_fac.txt")
fac_line_data <- readLines(flow_accumulation_file_name)
fac_line_split <- strsplit(fac_line_data, " +")
fac_line_ncols <- unlist(fac_line_split[1])
fac_map_ncols <- as.numeric(fac_line_ncols[2])
fac_line_nrows <- unlist(fac_line_split[2])
fac_map_nrows <- as.numeric(fac_line_nrows[2])
fac_line_cellsize <- unlist(fac_line_split[5])
fac_map_cellsize <- as.numeric(fac_line_cellsize[2])
fac_line_nodata <- unlist(fac_line_split[6])
fac_map_nodata <- as.numeric(fac_line_nodata[2])
fac_line_length <- length(fac_line_split)

fac_mat <- matrix(data <- NA, nrow <- fac_map_nrows, ncol <- fac_map_ncols)

for (i in 1:fac_map_nrows) {
	fac_mat[i,] <- as.numeric(unlist(fac_line_split[i+6]))
}

stnet_mat <- matrix(data <- NA, nrow <- fac_map_nrows, ncol <- fac_map_ncols)
stnet_mat[fac_mat > (threshold_area_ha*10000)/(fac_map_cellsize^2)] <- fac_mat[fac_mat > (threshold_area_ha*10000)/(fac_map_cellsize^2)]
#stnet_mat[is.na(cn_mat)] <- NA

return(stnet_mat)

}