####### iterations begin for continuous (daily) simulation
##### update a CN (or S) map daily according to the sm map
##### calculate excess runoff 

surface_flow_nonlinearCN_simulating <- function(slope_mat,slope_degree_mat,stnet_mat,ele_fd,cn2,s1,s3,cn_mat,cn_mat_nrow,cn_mat_ncol,cell_size,soil_fc_mat,soil_por_mat,soil_rs_mat,soil_wp_mat,soil_depth_mat,st_eff_por_mat,soil_ks_mat,soil_ks_ver_mat,rainfall_acc_mat_list,rainfall_length,event_simulation_length,manningn_mat,st_manningn,sm_mat,n_leng_list_f,n_leng_list_f_length,n_i_list_s,n_j_list_s,n_leng_list_s,rainfall_all,data_no,temperature_all,bs_depth_mat,st_width_mat,f_dir,st_ks_mat,st_depth_mat,gw_level_mat,percolation_vol_mat,percolation_vol_sum_mat,percolation_no,percolation_vol_mat_daily_list_temp,coeff_L,coeff_m,day_no,time_no) {

##### define the retention parameter of the CN method for the continuous modeling
### the retention parameter is updated for every events in a daily manner
### the below is for only a storm event
### thus, another outer loop will be needed for continuous modeling
### such as for (i in 1:total No. of days to be simulated) {
### if (a day that has rainfall is detected) {
### in the below example, the soil moisture is fixed to the initial moisture, "sm_initial"

##### update the retention parameter of the CN method based on the soil moisture at the beginning of a storm ###
##### CN is calculated from the nonlinear relationship between soil moisture and CN (SWAT version) #####
##### define variables #####
cn_sh_fac2 <- (log(soil_fc_mat/(1-s3/s1)-soil_fc_mat)-log((soil_por_mat*100)/(1-2.54/s1)-(soil_por_mat*100)))/((soil_por_mat*100)-soil_fc_mat)
cn_sh_fac1 <- log(soil_fc_mat/(1-s3/s1)-soil_fc_mat)+cn_sh_fac2*soil_fc_mat
#sm <- sm_mat*100
sm <- (sm_mat-soil_wp_mat/100)*100 ### fixed on 20100420 ###
sm[sm < 0] <- 0

### the retention parameter of the CN method ###
cn_s <- s1*(1-sm/(sm+exp(cn_sh_fac1-cn_sh_fac2*sm)))

### recalculate CN for the adjusted retention parameter (cn_s) ###
cn_mat <- 25400/(cn_s+254)

##### iterations begin for houly surface flow modeling
### calculate overland flow depth using the excess rainfall amount and the overland flow geometry
### flow volume comes from both of routing and excess rainfall
efv_acc_mat <- matrix(data <- NA, nrows <- cn_mat_nrow, ncols <- cn_mat_ncol)
#efv_acc_mat_list <- vector(mode="list", length=event_simulation_length)

#travel_time_hr_list <- vector(mode="list", length=event_simulation_length)

iso_area_list <- vector(mode="list", length=event_simulation_length)

over_flow_vol_sum_list <- vector(mode="list", length=event_simulation_length)

route_flow_vol_mat <- matrix(data <- NA, nrows <- cn_mat_nrow, ncols <- cn_mat_ncol)
route_flow_vol_mat[!is.na(cn_mat)] <- 0
#route_flow_vol_mat_list <- vector(mode="list", length=event_simulation_length)

#flow_acc_vol_mat_list <- vector(mode="list", length=event_simulation_length)

route_flow_acc_vol_mat <- matrix(data <- NA, nrows <- cn_mat_nrow, ncols <- cn_mat_ncol)
route_flow_acc_vol_mat[!is.na(cn_mat)] <- 0

#st_v_list <- vector(mode="list", length=event_simulation_length)
#st_depth_mat_list <- vector(mode="list", length=event_simulation_length)

sub_hydrograph_length <- event_simulation_length

### calculate travel time and define travel time map (isochrone)
### in other words, construct a hydrograph

hydrograph_drawing_time <- event_simulation_length

st_depth_max_mat <- matrix(data <- NA, nrows <- cn_mat_nrow, ncols <- cn_mat_ncol)
st_depth_max_mat[!is.na(stnet_mat)] <- 0

total_day_no <- 1

for (rain_time in 1:event_simulation_length) {

	### calculate routed flow volume ###
	if (rain_time > 1) {
		route_flow_vol_mat <- routing_calculating(travel_time_hr,efv_mat,cn_mat,ele_fd,cn_mat_nrow,cn_mat_ncol,f_dir,stnet_mat)
	} else {
		route_flow_vol_mat[!is.na(cn_mat)] <- 0
	}
#	route_flow_vol_mat_list[[rain_time]] <- route_flow_vol_mat
	route_flow_acc_vol_mat <- route_flow_acc_vol_mat + route_flow_vol_mat

	### calculate total flow volume (rainfall + route flow volume)
	if (rain_time <= rainfall_length) {
		flow_acc_vol_mat <- rainfall_acc_mat_list[[rain_time]] + route_flow_acc_vol_mat
	} else {
		flow_acc_vol_mat <- rainfall_acc_mat_list[[rainfall_length]] + route_flow_acc_vol_mat
	}
#	flow_acc_vol_mat_list[[rain_time]] <- flow_acc_vol_mat

	### calculate effective flow volume using the accumulated rainfall data, routed runoff volume, and
	### the adjusted CN based on the soil moisture
	efv_acc_mat <- effective_flow_vol_acc_calulating(flow_acc_vol_mat,cn_s,cn_mat_nrow,cn_mat_ncol)

	if (rain_time > 1) {
		efv_mat <- efv_acc_mat - efv_acc_mat_old
	} else {
		efv_mat <- efv_acc_mat
	}

	efv_acc_mat_old <- efv_acc_mat

	efv_mat[!is.na(cn_mat) & is.na(efv_mat)] <- 0

#	efv_acc_mat_list[[rain_time]] <- efv_acc_mat

	##### evaporation of water from the open water surface #####
	### and, if raintime is over the rainfall length and the maximum of the effective flow volume is less than 0.1m, then break the loop ###
#	if (rain_time > rainfall_length) {
#		time_year <- rainfall_all$Year[data_no+rain_time-1]
#		time_month <- rainfall_all$Month[data_no+rain_time-1]
#		time_day <- rainfall_all$Day[data_no+rain_time-1]
#		time_hour <- rainfall_all$Hour[data_no+rain_time-1]
#		potential_ET_hourly <- potential_ET_hourly_calculating(time_year,time_month,time_day,time_hour,temperature_all)
##		potential_ET_hourly <- 1
#		efv_mat <- efv_mat - potential_ET_hourly
#		efv_mat[efv_mat < 0] <- 0
##		if(max(efv_mat,na.rm=T) < 0.1) {
##		if(max(efv_mat[!is.na(efv_mat)]) < 0.1) { ### fixed on 20100225 ###
##			hydrograph_drawing_time <- rain_time - 1
##			break
##		}
#	}

	efv_mat[efv_mat < 0] <- 0

	### on purpose of checking ###
#	length(efv_mat[!is.na(efv_mat) & efv_mat < 0])

	### calculate travel time ###
	travel_time_return <- travel_time_calculating(efv_mat,stnet_mat,slope_mat,slope_degree_mat,manningn_mat,st_manningn,n_i_list_s,n_j_list_s,n_leng_list_s,n_leng_list_f_length,cell_size,cn_mat_nrow,cn_mat_ncol,st_depth_mat,rain_time,st_width_mat)
	travel_time_sec <- travel_time_return[[1]]
#	st_v_list[[rain_time]] <- travel_time_return[[2]]
	st_depth_mat <- travel_time_return[[3]]
#	st_depth_mat_list[[rain_time]] <- st_depth_mat
	st_depth_max_mat[!is.na(stnet_mat) & st_depth_max_mat < st_depth_mat] <- st_depth_mat[!is.na(stnet_mat) & st_depth_max_mat < st_depth_mat]

	travel_time_hr <- travel_time_sec/3600
#	travel_time_hr_list[[rain_time]] <- travel_time_hr

	### construct isochrone map ###
	sub_iso_area <- {}
	sub_over_flow_vol_sum <- {}
	iso_area_acc_old <- 0
	over_flow_vol_sum_acc_old <- 0
	for (iso_time in 1:sub_hydrograph_length) {
		iso_area_acc <- length(travel_time_hr[travel_time_hr <= iso_time & !is.na(travel_time_hr)])*cell_size^2
		over_flow_vol_sum_acc <- sum(efv_mat[travel_time_hr <= iso_time & !is.na(travel_time_hr)])
		if (iso_time >= 2) {
			iso_area <- iso_area_acc - iso_area_acc_old
			over_flow_vol_sum <- over_flow_vol_sum_acc - over_flow_vol_sum_acc_old
		} else {
			iso_area <- iso_area_acc
			over_flow_vol_sum <- over_flow_vol_sum_acc
		}
		iso_area_acc_old <- iso_area_acc
		over_flow_vol_sum_acc_old <- over_flow_vol_sum_acc
		sub_iso_area[iso_time] <- iso_area
		sub_over_flow_vol_sum[iso_time] <- over_flow_vol_sum
	}
	iso_area_list[[rain_time]] <- sub_iso_area
	over_flow_vol_sum_list[[rain_time]] <- sub_over_flow_vol_sum

	### calculate total infiltrated water volume for every cells for a rainfall event ###
	### seepaged volume from sides of the channel is not counted in calculating infiltration ###
	### because infiltration through the streambed is not considered ###
	### and the infiltration of this modeling is just for the overland flow ###

	infil_acc_vol_mat <- flow_acc_vol_mat - efv_acc_mat

	if(rain_time > 1) {
		infil_vol_mat <- infil_acc_vol_mat - infil_acc_vol_mat_old
	} else {
		infil_vol_mat <- infil_acc_vol_mat
	}

	infil_acc_vol_mat_old <- infil_acc_vol_mat

#	infil_vol_mat_list[[list_no]] <- infil_vol_mat

	##### percolation: movement of soil moisture into the vadose zone and aquifer #####
	### soil moisture is reduced by percolation ###
#	re_sat_mat <- (sm_mat*100-soil_wp_mat)/(soil_por_mat*100-soil_wp_mat)
#	re_sat_mat <- (sm_mat*100-5)/(soil_por_mat*100-5)
	re_sat_mat <- (sm_mat*100-soil_rs_mat)/(soil_por_mat*100-soil_rs_mat)
	re_sat_mat[!is.na(cn_mat) & re_sat_mat > 1] <- 1
	soil_ks_unsat_mat <- soil_ks_mat*((re_sat_mat)^coeff_L)*(1-(1-re_sat_mat^(1/coeff_m))^coeff_m)^2
	soil_ks_unsat_ver_mat <- soil_ks_ver_mat*((re_sat_mat)^coeff_L)*(1-(1-re_sat_mat^(1/coeff_m))^coeff_m)^2
			
	### unit of the saturated hydraulic conductivity is 'micrometer/s' ###
	percolation_vol_mat[!is.na(cn_mat)] <- soil_ks_unsat_ver_mat[!is.na(cn_mat)]*3600/1000

	### percolation stops when soil moisture become equal to or less than wilting point ###
	percolation_vol_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat] <- 0

#	percolation_vol_mat_sum <- percolation_vol_mat_sum + percolation_vol_mat

	### rate of deep percolation is assumed the same as the vertical saturated hydraulic conductivity ###
	#deep_percolation_vol_mat[!is.na(cn_mat)] <- soil_ks_ver_mat[!is.na(cn_mat)]*3600/1000

	### update the soil moisture (sm) with the infiltrated water volume for a rainfall evetn ###
	### unit of infil_vol_mat is mm, but that of soil_depth_mat is cm ###
	sm_mat <- sm_mat + infil_vol_mat/(soil_depth_mat*10)
	if (length(sm_mat[!is.na(sm_mat) & sm_mat > soil_por_mat]) > 0) {
		sm_mat[!is.na(sm_mat) & sm_mat > soil_por_mat] <- soil_por_mat[!is.na(sm_mat) & sm_mat > soil_por_mat]
	}

	sm_mat <- sm_mat-percolation_vol_mat/(soil_depth_mat*10)
	if (length(sm_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat]) > 0) {
		sm_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat] <- soil_wp_mat[!is.na(cn_mat) & sm_mat*100 < soil_wp_mat]/100
	}

	percolation_vol_sum_mat <- percolation_vol_sum_mat + percolation_vol_mat

	percolation_vol_mat_daily_list_temp[[total_day_no]] <- percolation_vol_sum_mat

	if (time_no == 24) {
		time_no <- 0
		percolation_vol_sum_mat <- 0
		total_day_no <- total_day_no + 1
		### fixted on 20100607 ###
		percolation_vol_mat_daily_list_temp[[total_day_no]] <- percolation_vol_sum_mat
		percolation_vol_mat_daily_list_temp[[total_day_no]][!is.na(cn_mat)] <- 0
		day_no <- day_no + 1
	}

	time_no <- time_no + 1

	if (rain_time > rainfall_length) {
#		if(max(efv_mat,na.rm=T) < 1) {
		### fixed on 20100225 ###
#		if(max(efv_mat[!is.na(efv_mat)]) < 1) {
#		if(max(efv_mat[!is.na(cn_mat)],na.rm=T) < 1) {
#		if(max(efv_mat[!is.na(cn_mat) & is.na(stnet_mat)],na.rm=T) < 1) {
#		if(mean(efv_mat[!is.na(cn_mat) & is.na(stnet_mat)],na.rm=T) < 0.5) {
		if(mean(efv_mat[!is.na(cn_mat) & is.na(stnet_mat)]) < 0.5) { ### fixed on 20100427 ###
#			efv_mat[!is.na(cn_mat) & is.na(stnet_mat)] <- 0
			efv_mat[!is.na(cn_mat)] <- 0
			hydrograph_drawing_time <- rain_time
			break
		}
	}
}

isochrone <- iso_area_list[[1]]
isochrone_vol <- over_flow_vol_sum_list[[1]]
if (hydrograph_drawing_time > 1) {
for(rain_time in 2:hydrograph_drawing_time) {
	iso_area_temp <- iso_area_list[[rain_time]]
	if ((length(iso_area_temp[iso_area_temp>0])+rain_time-1)>1) {
		if ((length(iso_area_temp[iso_area_temp>0])+rain_time-1)>sub_hydrograph_length) {
			length_iso_area_temp <- sub_hydrograph_length
			length_gab1 <- (length(iso_area_temp[iso_area_temp>0])+rain_time-1)-sub_hydrograph_length
			iso_area_temp2 <- iso_area_temp[iso_area_temp>0]
			iso_area_temp[rain_time:length_iso_area_temp] <- iso_area_temp2[1:(length(iso_area_temp2)-length_gab1)]
			iso_area_temp[1:(rain_time-1)] <- 0
		} else {
			length_iso_area_temp <- (length(iso_area_temp[iso_area_temp>0])+rain_time-1)
			iso_area_temp[rain_time:length_iso_area_temp] <- iso_area_temp[iso_area_temp>0]
			iso_area_temp[1:(rain_time-1)] <- 0
		}
	} else {
		iso_area_temp <- rep(0,sub_hydrograph_length)
	}
	isochrone <- isochrone + iso_area_temp
	over_flow_vol_sum_temp <- over_flow_vol_sum_list[[rain_time]]
	if (length(over_flow_vol_sum_temp[over_flow_vol_sum_temp>0])>0) {
		if ((length(over_flow_vol_sum_temp[over_flow_vol_sum_temp>0])+rain_time-1)>sub_hydrograph_length) {
			length_over_flow_vol_sum_temp <- sub_hydrograph_length
			length_gab2 <- (length(over_flow_vol_sum_temp[over_flow_vol_sum_temp>0])+rain_time-1)-sub_hydrograph_length
			over_flow_vol_sum_temp2 <- over_flow_vol_sum_temp[over_flow_vol_sum_temp>0]
			over_flow_vol_sum_temp[rain_time:length_over_flow_vol_sum_temp] <- over_flow_vol_sum_temp2[1:(length(over_flow_vol_sum_temp2)-length_gab2)]
			over_flow_vol_sum_temp[1:(rain_time-1)] <- 0
		} else {
			length_over_flow_vol_sum_temp <- (length(over_flow_vol_sum_temp[over_flow_vol_sum_temp>0])+rain_time-1)
			over_flow_vol_sum_temp[rain_time:length_over_flow_vol_sum_temp] <- over_flow_vol_sum_temp[over_flow_vol_sum_temp>0]
			over_flow_vol_sum_temp[1:(rain_time-1)] <- 0
		}
	} else {
		over_flow_vol_sum_temp <- rep(0,sub_hydrograph_length)
	}
	isochrone_vol <- isochrone_vol + over_flow_vol_sum_temp
}
}

#surface_flow_hydrograph_return_list <- list(isochrone_vol,efv_mat,st_efv_mat,hydrograph_drawing_time,st_depth_max_mat,sm_mat,infil_acc_vol_mat,percolation_vol_sum_mat,(time_no-1),day_no,percolation_vol_mat_daily_list_temp,total_day_no,percolation_vol_mat_sum)
surface_flow_hydrograph_return_list <- list(isochrone_vol,efv_mat,hydrograph_drawing_time,st_depth_max_mat,sm_mat,infil_acc_vol_mat,percolation_vol_sum_mat,(time_no-1),day_no,percolation_vol_mat_daily_list_temp,total_day_no)

return(surface_flow_hydrograph_return_list)

}
