### load all daily point temperature data ###

temperature_loading <- function(all_temperature_file_name) {
	
#all_temperature_data <- read.csv("all_temperature_point_daily.csv")
all_temperature_data <- read.csv(all_temperature_file_name)
all_temperature_data_length <- nrow(all_temperature_data)
all_temperature_data_width <- ncol(all_temperature_data)

### convert Fahrenheit to Celsius ###
all_temperature_data$TMAX <- (all_temperature_data$TMAX-32)*5/9
all_temperature_data$TMIN <- (all_temperature_data$TMIN-32)*5/9

ave <- rowMeans(all_temperature_data[4:all_temperature_data_width])
e0_tmin <- 0.6108*exp(17.27*all_temperature_data$TMIN/(all_temperature_data$TMIN+237.3))
e0_tmax <- 0.6108*exp(17.27*all_temperature_data$TMAX/(all_temperature_data$TMAX+237.3))
rh_min <- e0_tmin/e0_tmax*100

all_temperature_data <- data.frame(all_temperature_data,ave,rh_min)

return(all_temperature_data)

}