### calculate travel time

# viscosity of water (m2/s)
#viscosity <- 0.11148*10^-5

# define a function

travel_time_calculating <- function(efv_mat,stnet_mat,slope_mat,slope_degree_mat,manningn_mat,st_manningn,n_i_list_s,n_j_list_s,n_leng_list_s,n_leng_list_f_length,cell_size,cn_mat_nrow,cn_mat_ncol,st_depth_mat,rain_time,st_width_mat) {

### calculate unit width runoff volume ###
unit_w_runoff_vol_mat <- efv_mat/1000/3600*cell_size*cos(slope_degree_mat/180*pi)

# for laminar flow
#reynold_mat <- 4*unit_w_runoff_vol_mat/viscosity
#resistance_mat <- 96+108*efv_mat^0.4
#friction_mat <- resistance_mat/reynold_mat
#over_depth_mat <- ((friction_mat*unit_w_runoff_vol_mat^2)/(8*9.8*(slope_at/100)))^(1/3)

# for turbulent flow
over_depth_mat <- (unit_w_runoff_vol_mat*manningn_mat/((slope_mat/100)^0.5))^(3/5)
over_v_mat <- unit_w_runoff_vol_mat/over_depth_mat

# how to deal with zero runoff volume and infinite travel time?
# a way is to set the velocity of the zero runoff cell 0.00001
over_v_mat[over_depth_mat == 0] <- 0.00001
over_inv_v <- 1/over_v_mat

### assing stream velocity
# Newton-Rapson method
# assume rectangular shape, so that area = depth * width
st_v_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

st_area <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

st_depth_mat_trial <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
#st_depth_mat_gab_threshold <- 0.01 ### tried on 20100423 ###
#st_depth_mat_gab_threshold <- 0.001
st_depth_mat_gab_threshold <- 0.0001 ### fixed
st_depth_mat_gab_max <- 1
st_depth_mat_gab <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
st_depth_mat_gab[!is.na(stnet_mat)] <- 1

total_runoff_vol_mat <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
total_runoff_vol_mat[!is.na(stnet_mat)] <- unit_w_runoff_vol_mat[!is.na(stnet_mat)] * cell_size

total_runoff_vol_mat_trial <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

manningn_mat <- manningn_mat * 1
manningn_mat[!is.na(stnet_mat)] <- st_manningn
#slope_mat[!is.na(stnet_mat)] <- 2

while(st_depth_mat_gab_max > st_depth_mat_gab_threshold) {

	### the below consideration have been accounted in "cont_sim_surface.R" ###
	if (max(unit_w_runoff_vol_mat[stnet_mat[!is.na(stnet_mat)] > 0],na.rm=TRUE)==0) {
		break
	}

	if (length(st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]) == 0) {
		break
	}

	st_v_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] <- 1/manningn_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]*((slope_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]/100)^0.5)*(((st_width_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]*st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0])/(st_width_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]+2*st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]))^(2/3))
	st_area[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] <- st_width_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]*st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]
	total_runoff_vol_mat_trial[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] <- st_v_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]*st_area[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]
	st_depth_mat_trial[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] <- st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] - (1-total_runoff_vol_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]/total_runoff_vol_mat_trial[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0])/((5*st_width_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]+6*st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0])/(3*st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]*(st_width_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]+2*st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0])))
	st_depth_mat_gab[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] <- abs(st_depth_mat_trial[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]-st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0])

	if (length(c(st_depth_mat_gab[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0])) == 0) {
		break
	} else {
		st_depth_mat_gab_max <- max(c(st_depth_mat_gab[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]),na.rm=TRUE)
	}
	st_depth_mat[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0] <- st_depth_mat_trial[!is.na(stnet_mat) & st_depth_mat_gab > st_depth_mat_gab_threshold & unit_w_runoff_vol_mat > 0]
}

inv_v <- over_inv_v
zero_velocity <- 0.00001
st_v_mat[is.na(st_v_mat) & !is.na(stnet_mat)] <- zero_velocity
st_inv_v <- 1/st_v_mat
inv_v[!is.na(stnet_mat)] <- st_inv_v[!is.na(stnet_mat)]

### to check flow accumulation!
#inv_v <- matrix(data <- 1, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

n_i_list <- {}
n_j_list <- {}
n_leng_list <- {}

tr_time <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)
tr_time_sec <- matrix(data <- NA, nrow <- cn_mat_nrow, ncol <- cn_mat_ncol)

for (i in 1:n_leng_list_f_length) {
	n_i_list <- as.numeric(unlist(n_i_list_s[[i]]))
	n_j_list <- as.numeric(unlist(n_j_list_s[[i]]))
	n_leng_list <- as.numeric(unlist(n_leng_list_s[[i]]))
	tr_time_sum <- 0
	if (is.na(tr_time_sec[n_i_list[length(n_i_list)],n_j_list[length(n_i_list)]])) {
		for (j in length(n_i_list):1) {
			tr_time[n_i_list[j],n_j_list[j]] <- inv_v[n_i_list[j],n_j_list[j]]*n_leng_list[j]
			tr_time_sum <- tr_time_sum + tr_time[n_i_list[j],n_j_list[j]]
			tr_time_sec[n_i_list[j],n_j_list[j]] <- tr_time_sum
		}
	} else {
		tr_time[n_i_list[length(n_i_list)],n_j_list[length(n_j_list)]] <- tr_time_sec[n_i_list[length(n_i_list)],n_j_list[length(n_j_list)]]
		tr_time_sum <- tr_time[n_i_list[length(n_i_list)],n_j_list[length(n_j_list)]]
		if (length(n_i_list) > 1) {
			for (j in (length(n_i_list)-1):1) {
				tr_time[n_i_list[j],n_j_list[j]] <- inv_v[n_i_list[j],n_j_list[j]]*n_leng_list[j]
				tr_time_sum <- tr_time_sum + tr_time[n_i_list[j],n_j_list[j]]
				tr_time_sec[n_i_list[j],n_j_list[j]] <- tr_time_sum
			}
		} else {
			tr_time_sec[n_i_list[j],n_j_list[j]] <- tr_time_sum
		}
	}
}

travel_time_return_list <- list(tr_time_sec,st_v_mat,st_depth_mat)
#travel_time_return_list <- list(tr_time_sec,st_v_mat)

return(travel_time_return_list)

#return(tr_time_sec)

}